/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.apim.core.portal_page.model.PortalArea;
import io.gravitee.apim.core.portal_page.model.PortalNavigationFolder;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItem;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItemId;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItemQueryCriteria;
import io.gravitee.apim.core.portal_page.model.PortalNavigationLink;
import io.gravitee.apim.core.portal_page.model.PortalNavigationPage;
import io.gravitee.repository.management.api.search.PortalNavigationItemCriteria;
import io.gravitee.repository.management.model.PortalNavigationItem;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Objects;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.mapstruct.factory.Mappers;

@Mapper
public interface PortalNavigationItemAdapter {
    public static final PortalNavigationItemAdapter INSTANCE = (PortalNavigationItemAdapter)Mappers.getMapper(PortalNavigationItemAdapter.class);
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final String PORTAL_PAGE_CONTENT_ID = "portalPageContentId";
    public static final String URL = "url";

    default public PortalNavigationItem toEntity(io.gravitee.repository.management.model.PortalNavigationItem portalNavigationItem) {
        return switch (portalNavigationItem.getType()) {
            default -> throw new MatchException(null, null);
            case PortalNavigationItem.Type.FOLDER -> this.portalNavigationFolderFromRepository(portalNavigationItem);
            case PortalNavigationItem.Type.PAGE -> this.portalNavigationPageFromRepository(portalNavigationItem);
            case PortalNavigationItem.Type.LINK -> this.portalNavigationLinkFromRepository(portalNavigationItem);
        };
    }

    default public PortalArea mapArea(PortalNavigationItem.Area area) {
        return switch (area) {
            default -> throw new MatchException(null, null);
            case PortalNavigationItem.Area.HOMEPAGE -> PortalArea.HOMEPAGE;
            case PortalNavigationItem.Area.TOP_NAVBAR -> PortalArea.TOP_NAVBAR;
        };
    }

    default public PortalNavigationItem.Area mapArea(PortalArea area) {
        return switch (area) {
            default -> throw new MatchException(null, null);
            case PortalArea.HOMEPAGE -> PortalNavigationItem.Area.HOMEPAGE;
            case PortalArea.TOP_NAVBAR -> PortalNavigationItem.Area.TOP_NAVBAR;
        };
    }

    @Mapping(target="url", expression="java(parseUrl(portalNavigationItem.getConfiguration()))")
    public PortalNavigationLink portalNavigationLinkFromRepository(io.gravitee.repository.management.model.PortalNavigationItem var1);

    @Mapping(target="portalPageContentId", expression="java(PortalPageContentId.of(parsePortalPageContentId(portalNavigationItem.getConfiguration())))")
    public PortalNavigationPage portalNavigationPageFromRepository(io.gravitee.repository.management.model.PortalNavigationItem var1);

    @Mappings(value={@Mapping(target="type", expression="java(mapType(portalNavigationItem))"), @Mapping(target="configuration", expression="java(configurationOf(portalNavigationItem))")})
    public io.gravitee.repository.management.model.PortalNavigationItem toRepository(PortalNavigationItem var1);

    default public PortalNavigationItem.Type mapType(PortalNavigationItem portalNavigationItem) {
        PortalNavigationItem portalNavigationItem2 = portalNavigationItem;
        Objects.requireNonNull(portalNavigationItem2);
        PortalNavigationItem portalNavigationItem3 = portalNavigationItem2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PortalNavigationFolder.class, PortalNavigationPage.class, PortalNavigationLink.class}, (Object)portalNavigationItem3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                PortalNavigationFolder ignored = (PortalNavigationFolder)portalNavigationItem3;
                yield PortalNavigationItem.Type.FOLDER;
            }
            case 1 -> {
                PortalNavigationPage ignored = (PortalNavigationPage)portalNavigationItem3;
                yield PortalNavigationItem.Type.PAGE;
            }
            case 2 -> {
                PortalNavigationLink ignored = (PortalNavigationLink)portalNavigationItem3;
                yield PortalNavigationItem.Type.LINK;
            }
        };
    }

    default public String configurationOf(PortalNavigationItem portalNavigationItem) {
        try {
            PortalNavigationItem portalNavigationItem2 = portalNavigationItem;
            Objects.requireNonNull(portalNavigationItem2);
            PortalNavigationItem portalNavigationItem3 = portalNavigationItem2;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PortalNavigationPage.class, PortalNavigationLink.class, PortalNavigationFolder.class}, (Object)portalNavigationItem3, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    PortalNavigationPage page = (PortalNavigationPage)portalNavigationItem3;
                    HashMap<String, String> config = new HashMap<String, String>();
                    config.put(PORTAL_PAGE_CONTENT_ID, page.getPortalPageContentId().json());
                    yield OBJECT_MAPPER.writeValueAsString(config);
                }
                case 1 -> {
                    PortalNavigationLink link = (PortalNavigationLink)portalNavigationItem3;
                    HashMap<String, String> config = new HashMap<String, String>();
                    config.put(URL, link.getUrl());
                    yield OBJECT_MAPPER.writeValueAsString(config);
                }
                case 2 -> {
                    PortalNavigationFolder ignored = (PortalNavigationFolder)portalNavigationItem3;
                    yield OBJECT_MAPPER.writeValueAsString(new HashMap());
                }
            };
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to serialize configuration for PortalNavigationItem", e);
        }
    }

    @Named(value="parsePortalPageContentId")
    default public String parsePortalPageContentId(String configuration) {
        if (configuration == null || configuration.isEmpty()) {
            throw new IllegalArgumentException("PortalNavigationItem configuration is missing for PAGE type");
        }
        try {
            JsonNode node = OBJECT_MAPPER.readTree(configuration);
            return node.get(PORTAL_PAGE_CONTENT_ID).asText();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid configuration for PortalNavigationItem PAGE type", e);
        }
    }

    @Named(value="parseUrl")
    default public String parseUrl(String configuration) {
        if (configuration == null || configuration.isEmpty()) {
            throw new IllegalArgumentException("PortalNavigationItem configuration is missing for LINK type");
        }
        try {
            JsonNode node = OBJECT_MAPPER.readTree(configuration);
            return node.get(URL).asText();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid configuration for PortalNavigationItem LINK type", e);
        }
    }

    public PortalNavigationFolder portalNavigationFolderFromRepository(io.gravitee.repository.management.model.PortalNavigationItem var1);

    @Mapping(source="area", target="portalArea")
    public PortalNavigationItemCriteria map(PortalNavigationItemQueryCriteria var1);

    default public String mapPortalNavigationItemId(PortalNavigationItemId id) {
        return id != null ? id.json() : null;
    }

    default public PortalNavigationItemId mapPortalNavigationItemId(String id) {
        return id != null ? PortalNavigationItemId.of(id) : null;
    }
}

