/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.api.model.import_definition.ApiMember;
import io.gravitee.apim.core.api.model.import_definition.ApiMemberRole;
import io.gravitee.apim.core.member.model.Member;
import io.gravitee.apim.core.membership.model.Membership;
import io.gravitee.apim.core.membership.model.Role;
import io.gravitee.apim.core.user.model.BaseUserEntity;
import io.gravitee.apim.infra.adapter.MemberAdapter;
import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.permissions.RoleScope;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MemberAdapterImpl
implements MemberAdapter {
    @Override
    public ApiMember toApiMember(Membership member, BaseUserEntity user, Role role) {
        if (member == null && user == null && role == null) {
            return null;
        }
        ApiMember.ApiMemberBuilder apiMember = ApiMember.builder();
        if (member != null) {
            apiMember.id(member.getMemberId());
            apiMember.type(this.mapType(member.getMemberType()));
        }
        apiMember.displayName(user != null ? user.displayName() : null);
        apiMember.roles(role != null ? List.of(this.mapRole(role)) : null);
        return apiMember.build();
    }

    @Override
    public MemberEntity toEntity(ApiMember member) {
        if (member == null) {
            return null;
        }
        MemberEntity.MemberEntityBuilder memberEntity = MemberEntity.builder();
        memberEntity.id(member.getId());
        memberEntity.displayName(member.getDisplayName());
        memberEntity.type(member.getType());
        memberEntity.roles(this.toEntities(member.getRoles()));
        return memberEntity.build();
    }

    @Override
    public Set<MemberEntity> toEntities(Set<ApiMember> members) {
        if (members == null) {
            return null;
        }
        LinkedHashSet<MemberEntity> set = LinkedHashSet.newLinkedHashSet(members.size());
        for (ApiMember apiMember : members) {
            set.add(this.toEntity(apiMember));
        }
        return set;
    }

    @Override
    public RoleEntity toEntity(ApiMemberRole role) {
        if (role == null) {
            return null;
        }
        RoleEntity.RoleEntityBuilder roleEntity = RoleEntity.builder();
        roleEntity.name(role.getName());
        roleEntity.scope(role.getScope());
        return roleEntity.build();
    }

    @Override
    public List<RoleEntity> toEntities(List<ApiMemberRole> roles) {
        if (roles == null) {
            return null;
        }
        ArrayList<RoleEntity> list = new ArrayList<RoleEntity>(roles.size());
        for (ApiMemberRole apiMemberRole : roles) {
            list.add(this.toEntity(apiMemberRole));
        }
        return list;
    }

    @Override
    public Member toMember(MemberEntity member) {
        if (member == null) {
            return null;
        }
        Member.MemberBuilder member1 = Member.builder();
        member1.id(member.getId());
        member1.displayName(member.getDisplayName());
        member1.email(member.getEmail());
        member1.type(member.getType());
        member1.referenceType(member.getReferenceType());
        member1.referenceId(member.getReferenceId());
        member1.roles(this.roleEntityListToRoleList(member.getRoles()));
        Map map = member.getPermissions();
        if (map != null) {
            member1.permissions(new LinkedHashMap<String, char[]>(map));
        }
        member1.createdAt(member.getCreatedAt());
        member1.updatedAt(member.getUpdatedAt());
        return member1.build();
    }

    @Override
    public MemberEntity toMemberEntity(Member member) {
        if (member == null) {
            return null;
        }
        MemberEntity.MemberEntityBuilder memberEntity = MemberEntity.builder();
        memberEntity.id(member.getId());
        memberEntity.displayName(member.getDisplayName());
        memberEntity.email(member.getEmail());
        memberEntity.type(member.getType());
        memberEntity.referenceType(member.getReferenceType());
        memberEntity.referenceId(member.getReferenceId());
        memberEntity.roles(this.roleListToRoleEntityList(member.getRoles()));
        Map<String, char[]> map = member.getPermissions();
        if (map != null) {
            memberEntity.permissions(new LinkedHashMap<String, char[]>(map));
        }
        memberEntity.createdAt(member.getCreatedAt());
        memberEntity.updatedAt(member.getUpdatedAt());
        return memberEntity.build();
    }

    @Override
    public ApiMemberRole mapRole(Role role) {
        if (role == null) {
            return null;
        }
        ApiMemberRole.ApiMemberRoleBuilder apiMemberRole = ApiMemberRole.builder();
        apiMemberRole.name(role.getName());
        apiMemberRole.scope(this.scopeToRoleScope(role.getScope()));
        return apiMemberRole.build();
    }

    protected Member.Role roleEntityToRole(RoleEntity roleEntity) {
        if (roleEntity == null) {
            return null;
        }
        Member.Role.RoleBuilder role = Member.Role.builder();
        role.id(roleEntity.getId());
        role.name(roleEntity.getName());
        role.description(roleEntity.getDescription());
        role.scope(roleEntity.getScope());
        role.defaultRole(roleEntity.isDefaultRole());
        role.system(roleEntity.isSystem());
        Map map = roleEntity.getPermissions();
        if (map != null) {
            role.permissions(new LinkedHashMap<String, char[]>(map));
        }
        return role.build();
    }

    protected List<Member.Role> roleEntityListToRoleList(List<RoleEntity> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Member.Role> list1 = new ArrayList<Member.Role>(list.size());
        for (RoleEntity roleEntity : list) {
            list1.add(this.roleEntityToRole(roleEntity));
        }
        return list1;
    }

    protected RoleEntity roleToRoleEntity(Member.Role role) {
        if (role == null) {
            return null;
        }
        RoleEntity.RoleEntityBuilder roleEntity = RoleEntity.builder();
        roleEntity.id(role.getId());
        roleEntity.name(role.getName());
        roleEntity.description(role.getDescription());
        roleEntity.scope(role.getScope());
        roleEntity.defaultRole(role.isDefaultRole());
        roleEntity.system(role.isSystem());
        Map<String, char[]> map = role.getPermissions();
        if (map != null) {
            roleEntity.permissions(new LinkedHashMap<String, char[]>(map));
        }
        return roleEntity.build();
    }

    protected List<RoleEntity> roleListToRoleEntityList(List<Member.Role> list) {
        if (list == null) {
            return null;
        }
        ArrayList<RoleEntity> list1 = new ArrayList<RoleEntity>(list.size());
        for (Member.Role role : list) {
            list1.add(this.roleToRoleEntity(role));
        }
        return list1;
    }

    protected RoleScope scopeToRoleScope(Role.Scope scope) {
        if (scope == null) {
            return null;
        }
        return switch (scope) {
            case Role.Scope.API -> RoleScope.API;
            case Role.Scope.APPLICATION -> RoleScope.APPLICATION;
            case Role.Scope.GROUP -> RoleScope.GROUP;
            case Role.Scope.ENVIRONMENT -> RoleScope.ENVIRONMENT;
            case Role.Scope.ORGANIZATION -> RoleScope.ORGANIZATION;
            case Role.Scope.PLATFORM -> RoleScope.PLATFORM;
            case Role.Scope.INTEGRATION -> RoleScope.INTEGRATION;
            case Role.Scope.CLUSTER -> RoleScope.CLUSTER;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)scope));
        };
    }
}

