/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.portal_page.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.portal_page.crud_service.PortalPageContentCrudService;
import io.gravitee.apim.core.portal_page.domain_service.PortalPageContentValidatorService;
import io.gravitee.apim.core.portal_page.exception.PageContentNotFoundException;
import io.gravitee.apim.core.portal_page.model.PortalPageContent;
import io.gravitee.apim.core.portal_page.model.PortalPageContentId;
import io.gravitee.apim.core.portal_page.model.UpdatePortalPageContent;
import io.gravitee.apim.core.portal_page.query_service.PortalPageContentQueryService;
import lombok.Generated;

@UseCase
public class UpdatePortalPageContentUseCase {
    private final PortalPageContentQueryService portalPageContentQueryService;
    private final PortalPageContentValidatorService portalPageContentValidatorService;
    private final PortalPageContentCrudService portalPageContentCrudService;

    public Output execute(Input input) {
        PortalPageContent existingContent = this.portalPageContentQueryService.findById(PortalPageContentId.of(input.portalPageContentId())).orElseThrow(() -> new PageContentNotFoundException(input.portalPageContentId()));
        if (!existingContent.getOrganizationId().equals(input.organizationId()) || !existingContent.getEnvironmentId().equals(input.environmentId())) {
            throw new PageContentNotFoundException(input.portalPageContentId());
        }
        this.portalPageContentValidatorService.validateForUpdate(input.updatePortalPageContent());
        existingContent.update(input.updatePortalPageContent());
        return new Output(this.portalPageContentCrudService.update(existingContent));
    }

    @Generated
    public UpdatePortalPageContentUseCase(PortalPageContentQueryService portalPageContentQueryService, PortalPageContentValidatorService portalPageContentValidatorService, PortalPageContentCrudService portalPageContentCrudService) {
        this.portalPageContentQueryService = portalPageContentQueryService;
        this.portalPageContentValidatorService = portalPageContentValidatorService;
        this.portalPageContentCrudService = portalPageContentCrudService;
    }

    public record Input(String organizationId, String environmentId, String portalPageContentId, UpdatePortalPageContent updatePortalPageContent) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private String organizationId;
            @Generated
            private String environmentId;
            @Generated
            private String portalPageContentId;
            @Generated
            private UpdatePortalPageContent updatePortalPageContent;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder organizationId(String organizationId) {
                this.organizationId = organizationId;
                return this;
            }

            @Generated
            public InputBuilder environmentId(String environmentId) {
                this.environmentId = environmentId;
                return this;
            }

            @Generated
            public InputBuilder portalPageContentId(String portalPageContentId) {
                this.portalPageContentId = portalPageContentId;
                return this;
            }

            @Generated
            public InputBuilder updatePortalPageContent(UpdatePortalPageContent updatePortalPageContent) {
                this.updatePortalPageContent = updatePortalPageContent;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.organizationId, this.environmentId, this.portalPageContentId, this.updatePortalPageContent);
            }

            @Generated
            public String toString() {
                return "UpdatePortalPageContentUseCase.Input.InputBuilder(organizationId=" + this.organizationId + ", environmentId=" + this.environmentId + ", portalPageContentId=" + this.portalPageContentId + ", updatePortalPageContent=" + String.valueOf(this.updatePortalPageContent) + ")";
            }
        }
    }

    public record Output(PortalPageContent portalPageContent) {
    }
}

