/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.portal_page.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.portal_page.crud_service.PortalNavigationItemCrudService;
import io.gravitee.apim.core.portal_page.domain_service.PortalNavigationItemValidatorService;
import io.gravitee.apim.core.portal_page.exception.PortalNavigationItemNotFoundException;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItem;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItemId;
import io.gravitee.apim.core.portal_page.model.UpdatePortalNavigationItem;
import io.gravitee.apim.core.portal_page.query_service.PortalNavigationItemsQueryService;
import lombok.Generated;

@UseCase
public class UpdatePortalNavigationItemUseCase {
    private final PortalNavigationItemCrudService portalNavigationItemCrudService;
    private final PortalNavigationItemsQueryService portalNavigationItemsQueryService;
    private final PortalNavigationItemValidatorService validatorService;

    public Output execute(Input input) {
        UpdatePortalNavigationItem toUpdate = input.updatePortalNavigationItem;
        PortalNavigationItem existing = this.portalNavigationItemsQueryService.findByIdAndEnvironmentId(input.environmentId(), PortalNavigationItemId.of(input.navigationItemId));
        if (existing == null) {
            throw new PortalNavigationItemNotFoundException(input.navigationItemId);
        }
        this.validatorService.validateToUpdate(toUpdate, existing);
        existing.update(toUpdate);
        return new Output(this.portalNavigationItemCrudService.update(existing));
    }

    @Generated
    public UpdatePortalNavigationItemUseCase(PortalNavigationItemCrudService portalNavigationItemCrudService, PortalNavigationItemsQueryService portalNavigationItemsQueryService, PortalNavigationItemValidatorService validatorService) {
        this.portalNavigationItemCrudService = portalNavigationItemCrudService;
        this.portalNavigationItemsQueryService = portalNavigationItemsQueryService;
        this.validatorService = validatorService;
    }

    public record Input(String organizationId, String environmentId, String navigationItemId, UpdatePortalNavigationItem updatePortalNavigationItem) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private String organizationId;
            @Generated
            private String environmentId;
            @Generated
            private String navigationItemId;
            @Generated
            private UpdatePortalNavigationItem updatePortalNavigationItem;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder organizationId(String organizationId) {
                this.organizationId = organizationId;
                return this;
            }

            @Generated
            public InputBuilder environmentId(String environmentId) {
                this.environmentId = environmentId;
                return this;
            }

            @Generated
            public InputBuilder navigationItemId(String navigationItemId) {
                this.navigationItemId = navigationItemId;
                return this;
            }

            @Generated
            public InputBuilder updatePortalNavigationItem(UpdatePortalNavigationItem updatePortalNavigationItem) {
                this.updatePortalNavigationItem = updatePortalNavigationItem;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.organizationId, this.environmentId, this.navigationItemId, this.updatePortalNavigationItem);
            }

            @Generated
            public String toString() {
                return "UpdatePortalNavigationItemUseCase.Input.InputBuilder(organizationId=" + this.organizationId + ", environmentId=" + this.environmentId + ", navigationItemId=" + this.navigationItemId + ", updatePortalNavigationItem=" + String.valueOf(this.updatePortalNavigationItem) + ")";
            }
        }
    }

    public record Output(PortalNavigationItem updatedItem) {
    }
}

