/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.portal_page.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.portal_page.model.PortalArea;
import io.gravitee.apim.core.portal_page.model.PortalNavigationFolder;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItem;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItemComparator;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItemId;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItemQueryCriteria;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItemViewerContext;
import io.gravitee.apim.core.portal_page.model.PortalVisibility;
import io.gravitee.apim.core.portal_page.query_service.PortalNavigationItemsQueryService;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import lombok.Generated;

@UseCase
public class ListPortalNavigationItemsUseCase {
    private final PortalNavigationItemsQueryService queryService;
    private static final Predicate<PortalNavigationItem> IS_FOLDER_PREDICATE = i -> i instanceof PortalNavigationFolder;

    public Output execute(Input input) {
        PortalNavigationItem parentItem;
        if (input.parentId().isPresent() && (parentItem = this.findAndValidateParent(input)) == null) {
            return new Output(List.of());
        }
        List<PortalNavigationItem> rootItems = this.searchItems(input, input.parentId().orElse(null), input.parentId().isEmpty());
        ArrayList<PortalNavigationItem> allItems = new ArrayList<PortalNavigationItem>(rootItems);
        if (input.loadChildren()) {
            List<PortalNavigationItem> descendants = this.loadDescendants(rootItems, input);
            allItems.addAll(descendants);
        }
        return new Output(this.sortItems(allItems));
    }

    private PortalNavigationItem findAndValidateParent(Input input) {
        PortalNavigationItem parent = this.queryService.findByIdAndEnvironmentId(input.environmentId(), input.parentId().get());
        if (parent == null) {
            return null;
        }
        if (input.viewerContext().shouldNotShow(parent)) {
            return null;
        }
        return parent;
    }

    private List<PortalNavigationItem> loadDescendants(List<PortalNavigationItem> initialItems, Input input) {
        ArrayList<PortalNavigationItem> childrenAccumulator = new ArrayList<PortalNavigationItem>();
        LinkedList queue = new LinkedList();
        initialItems.stream().filter(IS_FOLDER_PREDICATE).forEach(queue::add);
        while (!queue.isEmpty()) {
            PortalNavigationItem currentFolder = (PortalNavigationItem)queue.removeFirst();
            List<PortalNavigationItem> foundChildren = this.searchItems(input, currentFolder.getId(), false);
            if (foundChildren.isEmpty()) continue;
            childrenAccumulator.addAll(foundChildren);
            foundChildren.stream().filter(IS_FOLDER_PREDICATE).forEach(queue::add);
        }
        return childrenAccumulator;
    }

    private List<PortalNavigationItem> searchItems(Input input, PortalNavigationItemId parentId, boolean isRootSearch) {
        PortalNavigationItemQueryCriteria.PortalNavigationItemQueryCriteriaBuilder builder = PortalNavigationItemQueryCriteria.builder().environmentId(input.environmentId()).area(input.portalArea()).parentId(parentId).root(isRootSearch);
        if (input.viewerContext().isPortalMode()) {
            builder.published(true);
            if (!input.viewerContext().isAuthenticated()) {
                builder.visibility(PortalVisibility.PUBLIC);
            }
        }
        return this.queryService.search(builder.build());
    }

    private List<PortalNavigationItem> sortItems(List<PortalNavigationItem> items) {
        return items.stream().sorted(PortalNavigationItemComparator.byNullableParentIdThenNullableOrder()).toList();
    }

    @Generated
    public ListPortalNavigationItemsUseCase(PortalNavigationItemsQueryService queryService) {
        this.queryService = queryService;
    }

    public record Input(String environmentId, PortalArea portalArea, Optional<PortalNavigationItemId> parentId, boolean loadChildren, PortalNavigationItemViewerContext viewerContext) {
    }

    public record Output(List<PortalNavigationItem> items) {
    }
}

