/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.portal_page.model;

import io.gravitee.apim.core.portal_page.exception.PortalNavigationItemNotFoundException;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItem;
import io.gravitee.apim.core.portal_page.model.PortalVisibility;

public class PortalNavigationItemViewerContext {
    private final boolean isPortalMode;
    private final boolean isAuthenticated;

    private PortalNavigationItemViewerContext(boolean isAuthenticated, boolean isPortalView) {
        this.isAuthenticated = isAuthenticated;
        this.isPortalMode = isPortalView;
    }

    public static PortalNavigationItemViewerContext forPortal(boolean isAuthenticated) {
        return new PortalNavigationItemViewerContext(isAuthenticated, true);
    }

    public static PortalNavigationItemViewerContext forConsole() {
        return new PortalNavigationItemViewerContext(true, false);
    }

    public boolean isPortalMode() {
        return this.isPortalMode;
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public boolean shouldNotShow(PortalNavigationItem item) {
        if (!this.isPortalMode) {
            return false;
        }
        if (Boolean.FALSE.equals(item.getPublished())) {
            return true;
        }
        return PortalVisibility.PRIVATE.equals((Object)item.getVisibility()) && !this.isAuthenticated;
    }

    public void validateAccess(PortalNavigationItem item) {
        if (this.shouldNotShow(item)) {
            throw new PortalNavigationItemNotFoundException(item.getId().json());
        }
    }
}

