/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.portal_page.model;

import io.gravitee.apim.core.portal_page.model.CreatePortalNavigationItem;
import io.gravitee.apim.core.portal_page.model.PortalArea;
import io.gravitee.apim.core.portal_page.model.PortalNavigationFolder;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItemId;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItemType;
import io.gravitee.apim.core.portal_page.model.PortalNavigationLink;
import io.gravitee.apim.core.portal_page.model.PortalNavigationPage;
import io.gravitee.apim.core.portal_page.model.PortalPageContentId;
import io.gravitee.apim.core.portal_page.model.PortalVisibility;
import io.gravitee.apim.core.portal_page.model.UpdatePortalNavigationItem;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Optional;
import lombok.Generated;

public abstract sealed class PortalNavigationItem
permits PortalNavigationPage, PortalNavigationLink, PortalNavigationFolder {
    @Nonnull
    private final PortalNavigationItemId id;
    @Nonnull
    private String organizationId;
    @Nonnull
    private String environmentId;
    @Nonnull
    private String title;
    @Nonnull
    private PortalArea area;
    @Nonnull
    private Integer order;
    @Nullable
    private PortalNavigationItemId parentId;
    @Nonnull
    private Boolean published;
    @Nonnull
    private PortalVisibility visibility;

    protected PortalNavigationItem(@Nonnull PortalNavigationItemId id, @Nonnull String organizationId, @Nonnull String environmentId, @Nonnull String title, @Nonnull PortalArea area, @Nonnull Integer order, @Nonnull Boolean published, @Nonnull PortalVisibility visibility) {
        this.id = id;
        this.organizationId = organizationId;
        this.environmentId = environmentId;
        this.title = title;
        this.area = area;
        this.order = order;
        this.published = published;
        this.visibility = visibility;
    }

    public abstract PortalNavigationItemType getType();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PortalNavigationItem that = (PortalNavigationItem)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "PortalNavigationItem[id=" + String.valueOf(this.id) + ", title=" + this.title + "]";
    }

    public static PortalNavigationItem from(CreatePortalNavigationItem item, String organizationId, String environmentId) {
        PortalNavigationItemId id = Optional.ofNullable(item.getId()).orElse(PortalNavigationItemId.random());
        String title = item.getTitle();
        PortalArea area = item.getArea();
        PortalNavigationItemId parentId = item.getParentId();
        PortalPageContentId contentId = item.getPortalPageContentId();
        String url = item.getUrl();
        Integer order = item.getOrder();
        PortalNavigationItem newItem = switch (item.getType()) {
            default -> throw new MatchException(null, null);
            case PortalNavigationItemType.FOLDER -> new PortalNavigationFolder(id, organizationId, environmentId, title, area, order, false, PortalVisibility.PUBLIC);
            case PortalNavigationItemType.PAGE -> new PortalNavigationPage(id, organizationId, environmentId, title, area, order, contentId, false, PortalVisibility.PUBLIC);
            case PortalNavigationItemType.LINK -> new PortalNavigationLink(id, organizationId, environmentId, title, area, order, url, false, PortalVisibility.PUBLIC);
        };
        newItem.setParentId(parentId);
        return newItem;
    }

    public void update(UpdatePortalNavigationItem navItem) {
        this.setTitle(navItem.getTitle().trim());
        this.setOrder(navItem.getOrder());
        this.setParentId(navItem.getParentId());
        this.setPublished(navItem.getPublished());
        this.setVisibility(navItem.getVisibility());
    }

    @Nonnull
    @Generated
    public PortalNavigationItemId getId() {
        return this.id;
    }

    @Nonnull
    @Generated
    public String getOrganizationId() {
        return this.organizationId;
    }

    @Nonnull
    @Generated
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @Nonnull
    @Generated
    public String getTitle() {
        return this.title;
    }

    @Nonnull
    @Generated
    public PortalArea getArea() {
        return this.area;
    }

    @Nonnull
    @Generated
    public Integer getOrder() {
        return this.order;
    }

    @Nullable
    @Generated
    public PortalNavigationItemId getParentId() {
        return this.parentId;
    }

    @Nonnull
    @Generated
    public Boolean getPublished() {
        return this.published;
    }

    @Nonnull
    @Generated
    public PortalVisibility getVisibility() {
        return this.visibility;
    }

    @Generated
    public void setOrganizationId(@Nonnull String organizationId) {
        if (organizationId == null) {
            throw new NullPointerException("organizationId is marked non-null but is null");
        }
        this.organizationId = organizationId;
    }

    @Generated
    public void setEnvironmentId(@Nonnull String environmentId) {
        if (environmentId == null) {
            throw new NullPointerException("environmentId is marked non-null but is null");
        }
        this.environmentId = environmentId;
    }

    @Generated
    public void setTitle(@Nonnull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.title = title;
    }

    @Generated
    public void setArea(@Nonnull PortalArea area) {
        if (area == null) {
            throw new NullPointerException("area is marked non-null but is null");
        }
        this.area = area;
    }

    @Generated
    public void setOrder(@Nonnull Integer order) {
        if (order == null) {
            throw new NullPointerException("order is marked non-null but is null");
        }
        this.order = order;
    }

    @Generated
    public void setParentId(@Nullable PortalNavigationItemId parentId) {
        this.parentId = parentId;
    }

    @Generated
    public void setPublished(@Nonnull Boolean published) {
        if (published == null) {
            throw new NullPointerException("published is marked non-null but is null");
        }
        this.published = published;
    }

    @Generated
    public void setVisibility(@Nonnull PortalVisibility visibility) {
        if (visibility == null) {
            throw new NullPointerException("visibility is marked non-null but is null");
        }
        this.visibility = visibility;
    }
}

