/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.portal_page.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.portal_page.crud_service.PortalNavigationItemCrudService;
import io.gravitee.apim.core.portal_page.crud_service.PortalPageContentCrudService;
import io.gravitee.apim.core.portal_page.model.CreatePortalNavigationItem;
import io.gravitee.apim.core.portal_page.model.PortalArea;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItem;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItemId;
import io.gravitee.apim.core.portal_page.model.PortalNavigationItemType;
import io.gravitee.apim.core.portal_page.model.PortalPageContent;
import io.gravitee.apim.core.portal_page.query_service.PortalNavigationItemsQueryService;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

@DomainService
public class PortalNavigationItemDomainService {
    private final PortalNavigationItemCrudService crudService;
    private final PortalNavigationItemsQueryService queryService;
    private final PortalPageContentCrudService pageContentCrudService;

    public PortalNavigationItem create(String organizationId, String environmentId, CreatePortalNavigationItem createPortalNavigationItem) {
        Integer order = createPortalNavigationItem.getOrder();
        int newMaxOrder = this.retrieveSiblingItems(createPortalNavigationItem.getParentId(), environmentId, createPortalNavigationItem.getArea()).size();
        createPortalNavigationItem.setOrder(order == null ? newMaxOrder : Math.min(order, newMaxOrder));
        if (createPortalNavigationItem.getType() == PortalNavigationItemType.PAGE && createPortalNavigationItem.getPortalPageContentId() == null) {
            PortalPageContent defaultPageContent = this.pageContentCrudService.createDefault(organizationId, environmentId);
            createPortalNavigationItem.setPortalPageContentId(defaultPageContent.getId());
        }
        PortalNavigationItem portalNavigationItem = this.crudService.create(PortalNavigationItem.from(createPortalNavigationItem, organizationId, environmentId));
        this.retrieveSiblingItems(portalNavigationItem.getParentId(), portalNavigationItem.getEnvironmentId(), createPortalNavigationItem.getArea()).stream().filter(item -> !Objects.equals(item.getId(), portalNavigationItem.getId())).filter(sibling -> sibling.getOrder() >= portalNavigationItem.getOrder()).forEach(followingSibling -> {
            followingSibling.setOrder(followingSibling.getOrder() + 1);
            this.crudService.update((PortalNavigationItem)followingSibling);
        });
        return portalNavigationItem;
    }

    private List<PortalNavigationItem> retrieveSiblingItems(PortalNavigationItemId parentId, String environmentId, PortalArea area) {
        return parentId != null ? this.queryService.findByParentIdAndEnvironmentId(environmentId, parentId) : this.queryService.findTopLevelItemsByEnvironmentIdAndPortalArea(environmentId, area);
    }

    @Generated
    public PortalNavigationItemDomainService(PortalNavigationItemCrudService crudService, PortalNavigationItemsQueryService queryService, PortalPageContentCrudService pageContentCrudService) {
        this.crudService = crudService;
        this.queryService = queryService;
        this.pageContentCrudService = pageContentCrudService;
    }
}

