/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.plan.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.documentation.crud_service.PageCrudService;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.exception.ValidationDomainException;
import io.gravitee.apim.core.parameters.model.ParameterContext;
import io.gravitee.apim.core.parameters.query_service.ParametersQueryService;
import io.gravitee.apim.core.plan.exception.PlanInvalidException;
import io.gravitee.apim.core.plan.exception.UnauthorizedPlanSecurityTypeException;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.policy.domain_service.PolicyValidationDomainService;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.listener.ListenerType;
import io.gravitee.definition.model.v4.plan.PlanMode;
import io.gravitee.definition.model.v4.plan.PlanSecurity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.v4.plan.PlanSecurityType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService
public class PlanValidatorDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlanValidatorDomainService.class);
    private final ParametersQueryService parametersQueryService;
    private final PolicyValidationDomainService policyValidationDomainService;
    private final PageCrudService pageCrudService;

    public PlanValidatorDomainService(ParametersQueryService parametersQueryService, PolicyValidationDomainService policyValidationDomainService, PageCrudService pageCrudService) {
        this.parametersQueryService = parametersQueryService;
        this.policyValidationDomainService = policyValidationDomainService;
        this.pageCrudService = pageCrudService;
    }

    public void validatePlanSecurity(Plan plan, String currentOrganizationId, String currentEnvironmentId, ApiType apiType) {
        PlanMode planMode = plan.getPlanMode();
        PlanSecurity security = plan.getPlanSecurity();
        if (planMode.equals((Object)PlanMode.STANDARD)) {
            if (security == null) {
                throw new PlanInvalidException("Security type is required for plan with 'STANDARD' mode");
            }
            this.ensurePlanSecurityIsAllowed(security.getType(), currentOrganizationId, currentEnvironmentId);
            this.policyValidationDomainService.validateAndSanitizeConfiguration(security.getType(), security.getConfiguration());
        }
        if (planMode.equals((Object)PlanMode.PUSH)) {
            if (security != null) {
                throw new PlanInvalidException("Security type is forbidden for plan with 'Push' mode");
            }
            if (ApiType.NATIVE.equals((Object)apiType)) {
                throw new PlanInvalidException("Plan mode 'Push' is forbidden for Native APIs");
            }
        }
    }

    public void validatePlanTagsAgainstApiTags(Set<String> planTags, Set<String> apiTags) {
        block2: {
            block3: {
                if (CollectionUtils.isEmpty(planTags)) break block2;
                if (CollectionUtils.isEmpty(apiTags)) break block3;
                if (!apiTags.stream().noneMatch(planTags::contains)) break block2;
            }
            log.debug("Plan rejected, tags {} mismatch the tags defined by the API ({})", planTags, apiTags);
            throw new ValidationDomainException("Plan tags mismatch the tags defined by the API", Map.of("planTags", String.join((CharSequence)",", planTags), "apiTags", String.join((CharSequence)",", apiTags)));
        }
    }

    public void validateGeneralConditionsPage(Plan plan, List<Page> pages) {
        if (plan.getGeneralConditions() != null && !plan.getGeneralConditions().isEmpty() && (plan.isPublished() || plan.isDeprecated())) {
            Optional<Page> candidate = pages.stream().filter(page -> page.getId().equals(plan.getGeneralConditions())).findFirst();
            if (candidate.isEmpty()) {
                throw new ValidationDomainException("Plan references a non existing page as general conditions");
            }
            boolean isPublished = candidate.get().isPublished();
            if (!isPublished) {
                throw new ValidationDomainException("Plan references a non published page as general conditions");
            }
        }
    }

    public void validateGeneralConditionsPageStatus(Plan plan) {
        if (plan.getGeneralConditions() != null && !plan.getGeneralConditions().isEmpty() && (plan.isPublished() || plan.isDeprecated())) {
            Optional<Page> page = this.pageCrudService.findById(plan.getGeneralConditions());
            if (page.isEmpty()) {
                return;
            }
            boolean isPublished = page.map(Page::isPublished).orElse(false);
            if (!isPublished) {
                throw new ValidationDomainException("Plan references a non published page as general conditions");
            }
        }
    }

    private void ensurePlanSecurityIsAllowed(String securityType, String currentOrganizationId, String currentEnvironmentId) {
        Key securityKey;
        PlanSecurityType planSecurityType = PlanSecurityType.valueOfLabel((String)securityType);
        switch (planSecurityType) {
            default: {
                throw new MatchException(null, null);
            }
            case API_KEY: {
                Key key = Key.PLAN_SECURITY_APIKEY_ENABLED;
                break;
            }
            case KEY_LESS: {
                Key key = Key.PLAN_SECURITY_KEYLESS_ENABLED;
                break;
            }
            case JWT: {
                Key key = Key.PLAN_SECURITY_JWT_ENABLED;
                break;
            }
            case OAUTH2: {
                Key key = Key.PLAN_SECURITY_OAUTH2_ENABLED;
                break;
            }
            case MTLS: {
                Key key = securityKey = Key.PLAN_SECURITY_MTLS_ENABLED;
            }
        }
        if (!this.parametersQueryService.findAsBoolean(securityKey, new ParameterContext(currentEnvironmentId, currentOrganizationId, ParameterReferenceType.ENVIRONMENT))) {
            throw new UnauthorizedPlanSecurityTypeException(planSecurityType.name());
        }
    }

    public void validatePlanSecurityAgainstEntrypoints(PlanSecurity planSecurity, List<ListenerType> listenerTypes) {
        if (listenerTypes.contains(ListenerType.TCP) && !PlanSecurityType.KEY_LESS.getLabel().equals(planSecurity.getType()) && !PlanSecurityType.MTLS.getLabel().equals(planSecurity.getType())) {
            throw new UnauthorizedPlanSecurityTypeException(planSecurity.getType());
        }
        if (listenerTypes.contains(ListenerType.KAFKA) && planSecurity != null && PlanSecurityType.MTLS.getLabel().equals(planSecurity.getType())) {
            throw new UnauthorizedPlanSecurityTypeException(planSecurity.getType());
        }
    }
}

