/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.log.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.log.crud_service.AggregatedMessageLogCrudService;
import io.gravitee.apim.core.log.model.AggregatedMessageLog;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import io.gravitee.rest.api.model.v4.log.SearchLogsResponse;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.List;
import java.util.Optional;

@UseCase
public class SearchApiAggregatedMessageLogsUseCase {
    private final AggregatedMessageLogCrudService messageLogCrudService;

    public SearchApiAggregatedMessageLogsUseCase(AggregatedMessageLogCrudService messageLogCrudService) {
        this.messageLogCrudService = messageLogCrudService;
    }

    public Output execute(ExecutionContext executionContext, Input input) {
        Pageable pageable = input.pageable.orElse((Pageable)new PageableImpl(1, 20));
        SearchLogsResponse<AggregatedMessageLog> response = this.messageLogCrudService.searchApiAggregatedMessageLog(executionContext, input.apiId(), input.requestId(), pageable);
        return this.mapToResponse(response);
    }

    private Output mapToResponse(SearchLogsResponse<AggregatedMessageLog> logs) {
        long total = logs.total();
        List data = logs.logs();
        return new Output(total, data);
    }

    public record Input(String apiId, String requestId, Optional<Pageable> pageable) {
        public Input(String apiId, String requestId) {
            this(apiId, requestId, Optional.empty());
        }

        public Input(String apiId, String requestId, Pageable pageable) {
            this(apiId, requestId, Optional.of(pageable));
        }
    }

    public record Output(long total, List<AggregatedMessageLog> data) {
    }
}

