/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.event.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.event.model.Event;
import io.gravitee.apim.core.event.model.EventWithInitiator;
import io.gravitee.apim.core.event.query_service.EventQueryService;
import io.gravitee.apim.core.user.crud_service.UserCrudService;
import io.gravitee.apim.core.user.model.BaseUserEntity;
import java.util.Optional;

@UseCase
public class SearchApiEventUseCase {
    private final EventQueryService eventQueryService;
    private final UserCrudService userCrudService;

    public SearchApiEventUseCase(EventQueryService eventQueryService, UserCrudService userCrudService) {
        this.eventQueryService = eventQueryService;
        this.userCrudService = userCrudService;
    }

    public Output execute(Input input) {
        return this.eventQueryService.findByIdForEnvironmentAndApi(input.eventId, input.environmentId, input.apiId).map(event -> new Output(this.toEventWithInitiator((Event)event))).orElse(new Output());
    }

    private EventWithInitiator toEventWithInitiator(Event event) {
        Optional<BaseUserEntity> initiator = Optional.ofNullable(event.getProperties().get((Object)Event.EventProperties.USER)).map(userId -> this.userCrudService.findBaseUserById((String)userId).orElse(BaseUserEntity.builder().id((String)userId).build()));
        return new EventWithInitiator(event, initiator.orElse(null));
    }

    public record Input(String eventId, String environmentId, String apiId) {
    }

    public record Output(Optional<EventWithInitiator> apiEvent) {
        Output(EventWithInitiator apiEvent) {
            this(Optional.of(apiEvent));
        }

        Output() {
            this(Optional.empty());
        }
    }
}

