/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api_health.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.exception.ApiNotFoundException;
import io.gravitee.apim.core.api.exception.TcpProxyNotSupportedException;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api_health.model.HealthCheckLog;
import io.gravitee.apim.core.api_health.query_service.ApiHealthQueryService;
import io.gravitee.common.data.domain.Page;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import java.time.Instant;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class SearchHealthCheckLogsUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchHealthCheckLogsUseCase.class);
    private final ApiHealthQueryService apiHealthQueryService;
    private final ApiCrudService apiCrudService;

    public Maybe<Output> execute(Input input) {
        Pageable pageable = input.pageable.orElse((Pageable)new PageableImpl(1, 10));
        return this.validateApiRequirements(input).flatMapMaybe(api -> this.apiHealthQueryService.searchLogs(new ApiHealthQueryService.SearchLogsQuery(input.organizationId, input.environmentId, input.apiId, input.from, input.to, input.success, pageable))).map(Output::new);
    }

    private Single<Api> validateApiRequirements(Input input) {
        return Single.fromCallable(() -> this.apiCrudService.get(input.apiId())).flatMap(api -> SearchHealthCheckLogsUseCase.validateApiMultiTenancyAccess(api, input.environmentId())).flatMap(this::validateApiIsNotTcp);
    }

    private Single<Api> validateApiIsNotTcp(Api api) {
        return api.isTcpProxy() ? Single.error((Throwable)new TcpProxyNotSupportedException(api.getId())) : Single.just((Object)api);
    }

    private static Single<Api> validateApiMultiTenancyAccess(Api api, String environmentId) {
        return !api.belongsToEnvironment(environmentId) ? Single.error((Throwable)new ApiNotFoundException(api.getId())) : Single.just((Object)api);
    }

    @Generated
    public SearchHealthCheckLogsUseCase(ApiHealthQueryService apiHealthQueryService, ApiCrudService apiCrudService) {
        this.apiHealthQueryService = apiHealthQueryService;
        this.apiCrudService = apiCrudService;
    }

    public record Input(String organizationId, String environmentId, String apiId, Instant from, Instant to, Optional<Boolean> success, Optional<Pageable> pageable) {
    }

    public record Output(Page<HealthCheckLog> logs) {
    }
}

