/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.domain_service.import_definition;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.documentation.domain_service.ApiDocumentationDomainService;
import io.gravitee.apim.core.documentation.domain_service.CreateApiDocumentationDomainService;
import io.gravitee.apim.core.documentation.domain_service.UpdateApiDocumentationDomainService;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.common.utils.TimeProvider;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@DomainService
class ImportDefinitionPageDomainService {
    private final ApiDocumentationDomainService apiDocumentationDomainService;
    private final CreateApiDocumentationDomainService createApiDocumentationDomainService;
    private final UpdateApiDocumentationDomainService updateApiDocumentationDomainService;

    ImportDefinitionPageDomainService(ApiDocumentationDomainService apiDocumentationDomainService, CreateApiDocumentationDomainService createApiDocumentationDomainService, UpdateApiDocumentationDomainService updateApiDocumentationDomainService) {
        this.apiDocumentationDomainService = apiDocumentationDomainService;
        this.createApiDocumentationDomainService = createApiDocumentationDomainService;
        this.updateApiDocumentationDomainService = updateApiDocumentationDomainService;
    }

    void upsertPages(String apiId, List<Page> pagesToImport, AuditInfo auditInfo) {
        if (pagesToImport == null || pagesToImport.isEmpty()) {
            return;
        }
        List<Page> savedPages = this.apiDocumentationDomainService.getApiPages(apiId, null);
        Map pageMap = savedPages.stream().collect(Collectors.toMap(Page::getCrossId, Function.identity()));
        Date now = Date.from(TimeProvider.now().toInstant());
        for (Page importedPage : pagesToImport) {
            Page existingPage = (Page)pageMap.get(importedPage.getCrossId());
            Page.PageBuilder pageToSave = importedPage.toBuilder().referenceType(Page.ReferenceType.API).referenceId(apiId).updatedAt(now);
            if (existingPage == null) {
                this.createApiDocumentationDomainService.createPage(pageToSave.createdAt(now).build(), auditInfo);
                continue;
            }
            this.updateApiDocumentationDomainService.updatePage(pageToSave.build(), existingPage, auditInfo);
        }
    }
}

