/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.analytics_engine.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.analytics_engine.domain_service.AnalyticsQueryValidator;
import io.gravitee.apim.core.analytics_engine.domain_service.BucketNamesPostProcessor;
import io.gravitee.apim.core.analytics_engine.domain_service.FilterPreProcessor;
import io.gravitee.apim.core.analytics_engine.model.FacetsRequest;
import io.gravitee.apim.core.analytics_engine.model.FacetsResponse;
import io.gravitee.apim.core.analytics_engine.model.Filter;
import io.gravitee.apim.core.analytics_engine.model.MetricsContext;
import io.gravitee.apim.core.analytics_engine.query_service.AnalyticsEngineQueryService;
import io.gravitee.apim.core.analytics_engine.service_provider.AnalyticsQueryContextProvider;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@UseCase
public class ComputeFacetsUseCase {
    private final AnalyticsQueryContextProvider queryContextProvider;
    private final AnalyticsQueryValidator validator;
    private final FilterPreProcessor filterPreprocessor;
    private final BucketNamesPostProcessor bucketNamesPostprocessor;

    public ComputeFacetsUseCase(AnalyticsQueryContextProvider queryContextResolver, AnalyticsQueryValidator validator, FilterPreProcessor filterPreprocessor, BucketNamesPostProcessor bucketNamesPostprocessor) {
        this.queryContextProvider = queryContextResolver;
        this.validator = validator;
        this.filterPreprocessor = filterPreprocessor;
        this.bucketNamesPostprocessor = bucketNamesPostprocessor;
    }

    public Output execute(Input input) {
        this.validator.validateFacetsRequest(input.request);
        ExecutionContext executionContext = new ExecutionContext(input.auditInfo.organizationId(), input.auditInfo.environmentId());
        MetricsContext metricsContextWithPermissions = this.filterPreprocessor.buildFilters(new MetricsContext(input.auditInfo));
        Map<AnalyticsEngineQueryService, FacetsRequest> queryContext = this.queryContextProvider.resolve(input.request);
        List<FacetsResponse> responses = this.executeQueries(executionContext, metricsContextWithPermissions, queryContext);
        FacetsResponse response = FacetsResponse.merge(responses);
        FacetsResponse mappedResponse = this.bucketNamesPostprocessor.mapBucketNames(metricsContextWithPermissions, input.request.facets(), response);
        return new Output(mappedResponse);
    }

    private List<FacetsResponse> executeQueries(ExecutionContext executionContext, MetricsContext metricsContext, Map<AnalyticsEngineQueryService, FacetsRequest> queryContext) {
        ArrayList<FacetsResponse> responses = new ArrayList<FacetsResponse>();
        queryContext.forEach((queryService, request) -> {
            ArrayList<Filter> filters = new ArrayList<Filter>(request.filters());
            filters.addAll(metricsContext.filters());
            responses.add(queryService.searchFacets(executionContext, request.withFilters(filters)));
        });
        return responses;
    }

    public record Input(AuditInfo auditInfo, FacetsRequest request) {
    }

    public record Output(FacetsResponse response) {
    }
}

