/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.analytics_engine.service_provider;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.analytics_engine.exception.UnsupportedMetricException;
import io.gravitee.apim.core.analytics_engine.model.FacetMetricMeasuresRequest;
import io.gravitee.apim.core.analytics_engine.model.FacetsRequest;
import io.gravitee.apim.core.analytics_engine.model.MeasuresRequest;
import io.gravitee.apim.core.analytics_engine.model.MetricMeasuresRequest;
import io.gravitee.apim.core.analytics_engine.model.MetricSpec;
import io.gravitee.apim.core.analytics_engine.model.TimeSeriesRequest;
import io.gravitee.apim.core.analytics_engine.query_service.AnalyticsEngineQueryService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@DomainService
public class AnalyticsQueryContextProvider {
    private final Map<MetricSpec.Name, AnalyticsEngineQueryService> services = new HashMap<MetricSpec.Name, AnalyticsEngineQueryService>();

    public AnalyticsQueryContextProvider(List<AnalyticsEngineQueryService> impl) {
        for (AnalyticsEngineQueryService service : impl) {
            for (MetricSpec.Name metric : service.metrics()) {
                this.services.put(metric, service);
            }
        }
    }

    public Map<AnalyticsEngineQueryService, MeasuresRequest> resolve(MeasuresRequest measureRequest) {
        HashMap<AnalyticsEngineQueryService, MeasuresRequest> context = new HashMap<AnalyticsEngineQueryService, MeasuresRequest>();
        for (MetricMeasuresRequest metric : measureRequest.metrics()) {
            AnalyticsEngineQueryService service = this.resolve(metric.name());
            MeasuresRequest request = context.computeIfAbsent(service, s -> measureRequest.emptyMetrics());
            request.metrics().add(metric);
        }
        return context;
    }

    public Map<AnalyticsEngineQueryService, FacetsRequest> resolve(FacetsRequest facetsRequest) {
        HashMap<AnalyticsEngineQueryService, FacetsRequest> context = new HashMap<AnalyticsEngineQueryService, FacetsRequest>();
        for (FacetMetricMeasuresRequest metric : facetsRequest.metrics()) {
            AnalyticsEngineQueryService service = this.resolve(metric.name());
            FacetsRequest request = context.computeIfAbsent(service, s -> facetsRequest.emptyMetrics());
            request.metrics().add(metric);
        }
        return context;
    }

    public Map<AnalyticsEngineQueryService, TimeSeriesRequest> resolve(TimeSeriesRequest timeSeriesRequest) {
        HashMap<AnalyticsEngineQueryService, TimeSeriesRequest> context = new HashMap<AnalyticsEngineQueryService, TimeSeriesRequest>();
        for (FacetMetricMeasuresRequest metric : timeSeriesRequest.metrics()) {
            AnalyticsEngineQueryService service = this.resolve(metric.name());
            TimeSeriesRequest request = context.computeIfAbsent(service, s -> timeSeriesRequest.emptyMetrics());
            request.metrics().add(metric);
        }
        return context;
    }

    public AnalyticsEngineQueryService resolve(MetricSpec.Name metric) {
        return Optional.ofNullable(this.services.get((Object)metric)).orElseThrow(() -> new UnsupportedMetricException(metric.name()));
    }
}

