/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.analytics_engine.query_service;

import io.gravitee.apim.core.analytics_engine.model.ApiSpec;
import io.gravitee.apim.core.analytics_engine.model.FacetSpec;
import io.gravitee.apim.core.analytics_engine.model.FilterSpec;
import io.gravitee.apim.core.analytics_engine.model.MetricSpec;
import io.gravitee.apim.core.exception.ValidationDomainException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface AnalyticsDefinitionQueryService {
    public List<ApiSpec> getApis();

    public List<MetricSpec> getMetrics(ApiSpec.Name var1);

    public List<FilterSpec> getFilters(MetricSpec.Name var1);

    public List<FacetSpec> getFacets(MetricSpec.Name var1);

    public Optional<MetricSpec> findMetric(MetricSpec.Name var1);

    default public ApiSpec.Name validateApiName(String apiName) {
        try {
            return ApiSpec.Name.valueOf(apiName);
        }
        catch (IllegalArgumentException e) {
            throw new ValidationDomainException("Invalid api name", Map.of("invalidName", apiName, "validNames", Arrays.toString((Object[])ApiSpec.Name.values())));
        }
    }

    default public MetricSpec.Name validateMetricName(String metricName) {
        try {
            return MetricSpec.Name.valueOf(metricName);
        }
        catch (IllegalArgumentException e) {
            throw new ValidationDomainException("Invalid metric name", Map.of("invalidName", metricName, "validNames", Arrays.toString((Object[])MetricSpec.Name.values())));
        }
    }
}

