/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.analytics_engine.exception;

import io.gravitee.apim.core.exception.ValidationDomainException;

public class InvalidQueryException
extends ValidationDomainException {
    public InvalidQueryException(String message) {
        super(message);
    }

    public static InvalidQueryException forMaximumFacetsExceeded(int allowed, int actual) {
        return new InvalidQueryException("Cannot query for more than " + allowed + " facets, got " + actual);
    }

    public static InvalidQueryException forEmptyFacets() {
        return new InvalidQueryException("Query must provide at least one facet in the by clause");
    }

    public static InvalidQueryException forZeroOrNegativeInterval(Long interval) {
        return new InvalidQueryException("Negative or zero intervals cannot be used in a time series query");
    }

    public static InvalidQueryException forInvalidSort(String measure) {
        return new InvalidQueryException("Trying to sort by " + measure + " but it has not been queried");
    }

    public static InvalidQueryException forIncompatibleFacet(String facet, String metric) {
        return new InvalidQueryException("Facet " + facet + " is not supported for metric " + metric);
    }

    public static InvalidQueryException forForbiddenRanges(String facet) {
        return new InvalidQueryException("Facet " + facet + " does not support ranging");
    }

    public static InvalidQueryException forInvalidTimeRangeBounds() {
        return new InvalidQueryException("Time range upper bound must be greater than lower bound");
    }

    public static InvalidQueryException forInvalidMeasure(String metric, String measure) {
        return new InvalidQueryException("Measure " + measure + " is not supported for metric " + metric);
    }
}

