/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.analytics_engine.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.analytics_engine.exception.InternalDefinitionException;
import io.gravitee.apim.core.analytics_engine.exception.InvalidQueryException;
import io.gravitee.apim.core.analytics_engine.model.FacetMetricMeasuresRequest;
import io.gravitee.apim.core.analytics_engine.model.FacetSpec;
import io.gravitee.apim.core.analytics_engine.model.FacetsRequest;
import io.gravitee.apim.core.analytics_engine.model.MeasuresRequest;
import io.gravitee.apim.core.analytics_engine.model.MetricMeasuresRequest;
import io.gravitee.apim.core.analytics_engine.model.MetricSpec;
import io.gravitee.apim.core.analytics_engine.model.NumberRange;
import io.gravitee.apim.core.analytics_engine.model.TimeRange;
import io.gravitee.apim.core.analytics_engine.model.TimeSeriesRequest;
import io.gravitee.apim.core.analytics_engine.query_service.AnalyticsDefinitionQueryService;
import io.gravitee.apim.core.utils.CollectionUtils;
import java.util.List;

@DomainService
public class AnalyticsQueryValidator {
    private static final int MAX_FACETS_QUERY_FACETS_SIZE = 3;
    private static final int MAX_TIME_SERIES_QUERY_FACETS_SIZE = 2;
    private final AnalyticsDefinitionQueryService definition;

    public AnalyticsQueryValidator(AnalyticsDefinitionQueryService analyticsDefinitionQueryService) {
        this.definition = analyticsDefinitionQueryService;
    }

    public void validateMeasuresRequest(MeasuresRequest request) {
        this.validateTimeRange(request.timeRange());
        this.validateMetricsAndMeasures(request.metrics());
    }

    public void validateFacetsRequest(FacetsRequest request) {
        this.validateTimeRange(request.timeRange());
        this.validateFacetsSize(request);
        this.validateFacetMetricsAndMeasures(request.metrics());
        this.validateFacets(request.facets(), request.metrics());
        this.validateRanges(request.facets(), request.ranges());
        this.validateSorts(request.metrics());
    }

    public void validateTimeSeriesRequest(TimeSeriesRequest request) {
        this.validateTimeRange(request.timeRange());
        this.validateFacetsSize(request);
        this.validateFacetMetricsAndMeasures(request.metrics());
        this.validateFacets(request.facets(), request.metrics());
        this.validateRanges(request.facets(), request.ranges());
        this.validateSorts(request.metrics());
        this.validateInterval(request.interval());
    }

    private void validateInterval(Long interval) {
        if (interval <= 0L) {
            throw InvalidQueryException.forZeroOrNegativeInterval(interval);
        }
    }

    private void validateSorts(List<FacetMetricMeasuresRequest> metrics) {
        for (FacetMetricMeasuresRequest metric : metrics) {
            if (metric.sorts() == null || metric.sorts().isEmpty()) continue;
            for (FacetMetricMeasuresRequest.Sort sort : metric.sorts()) {
                if (metric.measures().contains((Object)sort.measure())) continue;
                throw InvalidQueryException.forInvalidSort(sort.measure().name());
            }
        }
    }

    private void validateFacets(List<FacetSpec.Name> facets, List<FacetMetricMeasuresRequest> metrics) {
        for (FacetMetricMeasuresRequest metric : metrics) {
            MetricSpec metricSpec = this.definition.findMetric(metric.name()).orElseThrow(() -> InternalDefinitionException.forUnknownMetric(metric.name().name()));
            for (FacetSpec.Name facet : facets) {
                if (metricSpec.facets().contains((Object)facet)) continue;
                throw InvalidQueryException.forIncompatibleFacet(facet.name(), metric.name().name());
            }
        }
    }

    private void validateRanges(List<FacetSpec.Name> facets, List<NumberRange> ranges) throws InvalidQueryException {
        if (CollectionUtils.isEmpty(facets)) {
            return;
        }
        FacetSpec.Name rangedFacet = facets.getLast();
        if (rangedFacet == FacetSpec.Name.HTTP_STATUS_CODE_GROUP && CollectionUtils.isNotEmpty(ranges)) {
            throw InvalidQueryException.forForbiddenRanges(rangedFacet.name());
        }
    }

    private void validateFacetsSize(FacetsRequest request) {
        if (CollectionUtils.isEmpty(request.facets())) {
            throw InvalidQueryException.forEmptyFacets();
        }
        if (request.facets().size() > 3) {
            throw InvalidQueryException.forMaximumFacetsExceeded(3, request.facets().size());
        }
    }

    private void validateFacetsSize(TimeSeriesRequest request) {
        if (request.facets().size() > 2) {
            throw InvalidQueryException.forMaximumFacetsExceeded(2, request.facets().size());
        }
    }

    private void validateTimeRange(TimeRange timeRange) {
        if (timeRange.from().isAfter(timeRange.to())) {
            throw InvalidQueryException.forInvalidTimeRangeBounds();
        }
    }

    private void validateFacetMetricsAndMeasures(List<FacetMetricMeasuresRequest> queries) {
        this.validateMetricsAndMeasures(queries.stream().map(query -> new MetricMeasuresRequest(query.name(), query.measures())).toList());
    }

    private void validateMetricsAndMeasures(List<MetricMeasuresRequest> queries) {
        for (MetricMeasuresRequest query : queries) {
            MetricSpec.Name metric = query.name();
            MetricSpec metricSpec = this.definition.findMetric(metric).orElseThrow(() -> InternalDefinitionException.forUnknownMetric(metric.name()));
            for (MetricSpec.Measure measure : query.measures()) {
                if (metricSpec.measures().contains((Object)measure)) continue;
                throw InvalidQueryException.forInvalidMeasure(metric.name(), measure.name());
            }
        }
    }
}

