/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.analytics.domain_service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public interface AnalyticsMetadataProvider {
    public boolean appliesTo(Field var1);

    public Map<String, String> provide(String var1, String var2);

    default public Map<String, Map<String, String>> provide(List<String> keys, String environmentId) {
        return keys.stream().collect(Collectors.toMap(key -> key, key -> this.provide((String)key, environmentId)));
    }

    public static enum Field {
        API("api-id"),
        APPLICATION("application-id"),
        PLAN("plan-id"),
        GEOIP_COUNTRY_ISO_CODE("geoip.country_iso_code"),
        GENERIC("");

        private final String value;

        private Field(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public static Field of(String value) {
            for (Field field : Field.values()) {
                if (!field.value.equalsIgnoreCase(value)) continue;
                return field;
            }
            return GENERIC;
        }
    }
}

