/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.common.event.EventManager;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ParameterRepository;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Parameter;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.KeyScope;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.stereotype.Component;

@Component
public class ParameterServiceImpl
extends TransactionalService
implements ParameterService {
    public static final String SEPARATOR = ";";
    public static final String KV_SEPARATOR = "@";
    private static final Logger LOGGER = LoggerFactory.getLogger(ParameterServiceImpl.class);
    @Lazy
    @Inject
    private ParameterRepository parameterRepository;
    @Inject
    private AuditService auditService;
    @Inject
    private ConfigurableEnvironment environment;
    @Inject
    private EventManager eventManager;
    @Inject
    @Lazy
    private EnvironmentService environmentService;

    @Override
    public String find(ExecutionContext executionContext, Key key, ParameterReferenceType referenceType) {
        return this.find(executionContext, key, null, referenceType);
    }

    @Override
    public boolean findAsBoolean(ExecutionContext executionContext, Key key, ParameterReferenceType referenceType) {
        return this.findAsBoolean(executionContext, key, null, referenceType);
    }

    @Override
    public List<String> findAll(ExecutionContext executionContext, Key key, ParameterReferenceType referenceType) {
        return this.findAll(executionContext, key, Function.identity(), null, null, referenceType);
    }

    @Override
    public Map<String, List<String>> findAll(ExecutionContext executionContext, List<Key> keys, ParameterReferenceType referenceType) {
        return this.findAll(executionContext, keys, Function.identity(), null, null, referenceType);
    }

    @Override
    public <T> List<T> findAll(ExecutionContext executionContext, Key key, Function<String, T> mapper, ParameterReferenceType referenceType) {
        return this.findAll(executionContext, key, mapper, null, null, referenceType);
    }

    @Override
    public <T> Map<String, List<T>> findAll(ExecutionContext executionContext, List<Key> keys, Function<String, T> mapper, ParameterReferenceType referenceType) {
        return this.findAll(executionContext, keys, mapper, null, null, referenceType);
    }

    @Override
    public <T> List<T> findAll(ExecutionContext executionContext, Key key, Function<String, T> mapper, Predicate<String> filter, ParameterReferenceType referenceType) {
        return this.findAll(executionContext, key, mapper, filter, null, referenceType);
    }

    @Override
    public <T> Map<String, List<T>> findAll(ExecutionContext executionContext, List<Key> keys, Function<String, T> mapper, Predicate<String> filter, ParameterReferenceType referenceType) {
        return this.findAll(executionContext, keys, mapper, filter, null, referenceType);
    }

    @Override
    public Parameter save(ExecutionContext executionContext, Key key, String value, ParameterReferenceType referenceType) {
        return this.save(executionContext, key, value, null, referenceType);
    }

    @Override
    public Parameter save(ExecutionContext executionContext, Key key, List<String> values, ParameterReferenceType referenceType) {
        return this.save(executionContext, key, values, null, referenceType);
    }

    @Override
    public Parameter save(ExecutionContext executionContext, Key key, Map<String, String> values, ParameterReferenceType referenceType) {
        return this.save(executionContext, key, values, null, referenceType);
    }

    @Override
    public String find(ExecutionContext executionContext, Key key, String referenceId, ParameterReferenceType referenceType) {
        return GraviteeContext.getCurrentParameters().computeIfAbsent(key, k -> {
            List<String> values = this.findAll((Key)k, referenceId, referenceType, executionContext);
            String value = values == null || values.isEmpty() ? k.defaultValue() : String.join((CharSequence)SEPARATOR, values);
            return value;
        });
    }

    @Override
    public boolean findAsBoolean(ExecutionContext executionContext, Key key, String referenceId, ParameterReferenceType referenceType) {
        return Boolean.parseBoolean(this.find(executionContext, key, referenceId, referenceType));
    }

    @Override
    public List<String> findAll(Key key, String referenceId, ParameterReferenceType referenceType, ExecutionContext executionContext) {
        return this.findAll(executionContext, key, Function.identity(), null, referenceId, referenceType);
    }

    @Override
    public Map<String, List<String>> findAll(List<Key> keys, String referenceId, ParameterReferenceType referenceType, ExecutionContext executionContext) {
        return this.findAll(executionContext, keys, Function.identity(), null, referenceId, referenceType);
    }

    @Override
    public <T> List<T> findAll(ExecutionContext executionContext, Key key, Function<String, T> mapper, String referenceId, ParameterReferenceType referenceType) {
        return this.findAll(executionContext, key, mapper, null, referenceId, referenceType);
    }

    @Override
    public <T> Map<String, List<T>> findAll(ExecutionContext executionContext, List<Key> keys, Function<String, T> mapper, String referenceId, ParameterReferenceType referenceType) {
        return this.findAll(executionContext, keys, mapper, null, referenceId, referenceType);
    }

    @Override
    public <T> List<T> findAll(ExecutionContext executionContext, Key key, Function<String, T> mapper, Predicate<String> filter, String referenceId, ParameterReferenceType referenceType) {
        String refIdToUse = this.getEffectiveReferenceId(executionContext, referenceId, referenceType);
        try {
            Optional<Parameter> optionalParameter = this.getSystemParameter(key);
            if (optionalParameter.isPresent()) {
                return this.splitValue(optionalParameter.get().getValue(), mapper, filter);
            }
            switch (referenceType) {
                case ENVIRONMENT: {
                    optionalParameter = this.getEnvParameter(key, refIdToUse);
                    if (optionalParameter.isPresent()) {
                        return this.splitValue(optionalParameter.get().getValue(), mapper, filter);
                    }
                    String organizationId = this.environmentService.findById(refIdToUse).getOrganizationId();
                    optionalParameter = this.getOrgParameter(key, organizationId);
                    if (optionalParameter.isPresent()) {
                        return this.splitValue(optionalParameter.get().getValue(), mapper, filter);
                    }
                }
                case ORGANIZATION: {
                    optionalParameter = this.getOrgParameter(key, refIdToUse);
                    if (!optionalParameter.isPresent()) break;
                    return this.splitValue(optionalParameter.get().getValue(), mapper, filter);
                }
            }
            return this.splitValue(this.getDefaultParameterValue(key), mapper, filter);
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to find parameter values with key: " + key;
            LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    @Override
    public <T> Map<String, List<T>> findAll(ExecutionContext executionContext, List<Key> keys, Function<String, T> mapper, Predicate<String> filter, String referenceId, ParameterReferenceType referenceType) {
        String refIdToUse = this.getEffectiveReferenceId(executionContext, referenceId, referenceType);
        try {
            ArrayList<Key> keysToFind = new ArrayList<Key>(keys);
            HashMap result = new HashMap();
            for (Key keyToFind : keys) {
                this.getSystemParameter(keyToFind).ifPresent(p -> {
                    result.put(p.getKey(), this.splitValue(p.getValue(), mapper, filter));
                    keysToFind.remove(keyToFind);
                });
            }
            if (!keysToFind.isEmpty()) {
                switch (referenceType) {
                    case ENVIRONMENT: {
                        this.getEnvParameters(keysToFind, refIdToUse).forEach(p -> {
                            result.put(p.getKey(), this.splitValue(p.getValue(), mapper, filter));
                            keysToFind.remove(Key.findByKey((String)p.getKey()));
                        });
                        if (keysToFind.isEmpty()) break;
                        String organizationId = this.environmentService.findById(refIdToUse).getOrganizationId();
                        this.getOrgParameters(keysToFind, organizationId).forEach(p -> {
                            result.put(p.getKey(), this.splitValue(p.getValue(), mapper, filter));
                            keysToFind.remove(Key.findByKey((String)p.getKey()));
                        });
                        if (keysToFind.isEmpty()) break;
                        keysToFind.forEach(k -> result.put(k.key(), this.splitValue(k.defaultValue(), mapper, filter)));
                        break;
                    }
                    case ORGANIZATION: {
                        this.getOrgParameters(keysToFind, refIdToUse).forEach(p -> {
                            result.put(p.getKey(), this.splitValue(p.getValue(), mapper, filter));
                            keysToFind.remove(Key.findByKey((String)p.getKey()));
                        });
                        if (keysToFind.isEmpty()) break;
                        keysToFind.forEach(k -> result.put(k.key(), this.splitValue(k.defaultValue(), mapper, filter)));
                        break;
                    }
                    default: {
                        keysToFind.forEach(k -> result.put(k.key(), this.splitValue(k.defaultValue(), mapper, filter)));
                    }
                }
            }
            return result;
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to find parameter values with keys: " + keys;
            LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    private String getEffectiveReferenceId(ExecutionContext executionContext, String referenceId, ParameterReferenceType referenceType) {
        String refIdToUse = referenceId;
        if (refIdToUse == null) {
            refIdToUse = referenceType == ParameterReferenceType.ORGANIZATION ? executionContext.getOrganizationId() : executionContext.getEnvironmentId();
        }
        return refIdToUse;
    }

    private <T> List<T> splitValue(String value, Function<String, T> mapper, Predicate<String> filter) {
        if (value == null) {
            return Collections.emptyList();
        }
        Stream<String> stream = Arrays.stream(value.split(SEPARATOR));
        if (filter != null) {
            stream = stream.filter(filter);
        }
        return stream.map(mapper).collect(Collectors.toList());
    }

    @Override
    public Parameter save(ExecutionContext executionContext, Key key, String value, String referenceId, ParameterReferenceType referenceType) {
        String refIdToUse = this.getEffectiveReferenceId(executionContext, referenceId, referenceType);
        try {
            Optional optionalParameter = this.parameterRepository.findById(key.key(), refIdToUse, io.gravitee.repository.management.model.ParameterReferenceType.valueOf((String)referenceType.name()));
            boolean updateMode = optionalParameter.isPresent();
            Parameter parameter = new Parameter();
            parameter.setKey(key.key());
            parameter.setReferenceId(refIdToUse);
            parameter.setReferenceType(io.gravitee.repository.management.model.ParameterReferenceType.valueOf((String)referenceType.name()));
            parameter.setValue(value);
            if (this.environment.containsProperty(key.key()) && key.isOverridable()) {
                parameter.setValue(this.toSemicolonSeparatedString(key, this.environment.getProperty(key.key())));
                return parameter;
            }
            if (updateMode) {
                if (value == null) {
                    this.parameterRepository.delete(key.key(), refIdToUse, io.gravitee.repository.management.model.ParameterReferenceType.valueOf((String)referenceType.name()));
                    return null;
                }
                if (!value.equals(((Parameter)optionalParameter.get()).getValue())) {
                    Parameter updatedParameter = this.parameterRepository.update(parameter);
                    this.auditService.createAuditLog(executionContext, Collections.singletonMap(Audit.AuditProperties.PARAMETER, updatedParameter.getKey()), (Audit.AuditEvent)Parameter.AuditEvent.PARAMETER_UPDATED, new Date(), optionalParameter.get(), updatedParameter);
                    this.eventManager.publishEvent((Enum)key, (Object)parameter);
                    return updatedParameter;
                }
                return (Parameter)optionalParameter.get();
            }
            if (value == null) {
                return null;
            }
            Parameter savedParameter = this.parameterRepository.create(parameter);
            this.auditService.createAuditLog(executionContext, Collections.singletonMap(Audit.AuditProperties.PARAMETER, savedParameter.getKey()), (Audit.AuditEvent)Parameter.AuditEvent.PARAMETER_CREATED, new Date(), null, savedParameter);
            this.eventManager.publishEvent((Enum)key, (Object)parameter);
            return savedParameter;
        }
        catch (TechnicalException ex) {
            String message = "An error occurs while trying to create parameter for key/value: " + key + "/" + value;
            LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    @Override
    public Parameter save(ExecutionContext executionContext, Key key, List<String> values, String referenceId, ParameterReferenceType referenceType) {
        return this.save(executionContext, key, values == null || values.isEmpty() ? null : String.join((CharSequence)SEPARATOR, values), referenceId, referenceType);
    }

    @Override
    public Parameter save(ExecutionContext executionContext, Key key, Map<String, String> values, String referenceId, ParameterReferenceType referenceType) {
        return this.save(executionContext, key, values == null ? null : values.entrySet().stream().map(entry -> (String)entry.getKey() + KV_SEPARATOR + (String)entry.getValue()).collect(Collectors.joining(SEPARATOR)), referenceId, referenceType);
    }

    private String toSemicolonSeparatedString(Key key, String value) {
        if (key.type() != null && List.class.isAssignableFrom(key.type())) {
            value = value.replace(",", SEPARATOR);
        }
        return value;
    }

    private Optional<Parameter> getEnvParameter(Key key, String environmentId) throws TechnicalException {
        if (key.scopes().contains(KeyScope.ENVIRONMENT)) {
            return this.parameterRepository.findById(key.key(), environmentId, io.gravitee.repository.management.model.ParameterReferenceType.ENVIRONMENT);
        }
        return Optional.empty();
    }

    private List<Parameter> getEnvParameters(List<Key> keys, String environmentId) throws TechnicalException {
        List keysToFind = keys.stream().filter(k -> k.scopes().contains(KeyScope.ENVIRONMENT)).collect(Collectors.toList());
        if (!keysToFind.isEmpty()) {
            return this.parameterRepository.findByKeys(keysToFind.stream().map(Key::key).collect(Collectors.toList()), environmentId, io.gravitee.repository.management.model.ParameterReferenceType.ENVIRONMENT).stream().filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private Optional<Parameter> getOrgParameter(Key key, String organizationId) throws TechnicalException {
        if (key.scopes().contains(KeyScope.ORGANIZATION)) {
            return this.parameterRepository.findById(key.key(), organizationId, io.gravitee.repository.management.model.ParameterReferenceType.ORGANIZATION);
        }
        return Optional.empty();
    }

    private List<Parameter> getOrgParameters(List<Key> keys, String organizationId) throws TechnicalException {
        List keysToFind = keys.stream().filter(k -> k.scopes().contains(KeyScope.ORGANIZATION)).collect(Collectors.toList());
        if (!keysToFind.isEmpty()) {
            return this.parameterRepository.findByKeys(keysToFind.stream().map(Key::key).collect(Collectors.toList()), organizationId, io.gravitee.repository.management.model.ParameterReferenceType.ORGANIZATION).stream().filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private Optional<Parameter> getSystemParameter(Key key) {
        if (this.environment.containsProperty(key.key()) && key.isOverridable()) {
            Parameter parameter = new Parameter();
            parameter.setKey(key.key());
            parameter.setValue(this.toSemicolonSeparatedString(key, this.environment.getProperty(key.key())));
            return Optional.of(parameter);
        }
        return Optional.empty();
    }

    private String getDefaultParameterValue(Key key) {
        return key.defaultValue();
    }
}

