/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.UserRepository;
import io.gravitee.repository.management.api.search.UserCriteria;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.CustomUserFieldReferenceType;
import io.gravitee.repository.management.model.MetadataReferenceType;
import io.gravitee.repository.management.model.User;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.MetadataFormat;
import io.gravitee.rest.api.model.NewReferenceMetadataEntity;
import io.gravitee.rest.api.model.NewUserMetadataEntity;
import io.gravitee.rest.api.model.ReferenceMetadataEntity;
import io.gravitee.rest.api.model.UpdateReferenceMetadataEntity;
import io.gravitee.rest.api.model.UpdateUserMetadataEntity;
import io.gravitee.rest.api.model.UserMetadataEntity;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.UserMetadataService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.MetadataNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractReferenceMetadataService;
import io.gravitee.rest.api.service.sanitizer.CustomFieldSanitizer;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class UserMetadataServiceImpl
extends AbstractReferenceMetadataService
implements UserMetadataService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserMetadataServiceImpl.class);
    @Lazy
    @Autowired
    protected UserRepository userRepository;
    @Autowired
    protected EnvironmentService environmentService;

    private UserMetadataEntity convert(ReferenceMetadataEntity record, String userId) {
        UserMetadataEntity metadata = new UserMetadataEntity();
        metadata.setFormat(MetadataFormat.valueOf((String)record.getFormat().name()));
        metadata.setKey(record.getKey());
        metadata.setName(record.getName());
        metadata.setValue(record.getValue());
        metadata.setUserId(userId);
        return metadata;
    }

    @Override
    public UserMetadataEntity create(ExecutionContext executionContext, NewUserMetadataEntity metadata) {
        return this.convert(this.create(executionContext, (NewReferenceMetadataEntity)metadata, MetadataReferenceType.USER, metadata.getUserId(), false), metadata.getUserId());
    }

    @Override
    public UserMetadataEntity update(ExecutionContext executionContext, UpdateUserMetadataEntity metadata) {
        return this.convert(this.update(executionContext, (UpdateReferenceMetadataEntity)metadata, MetadataReferenceType.USER, metadata.getUserId(), false), metadata.getUserId());
    }

    @Override
    public List<UserMetadataEntity> findAllByUserId(String userId) {
        return GraviteeContext.getCurrentUsersMetadata().computeIfAbsent(userId, k -> {
            List<ReferenceMetadataEntity> allMetadata = this.findAllByReference(MetadataReferenceType.USER, userId, false);
            return allMetadata.stream().map(m -> this.convert((ReferenceMetadataEntity)m, userId)).collect(Collectors.toList());
        });
    }

    @Override
    public void deleteAllByCustomFieldId(ExecutionContext executionContext, String key, String refId, CustomUserFieldReferenceType refType) {
        try {
            String orgId = null;
            if (refType.equals((Object)CustomUserFieldReferenceType.ENVIRONMENT)) {
                EnvironmentEntity cufEnvironment = this.environmentService.findById(refId);
                orgId = cufEnvironment.getOrganizationId();
            } else {
                orgId = refId;
            }
            UserCriteria criteria = new UserCriteria.Builder().organizationId(orgId).build();
            int pageNumber = 0;
            Page pageOfUser = null;
            do {
                pageOfUser = this.userRepository.search(criteria, new PageableBuilder().pageNumber(pageNumber).pageSize(100).build());
                for (User user : pageOfUser.getContent()) {
                    try {
                        this.delete(executionContext, CustomFieldSanitizer.formatKeyValue(key), MetadataReferenceType.USER, user.getId());
                    }
                    catch (MetadataNotFoundException e) {
                        LOGGER.debug("Metadata key={}, refType={}, refId={} not found, ignore error because we want to delete it and user may not have this metadata", new Object[]{key, MetadataReferenceType.USER, user.getId()});
                    }
                }
                ++pageNumber;
            } while (pageOfUser.getPageElements() > 0L);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurred while trying to all metadata with key {}", (Object)key, (Object)ex);
            throw new TechnicalManagementException("An error occurred while trying to all metadata with key " + key, ex);
        }
    }

    @Override
    protected void checkReferenceMetadataFormat(ExecutionContext executionContext, MetadataFormat format, String value, MetadataReferenceType referenceType, String referenceId) {
    }
}

