/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.initializer;

import io.gravitee.node.api.initializer.Initializer;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.OrganizationRepository;
import io.gravitee.repository.management.model.Organization;
import io.gravitee.rest.api.service.common.ExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public abstract class OrganizationInitializer
implements Initializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrganizationInitializer.class);
    @Lazy
    @Autowired
    private OrganizationRepository organizationRepository;

    protected abstract void initializeOrganization(ExecutionContext var1);

    public final boolean initialize() {
        try {
            this.organizationRepository.findAll().forEach(organization -> {
                ExecutionContext executionContext = new ExecutionContext((Organization)organization);
                LOGGER.info("Starting {} for {}", (Object)this.getClass().getSimpleName(), (Object)executionContext);
                this.initializeOrganization(executionContext);
            });
        }
        catch (TechnicalException e) {
            LOGGER.error("{} execution failed", (Object)this.getClass().getSimpleName(), (Object)e);
            return false;
        }
        return true;
    }
}

