/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.bridge.operation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.cockpit.api.command.CommandStatus;
import io.gravitee.cockpit.api.command.bridge.BridgeCommand;
import io.gravitee.cockpit.api.command.bridge.BridgePayload;
import io.gravitee.cockpit.api.command.bridge.BridgeReply;
import io.gravitee.cockpit.api.command.bridge.BridgeSimpleReply;
import io.gravitee.rest.api.model.promotion.PromotionEntity;
import io.gravitee.rest.api.service.InstallationService;
import io.gravitee.rest.api.service.cockpit.command.bridge.operation.BridgeOperation;
import io.gravitee.rest.api.service.cockpit.command.bridge.operation.BridgeOperationHandler;
import io.gravitee.rest.api.service.promotion.PromotionService;
import io.reactivex.rxjava3.core.Single;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProcessPromotionOperationHandler
implements BridgeOperationHandler {
    private final Logger logger = LoggerFactory.getLogger(ProcessPromotionOperationHandler.class);
    private final PromotionService promotionService;
    private final InstallationService installationService;
    private final ObjectMapper objectMapper;

    public ProcessPromotionOperationHandler(PromotionService promotionService, InstallationService installationService, ObjectMapper objectMapper) {
        this.promotionService = promotionService;
        this.installationService = installationService;
        this.objectMapper = objectMapper;
    }

    @Override
    public boolean canHandle(String bridgeOperation) {
        return Objects.equals(BridgeOperation.PROCESS_API_PROMOTION.name(), bridgeOperation);
    }

    @Override
    public Single<BridgeReply> handle(BridgeCommand bridgeCommand) {
        PromotionEntity promotionEntity;
        BridgeSimpleReply reply = new BridgeSimpleReply();
        reply.setCommandId(bridgeCommand.getId());
        try {
            promotionEntity = (PromotionEntity)this.objectMapper.readValue(((BridgePayload)bridgeCommand.getPayload()).getContent(), PromotionEntity.class);
        }
        catch (JsonProcessingException e) {
            this.logger.warn("Problem while deserializing promotion for environment {}", (Object)bridgeCommand.getEnvironmentId());
            reply.setCommandStatus(CommandStatus.ERROR);
            reply.setMessage("Problem while deserializing promotion for environment [" + bridgeCommand.getEnvironmentId() + "]");
            return Single.just((Object)reply);
        }
        PromotionEntity promotion = this.promotionService.createOrUpdate(promotionEntity);
        reply.setCommandStatus(CommandStatus.SUCCEEDED);
        reply.setOrganizationId(bridgeCommand.getOrganizationId());
        reply.setEnvironmentId(bridgeCommand.getTarget().getEnvironmentId());
        reply.setInstallationId(this.installationService.get().getId());
        try {
            reply.setPayload(this.objectMapper.writeValueAsString((Object)promotion));
        }
        catch (JsonProcessingException e) {
            this.logger.warn("Problem while serializing promotion for environment {}", (Object)promotion.getId());
            reply.setCommandStatus(CommandStatus.ERROR);
            reply.setMessage("Problem while serializing promotion for environment [" + bridgeCommand.getEnvironmentId() + "]");
            return Single.just((Object)reply);
        }
        return Single.just((Object)reply);
    }
}

