/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.crud_service.plan.adapter;

import io.gravitee.definition.model.v4.plan.PlanSecurity;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import io.gravitee.repository.management.model.Plan;
import io.gravitee.rest.api.model.v4.plan.BasePlanEntity;
import io.gravitee.rest.api.model.v4.plan.GenericPlanEntity;
import io.gravitee.rest.api.model.v4.plan.PlanMode;
import io.gravitee.rest.api.model.v4.plan.PlanSecurityType;
import io.gravitee.rest.api.model.v4.plan.PlanType;
import io.gravitee.rest.api.model.v4.plan.PlanValidationType;
import io.gravitee.rest.api.service.converter.PlanConverter;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class BasePlanAdapter {
    private final PlanConverter planConverter;

    public BasePlanAdapter(PlanConverter planConverter) {
        this.planConverter = planConverter;
    }

    public GenericPlanEntity toEntityV4(Plan plan) {
        BasePlanEntity entity = new BasePlanEntity();
        entity.setId(plan.getId());
        entity.setCrossId(plan.getCrossId());
        entity.setName(plan.getName());
        entity.setDescription(plan.getDescription());
        entity.setApiId(plan.getApi());
        entity.setCreatedAt(plan.getCreatedAt());
        entity.setUpdatedAt(plan.getUpdatedAt());
        entity.setClosedAt(plan.getClosedAt());
        entity.setNeedRedeployAt(plan.getNeedRedeployAt() == null ? plan.getUpdatedAt() : plan.getNeedRedeployAt());
        entity.setPublishedAt(plan.getPublishedAt());
        entity.setOrder(plan.getOrder());
        entity.setExcludedGroups(plan.getExcludedGroups());
        entity.setType(PlanType.valueOf((String)plan.getType().name()));
        entity.setMode(plan.getMode() != null ? PlanMode.valueOf((String)plan.getMode().name()) : PlanMode.STANDARD);
        entity.setStatus(plan.getStatus() != null ? PlanStatus.valueOf((String)plan.getStatus().name()) : PlanStatus.PUBLISHED);
        if (Plan.PlanMode.PUSH != plan.getMode()) {
            entity.setSecurity(PlanSecurity.builder().type(PlanSecurityType.valueOf((String)plan.getSecurity().name()).getLabel()).configuration(plan.getSecurityDefinition()).build());
        }
        entity.setValidation(PlanValidationType.valueOf((String)plan.getValidation().name()));
        entity.setCharacteristics(plan.getCharacteristics());
        entity.setCommentRequired(plan.isCommentRequired());
        entity.setCommentMessage(plan.getCommentMessage());
        entity.setTags(plan.getTags());
        entity.setSelectionRule(plan.getSelectionRule());
        entity.setGeneralConditions(plan.getGeneralConditions());
        return entity;
    }

    public GenericPlanEntity toEntityV2(Plan plan) {
        return this.planConverter.toPlanEntity(plan, List.of());
    }
}

