/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.crud_service.analytics.log;

import io.gravitee.apim.crud_service.analytics.log.MessageLogCrudService;
import io.gravitee.apim.infra.adapter.MessageLogAdapter;
import io.gravitee.repository.analytics.AnalyticsException;
import io.gravitee.repository.log.v4.api.LogRepository;
import io.gravitee.repository.log.v4.model.LogResponse;
import io.gravitee.repository.log.v4.model.message.MessageLog;
import io.gravitee.repository.log.v4.model.message.MessageLogQuery;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.v4.log.SearchLogResponse;
import io.gravitee.rest.api.model.v4.log.message.BaseMessageLog;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
class MessageLogCrudServiceImpl
implements MessageLogCrudService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageLogCrudServiceImpl.class);
    private final LogRepository logRepository;

    public MessageLogCrudServiceImpl(@Lazy LogRepository logRepository) {
        this.logRepository = logRepository;
    }

    @Override
    public SearchLogResponse<BaseMessageLog> searchApiMessageLog(String apiId, String requestId, Pageable pageable) {
        try {
            LogResponse response = this.logRepository.searchMessageLog(MessageLogQuery.builder().filter(MessageLogQuery.Filter.builder().apiId(apiId).requestId(requestId).build()).page(pageable.getPageNumber()).size(pageable.getPageSize()).build());
            return this.mapToMessageResponse((LogResponse<MessageLog>)response);
        }
        catch (AnalyticsException e) {
            log.error("An error occurs while trying to search message of api [apiId={}, requestId={}]", new Object[]{apiId, requestId, e});
            throw new TechnicalManagementException("Error while searching message logs of api " + apiId + " request " + requestId, e);
        }
    }

    private SearchLogResponse<BaseMessageLog> mapToMessageResponse(LogResponse<MessageLog> logs) {
        long total = logs.total();
        List<BaseMessageLog> data = MessageLogAdapter.INSTANCE.toEntitiesList(logs.data());
        return new SearchLogResponse(total, data);
    }
}

