/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.usecase.log;

import io.gravitee.apim.crud_service.analytics.log.ConnectionLogCrudService;
import io.gravitee.apim.crud_service.application.ApplicationCrudService;
import io.gravitee.apim.crud_service.plan.PlanCrudService;
import io.gravitee.rest.api.model.BaseApplicationEntity;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import io.gravitee.rest.api.model.v4.log.SearchLogResponse;
import io.gravitee.rest.api.model.v4.log.connection.BaseConnectionLog;
import io.gravitee.rest.api.model.v4.log.connection.ConnectionLogModel;
import io.gravitee.rest.api.model.v4.plan.BasePlanEntity;
import io.gravitee.rest.api.model.v4.plan.GenericPlanEntity;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.ApplicationNotFoundException;
import io.gravitee.rest.api.service.exceptions.PlanNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class SearchConnectionLogUsecase {
    static final String UNKNOWN = "Unknown";
    private final ConnectionLogCrudService connectionLogCrudService;
    private final PlanCrudService planCrudService;
    private final ApplicationCrudService applicationCrudService;

    public SearchConnectionLogUsecase(ConnectionLogCrudService connectionLogCrudService, PlanCrudService planCrudService, ApplicationCrudService applicationCrudService) {
        this.connectionLogCrudService = connectionLogCrudService;
        this.planCrudService = planCrudService;
        this.applicationCrudService = applicationCrudService;
    }

    public Output execute(ExecutionContext executionContext, Input input) {
        Pageable pageable = input.pageable.orElse((Pageable)new PageableImpl(1, 20));
        SearchLogResponse<BaseConnectionLog> response = this.connectionLogCrudService.searchApiConnectionLog(input.apiId(), pageable);
        return this.mapToResponse(executionContext, response);
    }

    private Output mapToResponse(ExecutionContext executionContext, SearchLogResponse<BaseConnectionLog> logs) {
        long total = logs.total();
        List<ConnectionLogModel> data = logs.logs().stream().map(log -> this.mapToModel(executionContext, (BaseConnectionLog)log)).toList();
        return new Output(total, data);
    }

    private ConnectionLogModel mapToModel(ExecutionContext executionContext, BaseConnectionLog connectionLog) {
        return ((ConnectionLogModel.ConnectionLogModelBuilder)((ConnectionLogModel.ConnectionLogModelBuilder)((ConnectionLogModel.ConnectionLogModelBuilder)((ConnectionLogModel.ConnectionLogModelBuilder)((ConnectionLogModel.ConnectionLogModelBuilder)((ConnectionLogModel.ConnectionLogModelBuilder)((ConnectionLogModel.ConnectionLogModelBuilder)((ConnectionLogModel.ConnectionLogModelBuilder)ConnectionLogModel.builder().apiId(connectionLog.getApiId())).requestId(connectionLog.getRequestId())).timestamp(connectionLog.getTimestamp())).application(this.getApplicationEntity(executionContext, connectionLog.getApplicationId())).clientIdentifier(connectionLog.getClientIdentifier() != null ? connectionLog.getClientIdentifier() : UNKNOWN)).method(connectionLog.getMethod())).plan(this.getPlanInfo(connectionLog.getPlanId())).requestEnded(connectionLog.isRequestEnded())).transactionId(connectionLog.getTransactionId())).status(connectionLog.getStatus())).build();
    }

    private GenericPlanEntity getPlanInfo(String planId) {
        BasePlanEntity unknownPlan = BasePlanEntity.builder().id(planId).name(UNKNOWN).build();
        try {
            return planId != null ? this.planCrudService.findById(planId) : unknownPlan;
        }
        catch (PlanNotFoundException | TechnicalManagementException e) {
            return unknownPlan;
        }
    }

    private BaseApplicationEntity getApplicationEntity(ExecutionContext executionContext, String applicationId) {
        try {
            return this.applicationCrudService.findById(executionContext, applicationId);
        }
        catch (ApplicationNotFoundException | TechnicalManagementException e) {
            return BaseApplicationEntity.builder().id(applicationId).name(UNKNOWN).build();
        }
    }

    public record Input(String apiId, Optional<Pageable> pageable) {
        public Input(String apiId) {
            this(apiId, Optional.empty());
        }

        public Input(String apiId, Pageable pageable) {
            this(apiId, Optional.of(pageable));
        }
    }

    public record Output(long total, List<ConnectionLogModel> data) {
    }
}

