/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.gravitee.cockpit.api.command.Command;
import io.gravitee.cockpit.api.command.CommandHandler;
import io.gravitee.cockpit.api.command.CommandStatus;
import io.gravitee.cockpit.api.command.v4api.V4ApiCommand;
import io.gravitee.cockpit.api.command.v4api.V4ApiPayload;
import io.gravitee.cockpit.api.command.v4api.V4ApiReply;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.cockpit.services.V4ApiServiceCockpit;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.common.SecurityContextHelper;
import io.reactivex.rxjava3.core.Single;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class V4ApiCommandHandler
implements CommandHandler<V4ApiCommand, V4ApiReply> {
    private final Logger logger = LoggerFactory.getLogger(V4ApiCommandHandler.class);
    private final V4ApiServiceCockpit v4ApiServiceCockpit;
    private final UserService userService;

    public V4ApiCommandHandler(V4ApiServiceCockpit v4ApiServiceCockpit, UserService userService) {
        this.v4ApiServiceCockpit = v4ApiServiceCockpit;
        this.userService = userService;
    }

    public Command.Type handleType() {
        return Command.Type.V4_API_COMMAND;
    }

    public Single<V4ApiReply> handle(V4ApiCommand command) {
        V4ApiPayload payload = (V4ApiPayload)command.getPayload();
        UserEntity user = this.userService.findBySource(GraviteeContext.getExecutionContext(), "cockpit", payload.getUserId(), true);
        SecurityContextHelper.authenticateAs(user);
        try {
            return this.v4ApiServiceCockpit.createPublishApi(user.getId(), payload.getApiDefinition()).flatMap(apiEntity -> {
                V4ApiReply reply = new V4ApiReply(command.getId(), CommandStatus.SUCCEEDED);
                reply.setApiId(apiEntity.getId());
                reply.setApiName(apiEntity.getName());
                reply.setApiVersion(apiEntity.getApiVersion());
                this.logger.info("Api {} successfully created.", (Object)apiEntity.getName());
                return Single.just((Object)reply);
            });
        }
        catch (JsonProcessingException exception) {
            this.logger.error("An error occurred while creating Api.", (Throwable)exception);
            return Single.just((Object)new V4ApiReply(command.getId(), CommandStatus.FAILED));
        }
    }
}

