/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.search.lucene;

import io.gravitee.repository.exceptions.TechnicalException;
import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SearchEngineIndexer {
    private final Logger logger = LoggerFactory.getLogger(SearchEngineIndexer.class);
    private static final String ID_FIELD = "id";
    private static final String TYPE_FIELD = "type";
    @Autowired
    private IndexWriter writer;

    public long index(Document document, boolean commit) throws TechnicalException {
        this.logger.debug("Updating a document into the Lucene index");
        String id = document.get(ID_FIELD);
        try {
            long seq = this.writer.updateDocument(new Term(ID_FIELD, id), (Iterable)document);
            if (commit) {
                this.writer.commit();
            }
            return seq;
        }
        catch (IOException ioe) {
            this.logger.error("Fail to index document with ID: {}", (Object)id, (Object)ioe);
            throw new TechnicalException("Fail to index document with ID: " + id, (Throwable)ioe);
        }
    }

    public void remove(Document document) throws TechnicalException {
        String type = document.get(TYPE_FIELD);
        String id = document.get(ID_FIELD);
        this.logger.debug("Removing document type[{}] ID[{}]", (Object)type, (Object)id);
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.add((Query)new TermQuery(new Term(ID_FIELD, id)), BooleanClause.Occur.MUST);
        bq.add((Query)new TermQuery(new Term(TYPE_FIELD, type)), BooleanClause.Occur.MUST);
        try {
            this.writer.deleteDocuments(new Query[]{bq.build()});
        }
        catch (IOException ioe) {
            this.logger.error("Fail to index document with ID: {}", (Object)id, (Object)ioe);
            throw new TechnicalException("Fail to index document with ID: " + id, (Throwable)ioe);
        }
    }

    public void commit() throws TechnicalException {
        try {
            this.writer.commit();
        }
        catch (IOException ioe) {
            this.logger.error("Unexpected IO errors while committing Lucene index", (Throwable)ioe);
            throw new TechnicalException("Unexpected IO errors while committing Lucene index", (Throwable)ioe);
        }
    }
}

