/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.swagger.policy.impl;

import io.gravitee.rest.api.service.impl.swagger.policy.PolicyOperationVisitor;
import io.gravitee.rest.api.service.impl.swagger.policy.PolicyOperationVisitorManager;
import io.gravitee.rest.api.service.impl.swagger.visitor.v2.SwaggerOperationVisitor;
import io.gravitee.rest.api.service.impl.swagger.visitor.v3.OAIOperationVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PolicyOperationVisitorManagerImpl
implements PolicyOperationVisitorManager {
    private final List<PolicyOperationVisitor> policyVisitors = new ArrayList<PolicyOperationVisitor>();
    private final Map<String, SwaggerOperationVisitor> swaggerOperationVisitors = new HashMap<String, SwaggerOperationVisitor>();
    private final Map<String, OAIOperationVisitor> oaiOperationVisitors = new HashMap<String, OAIOperationVisitor>();

    @Override
    public void add(PolicyOperationVisitor visitor) {
        this.policyVisitors.add(visitor);
        if (visitor.getOaiOperationVisitor() != null) {
            this.oaiOperationVisitors.put(visitor.getId(), (descriptor, operation) -> visitor.getOaiOperationVisitor().visit(descriptor, operation));
        }
        if (visitor.getSwaggerOperationVisitor() != null) {
            this.swaggerOperationVisitors.put(visitor.getId(), (descriptor, operation) -> visitor.getSwaggerOperationVisitor().visit(descriptor, operation));
        }
    }

    @Override
    public List<PolicyOperationVisitor> getPolicyVisitors() {
        return this.policyVisitors;
    }

    @Override
    public SwaggerOperationVisitor getSwaggerOperationVisitor(String policy) {
        return this.swaggerOperationVisitors.get(policy);
    }

    @Override
    public OAIOperationVisitor getOAIOperationVisitor(String policy) {
        return this.oaiOperationVisitors.get(policy);
    }
}

