/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.initializer;

import io.gravitee.repository.management.api.search.UserCriteria;
import io.gravitee.repository.management.model.UserStatus;
import io.gravitee.rest.api.model.UpdateUserEntity;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.impl.upgrade.initializer.OrganizationInitializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultUserStatusInitializer
extends OrganizationInitializer {
    @Autowired
    private UserService userService;

    @Override
    public void initializeOrganization(ExecutionContext executionContext) {
        UpdateUserEntity updateUserEntity = new UpdateUserEntity();
        updateUserEntity.setStatus(UserStatus.ACTIVE.name());
        this.userService.search(executionContext, new UserCriteria.Builder().noStatus().build(), (Pageable)new PageableImpl(1, Integer.MAX_VALUE)).getContent().forEach(userEntity -> {
            if (userEntity.getStatus() == null) {
                this.userService.update(executionContext, userEntity.getId(), updateUserEntity);
            }
        });
    }

    public int getOrder() {
        return 200;
    }
}

