/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.repository.management.api.search.Sortable;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.api.search.builder.SortableBuilder;
import io.gravitee.rest.api.idp.api.authentication.UserDetails;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.service.impl.TransactionalService;
import org.springframework.security.core.context.SecurityContextHolder;

public abstract class AbstractService
extends TransactionalService {
    public static final String ENVIRONMENT_ADMIN = RoleScope.ENVIRONMENT.name() + ":" + SystemRole.ADMIN.name();

    protected String getAuthenticatedUsername() {
        UserDetails authenticatedUser = this.getAuthenticatedUser();
        return authenticatedUser == null ? null : authenticatedUser.getUsername();
    }

    protected UserDetails getAuthenticatedUser() {
        if (this.isAuthenticated()) {
            return (UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        }
        return null;
    }

    protected boolean isAuthenticated() {
        return SecurityContextHolder.getContext().getAuthentication() != null && SecurityContextHolder.getContext().getAuthentication().getPrincipal() instanceof UserDetails;
    }

    protected boolean isEnvironmentAdmin() {
        return this.isUserInRole(ENVIRONMENT_ADMIN);
    }

    private boolean isUserInRole(String role) {
        return SecurityContextHolder.getContext().getAuthentication().getAuthorities().stream().anyMatch(auth -> role.equals(auth.getAuthority()));
    }

    protected static io.gravitee.repository.management.api.search.Pageable convert(Pageable pageable) {
        if (pageable == null) {
            return null;
        }
        return new PageableBuilder().pageNumber(pageable.getPageNumber() - 1).pageSize(pageable.getPageSize()).build();
    }

    protected static Sortable convert(io.gravitee.rest.api.model.common.Sortable sortable) {
        if (sortable == null) {
            return null;
        }
        return new SortableBuilder().field(sortable.getField()).setAsc(sortable.isAscOrder()).build();
    }
}

