/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.CategoryRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldFilter;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Category;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class OrphanCategoryUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OrphanCategoryUpgrader.class);
    @Lazy
    @Autowired
    private ApiRepository apiRepository;
    @Lazy
    @Autowired
    private CategoryRepository categoryRepository;

    public int getOrder() {
        return 100;
    }

    public boolean upgrade() {
        try {
            Set<Api> updatedApis = this.findAndFixApisWithOrphanCategories();
            for (Api api : updatedApis) {
                log.info("Removing orphan categories for API [{}]", (Object)api.getId());
                this.apiRepository.update((Object)api);
            }
        }
        catch (Exception e) {
            log.error("failed to apply {}", (Object)this.getClass().getSimpleName(), (Object)e);
            return false;
        }
        return true;
    }

    private Set<Api> findAndFixApisWithOrphanCategories() throws TechnicalException {
        Set<String> existingCategoryIds = this.getExistingCategoryIds();
        return this.apiRepository.search(new ApiCriteria.Builder().build(), null, ApiFieldFilter.allFields()).filter(api -> this.hasOrphanCategories((Api)api, existingCategoryIds)).peek(api -> this.removeOrphanCategories((Api)api, existingCategoryIds)).collect(Collectors.toSet());
    }

    private void removeOrphanCategories(Api api, Set<String> existingCategoryIds) {
        HashSet updatedCategories = new HashSet(api.getCategories());
        updatedCategories.retainAll(existingCategoryIds);
        api.setCategories(updatedCategories);
    }

    private boolean hasOrphanCategories(Api api, Set<String> existingCategoryIds) {
        if (CollectionUtils.isEmpty((Collection)api.getCategories())) {
            return false;
        }
        HashSet orphanCategories = new HashSet(api.getCategories());
        orphanCategories.removeAll(existingCategoryIds);
        return !orphanCategories.isEmpty();
    }

    private Set<String> getExistingCategoryIds() throws TechnicalException {
        return this.categoryRepository.findAll().stream().map(Category::getId).collect(Collectors.toSet());
    }
}

