/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.node.api.upgrader.UpgradeRecord;
import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.node.api.upgrader.UpgraderRepository;
import io.gravitee.rest.api.service.InstallationService;
import io.gravitee.rest.api.service.impl.upgrade.upgrader.AlertsEnvironmentUpgrader;
import io.gravitee.rest.api.service.impl.upgrade.upgrader.ApiKeySubscriptionsUpgrader;
import io.gravitee.rest.api.service.impl.upgrade.upgrader.ApiLoggingConditionUpgrader;
import io.gravitee.rest.api.service.impl.upgrade.upgrader.ApplicationApiKeyModeUpgrader;
import io.gravitee.rest.api.service.impl.upgrade.upgrader.ClientIdInApiKeySubscriptionsUpgrader;
import io.gravitee.rest.api.service.impl.upgrade.upgrader.CommandOrganizationUpgrader;
import io.gravitee.rest.api.service.impl.upgrade.upgrader.DefaultRolesUpgrader;
import io.gravitee.rest.api.service.impl.upgrade.upgrader.EventsLatestUpgrader;
import io.gravitee.rest.api.service.impl.upgrade.upgrader.OrphanCategoryUpgrader;
import io.gravitee.rest.api.service.impl.upgrade.upgrader.PlansDataFixUpgrader;
import io.gravitee.rest.api.service.impl.upgrade.upgrader.PlansFlowsDefinitionUpgrader;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class InstallationKeyStatusUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstallationKeyStatusUpgrader.class);
    @Autowired
    private InstallationService installationService;
    @Autowired
    @Lazy
    private UpgraderRepository upgraderRepository;
    protected static final Map<String, String> INSTALLATION_KEY_STATUS = new HashMap<String, String>();

    public InstallationKeyStatusUpgrader() {
        INSTALLATION_KEY_STATUS.put("ORPHAN_CATEGORY_UPGRADER_STATUS", OrphanCategoryUpgrader.class.getName());
        INSTALLATION_KEY_STATUS.put("DEFAULT_ROLES_UPGRADER_STATUS", DefaultRolesUpgrader.class.getName());
        INSTALLATION_KEY_STATUS.put("COMMAND_ORGANIZATION_UPGRADER", CommandOrganizationUpgrader.class.getName());
        INSTALLATION_KEY_STATUS.put("API_KEY_MODE_UPGRADER_STATUS", ApplicationApiKeyModeUpgrader.class.getName());
        INSTALLATION_KEY_STATUS.put("ALERTS_ENVIRONMENT_UPGRADER", AlertsEnvironmentUpgrader.class.getName());
        INSTALLATION_KEY_STATUS.put("PLANS_DATA_UPGRADER_V2_STATUS", PlansDataFixUpgrader.class.getName());
        INSTALLATION_KEY_STATUS.put("API_KEY_SUBSCRIPTIONS_UPGRADER_STATUS", ApiKeySubscriptionsUpgrader.class.getName());
        INSTALLATION_KEY_STATUS.put("CLIENT_ID_IN_API_KEY_SUBSCRIPTIONS_UPGRADER_STATUS", ClientIdInApiKeySubscriptionsUpgrader.class.getName());
        INSTALLATION_KEY_STATUS.put("PLANS_FLOWS_UPGRADER_STATUS", PlansFlowsDefinitionUpgrader.class.getName());
        INSTALLATION_KEY_STATUS.put("API_LOGGING_CONDITION_UPGRADER", ApiLoggingConditionUpgrader.class.getName());
        INSTALLATION_KEY_STATUS.put("EVENTS_LATEST_UPGRADER_STATUS", EventsLatestUpgrader.class.getName());
    }

    public boolean upgrade() {
        try {
            this.installationService.get().getAdditionalInformation().forEach((k, v) -> {
                if ("SUCCESS".equals(v)) {
                    String id = INSTALLATION_KEY_STATUS.get(k);
                    if (id == null) {
                        log.error("Can't find upgrader class with installation status key {}", k);
                        return;
                    }
                    UpgradeRecord upgradeRecord = (UpgradeRecord)this.upgraderRepository.findById(id).blockingGet();
                    if (upgradeRecord == null) {
                        this.upgraderRepository.create(new UpgradeRecord(id, new Date())).blockingGet();
                    }
                }
            });
            return true;
        }
        catch (Exception e) {
            log.error("unable to apply upgrader {}", (Object)this.getClass().getSimpleName(), (Object)e);
            return false;
        }
    }

    public int getOrder() {
        return 0;
    }
}

