/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.common.http.HttpMethod;
import io.gravitee.repository.analytics.AnalyticsException;
import io.gravitee.repository.analytics.query.DateRangeBuilder;
import io.gravitee.repository.analytics.query.IntervalBuilder;
import io.gravitee.repository.analytics.query.Order;
import io.gravitee.repository.analytics.query.QueryBuilders;
import io.gravitee.repository.analytics.query.SortBuilder;
import io.gravitee.repository.analytics.query.tabular.TabularQuery;
import io.gravitee.repository.analytics.query.tabular.TabularQueryBuilder;
import io.gravitee.repository.analytics.query.tabular.TabularResponse;
import io.gravitee.repository.log.api.LogRepository;
import io.gravitee.repository.log.model.ExtendedLog;
import io.gravitee.repository.log.model.Log;
import io.gravitee.repository.log.model.Response;
import io.gravitee.repository.management.model.ApplicationStatus;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.InstanceEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.analytics.query.LogQuery;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.log.ApiRequest;
import io.gravitee.rest.api.model.log.ApiRequestItem;
import io.gravitee.rest.api.model.log.ApplicationRequest;
import io.gravitee.rest.api.model.log.ApplicationRequestItem;
import io.gravitee.rest.api.model.log.PlatformRequestItem;
import io.gravitee.rest.api.model.log.SearchLogResponse;
import io.gravitee.rest.api.model.log.extended.Request;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.model.v4.plan.GenericPlanEntity;
import io.gravitee.rest.api.model.v4.plan.PlanSecurityType;
import io.gravitee.rest.api.service.ApiKeyService;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.InstanceService;
import io.gravitee.rest.api.service.LogsService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.ApiKeyNotFoundException;
import io.gravitee.rest.api.service.exceptions.ApiNotFoundException;
import io.gravitee.rest.api.service.exceptions.ApplicationNotFoundException;
import io.gravitee.rest.api.service.exceptions.InstanceNotFoundException;
import io.gravitee.rest.api.service.exceptions.LogNotFoundException;
import io.gravitee.rest.api.service.exceptions.PlanNotFoundException;
import io.gravitee.rest.api.service.exceptions.SubscriptionNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.v4.ApiSearchService;
import io.gravitee.rest.api.service.v4.PlanSearchService;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class LogsServiceImpl
implements LogsService {
    private static final String UNKNOWN_SERVICE = "1";
    private static final String UNKNOWN_SERVICE_MAPPED = "?";
    private static final String METADATA_NAME = "name";
    private static final String METADATA_DELETED = "deleted";
    private static final String METADATA_UNKNOWN = "unknown";
    private static final String METADATA_VERSION = "version";
    private static final String METADATA_UNKNOWN_API_NAME = "Unknown API (not found)";
    private static final String METADATA_UNKNOWN_APPLICATION_NAME = "Unknown application (keyless)";
    private static final String METADATA_UNKNOWN_PLAN_NAME = "Unknown plan";
    private static final String METADATA_DELETED_API_NAME = "Deleted API";
    private static final String METADATA_DELETED_APPLICATION_NAME = "Deleted application";
    private static final String METADATA_DELETED_PLAN_NAME = "Deleted plan";
    private static final String RFC_3339_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final FastDateFormat dateFormatter = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final char separator = ';';
    private final Logger logger = LoggerFactory.getLogger(LogsServiceImpl.class);
    @Lazy
    @Autowired
    private LogRepository logRepository;
    @Autowired
    private ApiSearchService apiSearchService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private PlanSearchService planSearchService;
    @Autowired
    private InstanceService instanceService;
    @Autowired
    private ApiKeyService apiKeyService;
    @Autowired
    private SubscriptionService subscriptionService;
    @Autowired
    private AuditService auditService;
    @Autowired
    private ParameterService parameterService;

    @Override
    public SearchLogResponse<ApiRequestItem> findByApi(ExecutionContext executionContext, String api, LogQuery query) {
        try {
            String field = query.getField() == null ? "@timestamp" : query.getField();
            TabularResponse response = this.logRepository.query((TabularQuery)((TabularQueryBuilder)((TabularQueryBuilder)((TabularQueryBuilder)QueryBuilders.tabular().page(query.getPage()).size(query.getSize()).query(query.getQuery())).sort(SortBuilder.on((String)field, (Order)(query.isOrder() ? Order.ASC : Order.DESC), null)).timeRange(DateRangeBuilder.between((long)query.getFrom(), (long)query.getTo()), IntervalBuilder.interval((long)query.getInterval()))).root("api", api)).build());
            if (response == null) {
                return new SearchLogResponse(0L);
            }
            SearchLogResponse logResponse = new SearchLogResponse(response.getSize());
            logResponse.setLogs(response.getLogs().stream().map(this::toApiRequestItem).collect(Collectors.toList()));
            if (response.getSize() > 0L) {
                HashMap metadata = new HashMap();
                logResponse.getLogs().forEach(logItem -> {
                    String application = logItem.getApplication();
                    String plan = logItem.getPlan();
                    if (application != null) {
                        metadata.computeIfAbsent(application, this.getApplicationMetadata(executionContext, application));
                    }
                    if (plan != null) {
                        metadata.computeIfAbsent(plan, this.getPlanMetadata(executionContext, plan));
                    }
                });
                logResponse.setMetadata(metadata);
            }
            return logResponse;
        }
        catch (AnalyticsException ae) {
            this.logger.error("Unable to retrieve logs: ", (Throwable)ae);
            throw new TechnicalManagementException("Unable to retrieve logs", ae);
        }
    }

    @Override
    public ApiRequest findApiLog(ExecutionContext executionContext, String id, Long timestamp) {
        try {
            ExtendedLog log = this.logRepository.findById(id, timestamp);
            if (log == null) {
                return null;
            }
            if (this.parameterService.findAsBoolean(executionContext, Key.LOGGING_AUDIT_ENABLED, ParameterReferenceType.ORGANIZATION)) {
                this.auditService.createApiAuditLog(executionContext, log.getApi(), Collections.singletonMap(Audit.AuditProperties.REQUEST_ID, id), (Audit.AuditEvent)Log.AuditEvent.LOG_READ, new Date(), null, null);
            }
            return this.toApiRequest(executionContext, log);
        }
        catch (AnalyticsException ae) {
            this.logger.error("Unable to retrieve log: " + id, (Throwable)ae);
            throw new TechnicalManagementException("Unable to retrieve log: " + id, ae);
        }
    }

    @Override
    public SearchLogResponse<ApplicationRequestItem> findByApplication(ExecutionContext executionContext, String application, LogQuery query) {
        try {
            String field = query.getField() == null ? "@timestamp" : query.getField();
            TabularResponse response = this.logRepository.query((TabularQuery)((TabularQueryBuilder)((TabularQueryBuilder)((TabularQueryBuilder)QueryBuilders.tabular().page(query.getPage()).size(query.getSize()).query(query.getQuery())).sort(SortBuilder.on((String)field, (Order)(query.isOrder() ? Order.ASC : Order.DESC), null)).timeRange(DateRangeBuilder.between((long)query.getFrom(), (long)query.getTo()), IntervalBuilder.interval((long)query.getInterval()))).root("application", application)).build());
            if (response == null) {
                return new SearchLogResponse(0L);
            }
            SearchLogResponse logResponse = new SearchLogResponse(response.getSize());
            logResponse.setLogs(response.getLogs().stream().map(this::toApplicationRequestItem).collect(Collectors.toList()));
            if (response.getSize() > 0L) {
                HashMap metadata = new HashMap();
                logResponse.getLogs().forEach(logItem -> {
                    String api = logItem.getApi();
                    String plan = logItem.getPlan();
                    if (api != null) {
                        metadata.computeIfAbsent(api, this.getAPIMetadata(executionContext, api));
                    }
                    if (plan != null) {
                        metadata.computeIfAbsent(plan, this.getPlanMetadata(executionContext, plan));
                    }
                });
                logResponse.setMetadata(metadata);
            }
            return logResponse;
        }
        catch (AnalyticsException ae) {
            this.logger.error("Unable to retrieve logs: ", (Throwable)ae);
            throw new TechnicalManagementException("Unable to retrieve logs", ae);
        }
    }

    @Override
    public SearchLogResponse<PlatformRequestItem> findPlatform(ExecutionContext executionContext, LogQuery query) {
        try {
            String field = query.getField() == null ? "@timestamp" : query.getField();
            TabularResponse response = this.logRepository.query((TabularQuery)((TabularQueryBuilder)((TabularQueryBuilder)QueryBuilders.tabular().page(query.getPage()).size(query.getSize()).query(query.getQuery())).sort(SortBuilder.on((String)field, (Order)(query.isOrder() ? Order.ASC : Order.DESC), null)).timeRange(DateRangeBuilder.between((long)query.getFrom(), (long)query.getTo()), IntervalBuilder.interval((long)query.getInterval()))).build());
            if (response == null) {
                return new SearchLogResponse(0L);
            }
            SearchLogResponse logResponse = new SearchLogResponse(response.getSize());
            logResponse.setLogs(response.getLogs().stream().map(this::toPlatformRequestItem).collect(Collectors.toList()));
            if (response.getSize() > 0L) {
                HashMap metadata = new HashMap();
                logResponse.getLogs().forEach(logItem -> {
                    String api = logItem.getApi();
                    String application = logItem.getApplication();
                    String plan = logItem.getPlan();
                    if (api != null) {
                        metadata.computeIfAbsent(api, this.getAPIMetadata(executionContext, api));
                    }
                    if (application != null) {
                        metadata.computeIfAbsent(application, this.getApplicationMetadata(executionContext, application));
                    }
                    if (plan != null) {
                        metadata.computeIfAbsent(plan, this.getPlanMetadata(executionContext, plan));
                    }
                });
                logResponse.setMetadata(metadata);
            }
            return logResponse;
        }
        catch (AnalyticsException ae) {
            this.logger.error("Unable to retrieve logs: ", (Throwable)ae);
            throw new TechnicalManagementException("Unable to retrieve logs", ae);
        }
    }

    @Override
    public ApplicationRequest findApplicationLog(ExecutionContext executionContext, String id, Long timestamp) {
        try {
            ExtendedLog log = this.logRepository.findById(id, timestamp);
            if (log == null) {
                return null;
            }
            return this.toApplicationRequest(executionContext, log);
        }
        catch (AnalyticsException ae) {
            this.logger.error("Unable to retrieve log: " + id, (Throwable)ae);
            if (ae.getMessage().equals("Request [" + id + "] does not exist")) {
                throw new LogNotFoundException(id);
            }
            throw new TechnicalManagementException("Unable to retrieve log: " + id, ae);
        }
    }

    private Function<String, Map<String, String>> getAPIMetadata(ExecutionContext executionContext, String api) {
        return s -> {
            HashMap<String, String> metadata = new HashMap<String, String>();
            try {
                if (api.equals(UNKNOWN_SERVICE) || api.equals(UNKNOWN_SERVICE_MAPPED)) {
                    metadata.put(METADATA_NAME, METADATA_UNKNOWN_API_NAME);
                    metadata.put(METADATA_UNKNOWN, Boolean.TRUE.toString());
                } else {
                    GenericApiEntity genericApiEntity = this.apiSearchService.findGenericById(executionContext, api);
                    metadata.put(METADATA_NAME, genericApiEntity.getName());
                    metadata.put(METADATA_VERSION, genericApiEntity.getApiVersion());
                    if (ApiLifecycleState.ARCHIVED.equals((Object)genericApiEntity.getLifecycleState())) {
                        metadata.put(METADATA_DELETED, Boolean.TRUE.toString());
                    }
                }
            }
            catch (ApiNotFoundException anfe) {
                metadata.put(METADATA_DELETED, Boolean.TRUE.toString());
                metadata.put(METADATA_NAME, METADATA_DELETED_API_NAME);
            }
            return metadata;
        };
    }

    private Function<String, Map<String, String>> getApplicationMetadata(ExecutionContext executionContext, String application) {
        return s -> {
            HashMap<String, String> metadata = new HashMap<String, String>();
            try {
                if (application.equals(UNKNOWN_SERVICE) || application.equals(UNKNOWN_SERVICE_MAPPED)) {
                    metadata.put(METADATA_NAME, METADATA_UNKNOWN_APPLICATION_NAME);
                    metadata.put(METADATA_UNKNOWN, Boolean.TRUE.toString());
                } else {
                    ApplicationEntity applicationEntity = this.applicationService.findById(executionContext, application);
                    metadata.put(METADATA_NAME, applicationEntity.getName());
                    if (ApplicationStatus.ARCHIVED.toString().equals(applicationEntity.getStatus())) {
                        metadata.put(METADATA_DELETED, Boolean.TRUE.toString());
                    }
                }
            }
            catch (ApplicationNotFoundException anfe) {
                metadata.put(METADATA_DELETED, Boolean.TRUE.toString());
                metadata.put(METADATA_NAME, METADATA_DELETED_APPLICATION_NAME);
            }
            return metadata;
        };
    }

    private Function<String, Map<String, String>> getPlanMetadata(ExecutionContext executionContext, String plan) {
        return s -> {
            HashMap<String, String> metadata = new HashMap<String, String>();
            try {
                if (plan.equals(UNKNOWN_SERVICE) || plan.equals(UNKNOWN_SERVICE_MAPPED)) {
                    metadata.put(METADATA_NAME, METADATA_UNKNOWN_PLAN_NAME);
                    metadata.put(METADATA_UNKNOWN, Boolean.TRUE.toString());
                } else {
                    GenericPlanEntity planEntity = this.planSearchService.findById(executionContext, plan);
                    metadata.put(METADATA_NAME, planEntity.getName());
                }
            }
            catch (PlanNotFoundException anfe) {
                metadata.put(METADATA_DELETED, Boolean.TRUE.toString());
                metadata.put(METADATA_NAME, METADATA_DELETED_PLAN_NAME);
            }
            return metadata;
        };
    }

    private Function<String, Map<String, String>> getGatewayMetadata(ExecutionContext executionContext, String gateway) {
        return s -> {
            HashMap<String, String> metadata = new HashMap<String, String>();
            try {
                InstanceEntity instance = this.instanceService.findById(executionContext, gateway);
                metadata.put("hostname", instance.getHostname());
                metadata.put("ip", instance.getIp());
                if (instance.getTenant() != null) {
                    metadata.put("tenant", instance.getTenant());
                }
            }
            catch (InstanceNotFoundException infe) {
                metadata.put(METADATA_DELETED, "true");
            }
            return metadata;
        };
    }

    private String getSubscription(ExecutionContext executionContext, ExtendedLog log) {
        if (PlanSecurityType.API_KEY.name().equals(log.getSecurityType())) {
            try {
                return this.getApiKeySubscription(executionContext, log);
            }
            catch (ApiKeyNotFoundException e) {
                this.logger.error("Unable to find API Key for log [api={}, application={}]", (Object)log.getApi(), (Object)log.getApplication());
            }
        } else if (log.getPlan() != null && log.getApplication() != null) {
            try {
                return this.getJwtOrOauth2Subscription(executionContext, log);
            }
            catch (PlanNotFoundException | SubscriptionNotFoundException | IllegalStateException e) {
                this.logger.error(String.format("Unable to find subscription for log [plan=%s, application=%s]", log.getPlan(), log.getApplication()), (Throwable)e);
            }
        }
        return null;
    }

    private String getApiKeySubscription(ExecutionContext executionContext, ExtendedLog log) {
        return this.apiKeyService.findByKeyAndApi(executionContext, log.getSecurityToken(), log.getApi()).getSubscriptions().stream().filter(s -> s.getApi().equals(log.getApi())).findFirst().map(SubscriptionEntity::getId).orElseThrow(ApiKeyNotFoundException::new);
    }

    private String getJwtOrOauth2Subscription(ExecutionContext executionContext, ExtendedLog log) {
        GenericPlanEntity plan = this.planSearchService.findById(executionContext, log.getPlan());
        if (plan.getPlanSecurity() == null || plan.getPlanSecurity().getType() == null) {
            return null;
        }
        PlanSecurityType planSecurityType = PlanSecurityType.valueOfLabel((String)plan.getPlanSecurity().getType());
        if (PlanSecurityType.API_KEY == planSecurityType || PlanSecurityType.KEY_LESS == planSecurityType) {
            return null;
        }
        Collection<SubscriptionEntity> subscriptions = this.subscriptionService.findByApplicationAndPlan(executionContext, log.getApplication(), log.getPlan());
        if (subscriptions.size() > 1) {
            throw new IllegalStateException("Found more than one subscription for the same application and plan");
        }
        return subscriptions.stream().findFirst().map(SubscriptionEntity::getId).orElseThrow(() -> new SubscriptionNotFoundException(null));
    }

    @Override
    public String exportAsCsv(ExecutionContext executionContext, SearchLogResponse<?> searchLogResponse) {
        StringBuilder sb;
        block7: {
            boolean userEnabled;
            block8: {
                block6: {
                    if (searchLogResponse.getLogs() == null || searchLogResponse.getLogs().isEmpty()) {
                        return "";
                    }
                    sb = new StringBuilder();
                    sb.append("Date");
                    sb.append(';');
                    sb.append("Request Id");
                    sb.append(';');
                    sb.append("Transaction Id");
                    sb.append(';');
                    sb.append("Method");
                    sb.append(';');
                    sb.append("Path");
                    sb.append(';');
                    sb.append("Status");
                    sb.append(';');
                    sb.append("Response Time");
                    sb.append(';');
                    sb.append("Plan");
                    sb.append(';');
                    userEnabled = this.parameterService.findAsBoolean(executionContext, Key.LOGGING_USER_DISPLAYED, ParameterReferenceType.ORGANIZATION);
                    if (!(searchLogResponse.getLogs().get(0) instanceof ApiRequestItem)) break block6;
                    if (userEnabled) {
                        sb.append("User");
                        sb.append(';');
                    }
                    sb.append("Application");
                    sb.append(System.lineSeparator());
                    for (Object log : searchLogResponse.getLogs()) {
                        ApiRequestItem apiLog = (ApiRequestItem)log;
                        this.processLine(searchLogResponse, sb, apiLog.getTimestamp(), apiLog.getId(), apiLog.getTransactionId(), apiLog.getMethod(), apiLog.getPath(), apiLog.getStatus(), apiLog.getResponseTime(), apiLog.getPlan(), userEnabled, apiLog.getUser());
                        Object application = searchLogResponse.getMetadata().get(apiLog.getApplication());
                        sb.append(this.getName(application));
                        sb.append(System.lineSeparator());
                    }
                    break block7;
                }
                if (!(searchLogResponse.getLogs().get(0) instanceof ApplicationRequestItem)) break block8;
                sb.append("API");
                sb.append(System.lineSeparator());
                for (Object log : searchLogResponse.getLogs()) {
                    ApplicationRequestItem applicationLog = (ApplicationRequestItem)log;
                    this.processLine(searchLogResponse, sb, applicationLog.getTimestamp(), applicationLog.getId(), applicationLog.getTransactionId(), applicationLog.getMethod(), applicationLog.getPath(), applicationLog.getStatus(), applicationLog.getResponseTime(), applicationLog.getPlan(), false, applicationLog.getUser());
                    Object api = searchLogResponse.getMetadata().get(applicationLog.getApi());
                    sb.append(this.getName(api));
                    sb.append(System.lineSeparator());
                }
                break block7;
            }
            if (!(searchLogResponse.getLogs().get(0) instanceof PlatformRequestItem)) break block7;
            if (userEnabled) {
                sb.append("User");
                sb.append(';');
            }
            sb.append("API");
            sb.append(';');
            sb.append("Application");
            sb.append(System.lineSeparator());
            for (Object log : searchLogResponse.getLogs()) {
                PlatformRequestItem platformLog = (PlatformRequestItem)log;
                this.processLine(searchLogResponse, sb, platformLog.getTimestamp(), platformLog.getId(), platformLog.getTransactionId(), platformLog.getMethod(), platformLog.getPath(), platformLog.getStatus(), platformLog.getResponseTime(), platformLog.getPlan(), userEnabled, platformLog.getUser());
                Object api = searchLogResponse.getMetadata().get(platformLog.getApi());
                sb.append(this.getName(api));
                sb.append(';');
                Object application = searchLogResponse.getMetadata().get(platformLog.getApplication());
                sb.append(this.getName(application));
                sb.append(System.lineSeparator());
            }
        }
        return sb.toString();
    }

    private void processLine(SearchLogResponse searchLogResponse, StringBuilder sb, long timestamp, String id, String transactionId, HttpMethod method, String path, int status, long responseTime, String plan, boolean userEnabled, String user) {
        sb.append(dateFormatter.format(timestamp));
        sb.append(';');
        sb.append(id);
        sb.append(';');
        sb.append(transactionId);
        sb.append(';');
        sb.append(method);
        sb.append(';');
        sb.append(path);
        sb.append(';');
        sb.append(status);
        sb.append(';');
        sb.append(responseTime);
        sb.append(';');
        sb.append(this.getName(searchLogResponse.getMetadata().get(plan)));
        sb.append(';');
        if (userEnabled) {
            sb.append(user);
            sb.append(';');
        }
    }

    private String getName(Object map) {
        return map == null ? "" : ((Map)map).get(METADATA_NAME).toString();
    }

    private PlatformRequestItem toPlatformRequestItem(Log log) {
        PlatformRequestItem req = new PlatformRequestItem();
        req.setId(log.getId());
        req.setTransactionId(log.getTransactionId());
        req.setApi(log.getApi());
        req.setApplication(log.getApplication());
        req.setMethod(log.getMethod());
        req.setPath(new QueryStringDecoder(log.getUri()).toString());
        req.setPlan(log.getPlan());
        req.setResponseTime(log.getResponseTime());
        req.setStatus(log.getStatus());
        req.setTimestamp(log.getTimestamp());
        req.setEndpoint(log.getEndpoint() != null);
        req.setUser(log.getUser());
        return req;
    }

    private ApiRequestItem toApiRequestItem(Log log) {
        ApiRequestItem req = new ApiRequestItem();
        req.setId(log.getId());
        req.setTransactionId(log.getTransactionId());
        req.setApplication(log.getApplication());
        req.setMethod(log.getMethod());
        req.setPath(new QueryStringDecoder(log.getUri()).toString());
        req.setPlan(log.getPlan());
        req.setResponseTime(log.getResponseTime());
        req.setStatus(log.getStatus());
        req.setTimestamp(log.getTimestamp());
        req.setEndpoint(log.getEndpoint() != null);
        req.setUser(log.getUser());
        return req;
    }

    private ApplicationRequestItem toApplicationRequestItem(Log log) {
        ApplicationRequestItem req = new ApplicationRequestItem();
        req.setId(log.getId());
        req.setTransactionId(log.getTransactionId());
        req.setApi(log.getApi());
        req.setMethod(log.getMethod());
        req.setPath(new QueryStringDecoder(log.getUri()).toString());
        req.setPlan(log.getPlan());
        req.setResponseTime(log.getResponseTime());
        req.setStatus(log.getStatus());
        req.setTimestamp(log.getTimestamp());
        req.setUser(log.getUser());
        return req;
    }

    private ApiRequest toApiRequest(ExecutionContext executionContext, ExtendedLog log) {
        ApiRequest req = new ApiRequest();
        req.setId(log.getId());
        req.setApi(log.getApi());
        req.setTransactionId(log.getTransactionId());
        req.setApplication(log.getApplication());
        req.setApiResponseTime(log.getApiResponseTime());
        req.setEndpoint(log.getEndpoint());
        req.setLocalAddress(log.getLocalAddress());
        req.setRemoteAddress(log.getRemoteAddress());
        req.setMethod(log.getMethod());
        req.setPath(new QueryStringDecoder(log.getUri()).toString());
        req.setPlan(log.getPlan());
        req.setRequestContentLength(log.getRequestContentLength());
        req.setResponseContentLength(log.getResponseContentLength());
        req.setResponseTime(log.getResponseTime());
        req.setStatus(log.getStatus());
        req.setTenant(log.getTenant());
        req.setTimestamp(log.getTimestamp());
        req.setUri(log.getUri());
        req.setMessage(log.getMessage());
        req.setGateway(log.getGateway());
        req.setSubscription(this.getSubscription(executionContext, log));
        req.setHost(log.getHost());
        req.setSecurityType(log.getSecurityType());
        req.setSecurityToken(log.getSecurityToken());
        req.setClientRequest(this.createRequest(log.getClientRequest()));
        req.setProxyRequest(this.createRequest(log.getProxyRequest()));
        req.setClientResponse(this.createResponse(log.getClientResponse()));
        req.setProxyResponse(this.createResponse(log.getProxyResponse()));
        HashMap<String, Map<String, String>> metadata = new HashMap<String, Map<String, String>>();
        String application = log.getApplication();
        String plan = log.getPlan();
        String gateway = log.getGateway();
        if (application != null) {
            metadata.computeIfAbsent(application, this.getApplicationMetadata(executionContext, application));
        }
        if (plan != null) {
            metadata.computeIfAbsent(plan, this.getPlanMetadata(executionContext, plan));
        }
        if (gateway != null) {
            metadata.computeIfAbsent(gateway, this.getGatewayMetadata(executionContext, gateway));
        }
        req.setMetadata(metadata);
        req.setUser(log.getUser());
        return req;
    }

    private Request createRequest(io.gravitee.repository.log.model.Request repoRequest) {
        if (repoRequest == null) {
            return null;
        }
        Request request = new Request();
        request.setUri(repoRequest.getUri());
        request.setMethod(repoRequest.getMethod());
        request.setHeaders(repoRequest.getHeaders());
        request.setBody(repoRequest.getBody());
        return request;
    }

    private io.gravitee.rest.api.model.log.extended.Response createResponse(Response repoResponse) {
        if (repoResponse == null) {
            return null;
        }
        io.gravitee.rest.api.model.log.extended.Response response = new io.gravitee.rest.api.model.log.extended.Response();
        response.setStatus(repoResponse.getStatus());
        response.setHeaders(repoResponse.getHeaders());
        response.setBody(repoResponse.getBody());
        return response;
    }

    private ApplicationRequest toApplicationRequest(ExecutionContext executionContext, ExtendedLog log) {
        ApplicationRequest req = new ApplicationRequest();
        req.setId(log.getId());
        req.setTransactionId(log.getTransactionId());
        req.setApi(log.getApi());
        req.setMethod(log.getMethod());
        req.setUri(log.getUri());
        req.setPath(new QueryStringDecoder(log.getUri()).toString());
        req.setPlan(log.getPlan());
        req.setRequestContentLength(log.getRequestContentLength());
        req.setResponseContentLength(log.getResponseContentLength());
        req.setResponseTime(log.getResponseTime());
        req.setStatus(log.getStatus());
        req.setTimestamp(log.getTimestamp());
        req.setRequest(this.createRequest(log.getClientRequest()));
        req.setResponse(this.createResponse(log.getClientResponse()));
        req.setHost(log.getHost());
        req.setSecurityType(log.getSecurityType());
        req.setSecurityToken(log.getSecurityToken());
        HashMap<String, Map<String, String>> metadata = new HashMap<String, Map<String, String>>();
        String api = log.getApi();
        String plan = log.getPlan();
        String gateway = log.getGateway();
        if (api != null) {
            metadata.computeIfAbsent(api, this.getAPIMetadata(executionContext, api));
        }
        if (plan != null) {
            metadata.computeIfAbsent(plan, this.getPlanMetadata(executionContext, plan));
        }
        if (gateway != null) {
            metadata.computeIfAbsent(gateway, this.getGatewayMetadata(executionContext, gateway));
        }
        req.setMetadata(metadata);
        req.setUser(log.getUser());
        return req;
    }
}

