/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.RoleRepository;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Role;
import io.gravitee.repository.management.model.RoleReferenceType;
import io.gravitee.repository.management.model.RoleScope;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.NewRoleEntity;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.UpdateRoleEntity;
import io.gravitee.rest.api.model.permissions.ApiPermission;
import io.gravitee.rest.api.model.permissions.ApplicationPermission;
import io.gravitee.rest.api.model.permissions.EnvironmentPermission;
import io.gravitee.rest.api.model.permissions.GroupPermission;
import io.gravitee.rest.api.model.permissions.OrganizationPermission;
import io.gravitee.rest.api.model.permissions.Permission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.common.DefaultRoleEntityDefinition;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.common.RandomString;
import io.gravitee.rest.api.service.exceptions.DefaultRoleNotFoundException;
import io.gravitee.rest.api.service.exceptions.RoleAlreadyExistsException;
import io.gravitee.rest.api.service.exceptions.RoleDeletionForbiddenException;
import io.gravitee.rest.api.service.exceptions.RoleNotFoundException;
import io.gravitee.rest.api.service.exceptions.RoleReservedNameException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RoleServiceImpl
extends AbstractService
implements RoleService {
    private final Logger LOGGER = LoggerFactory.getLogger(RoleServiceImpl.class);
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private MembershipService membershipService;
    @Autowired
    private AuditService auditService;
    private Map<String, RoleEntity> apiPrimaryOwnersByOrganization = new ConcurrentHashMap<String, RoleEntity>();
    private Map<String, RoleEntity> applicationPrimaryOwnersByOrganization = new ConcurrentHashMap<String, RoleEntity>();

    @Override
    public RoleEntity findById(String roleId) {
        return GraviteeContext.getCurrentRoles().computeIfAbsent(roleId, k -> {
            try {
                this.LOGGER.debug("Find Role by id");
                Optional role = this.roleRepository.findById(k);
                if (!role.isPresent()) {
                    throw new RoleNotFoundException((String)k);
                }
                return this.convert((Role)role.get());
            }
            catch (TechnicalException ex) {
                this.LOGGER.error("An error occurs while trying to find a role : {}", k, (Object)ex);
                throw new TechnicalManagementException("An error occurs while trying to find a role : " + k, ex);
            }
        });
    }

    @Override
    public List<RoleEntity> findAll() {
        return this.findAllByOrganization(GraviteeContext.getCurrentOrganization());
    }

    private List<RoleEntity> findAllByOrganization(String organizationId) {
        try {
            this.LOGGER.debug("Find all Roles");
            return this.roleRepository.findAllByReferenceIdAndReferenceType(organizationId, RoleReferenceType.ORGANIZATION).stream().map(this::convert).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find all roles", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all roles", ex);
        }
    }

    @Override
    public RoleEntity create(NewRoleEntity roleEntity) {
        return this.create(roleEntity, GraviteeContext.getCurrentOrganization());
    }

    private RoleEntity create(NewRoleEntity roleEntity, String organizationId) {
        try {
            Role role = this.convert(roleEntity);
            if (this.roleRepository.findByScopeAndNameAndReferenceIdAndReferenceType(role.getScope(), role.getName(), organizationId, RoleReferenceType.ORGANIZATION).isPresent()) {
                throw new RoleAlreadyExistsException(role.getScope(), role.getName());
            }
            role.setId(RandomString.generate());
            role.setCreatedAt(new Date());
            role.setUpdatedAt(role.getCreatedAt());
            role.setReferenceId(organizationId);
            role.setReferenceType(RoleReferenceType.ORGANIZATION);
            RoleEntity entity = this.convert(this.roleRepository.create(role));
            this.auditService.createOrganizationAuditLog(Collections.singletonMap(Audit.AuditProperties.ROLE, role.getScope() + ":" + role.getName()), (Audit.AuditEvent)Role.AuditEvent.ROLE_CREATED, role.getCreatedAt(), null, role);
            if (entity.isDefaultRole()) {
                this.toggleDefaultRole(roleEntity.getScope(), entity.getName());
            }
            return entity;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create role {}", (Object)roleEntity.getName(), (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to create role " + roleEntity.getName(), ex);
        }
    }

    @Override
    public RoleEntity update(UpdateRoleEntity roleEntity) {
        if (this.isReserved(roleEntity.getName())) {
            throw new RoleReservedNameException(roleEntity.getName());
        }
        io.gravitee.rest.api.model.permissions.RoleScope scope = roleEntity.getScope();
        try {
            Optional optRole = this.roleRepository.findById(roleEntity.getId());
            if (!optRole.isPresent()) {
                throw new RoleNotFoundException(roleEntity.getId());
            }
            Role role = (Role)optRole.get();
            Role updatedRole = this.convert(roleEntity);
            updatedRole.setCreatedAt(role.getCreatedAt());
            updatedRole.setReferenceId(role.getReferenceId());
            updatedRole.setReferenceType(role.getReferenceType());
            RoleEntity entity = this.convert(this.roleRepository.update(updatedRole));
            this.auditService.createOrganizationAuditLog(Collections.singletonMap(Audit.AuditProperties.ROLE, role.getScope() + ":" + role.getName()), (Audit.AuditEvent)Role.AuditEvent.ROLE_UPDATED, updatedRole.getUpdatedAt(), role, updatedRole);
            if (entity.isDefaultRole()) {
                this.toggleDefaultRole(scope, entity.getName());
            }
            return entity;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to update role {}", (Object)roleEntity.getName(), (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to update role " + roleEntity.getName(), ex);
        }
    }

    @Override
    public void delete(String roleId) {
        try {
            Optional optRole = this.roleRepository.findById(roleId);
            if (!optRole.isPresent()) {
                throw new RoleNotFoundException(roleId);
            }
            Role role = (Role)optRole.get();
            io.gravitee.rest.api.model.permissions.RoleScope scope = this.convert(role.getScope());
            if (role.isDefaultRole() || role.isSystem()) {
                throw new RoleDeletionForbiddenException(scope, role.getName());
            }
            List<RoleEntity> defaultRoleByScopes = this.findDefaultRoleByScopes(scope);
            if (defaultRoleByScopes.isEmpty()) {
                throw new DefaultRoleNotFoundException(new io.gravitee.rest.api.model.permissions.RoleScope[0]);
            }
            this.membershipService.removeRoleUsage(roleId, defaultRoleByScopes.get(0).getId());
            this.roleRepository.delete(roleId);
            this.auditService.createOrganizationAuditLog(Collections.singletonMap(Audit.AuditProperties.ROLE, scope + ":" + role.getName()), (Audit.AuditEvent)Role.AuditEvent.ROLE_DELETED, role.getUpdatedAt(), role, null);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete role {}", (Object)roleId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete role " + roleId, ex);
        }
    }

    @Override
    public List<RoleEntity> findByScope(io.gravitee.rest.api.model.permissions.RoleScope scope) {
        try {
            this.LOGGER.debug("Find Roles by scope");
            return this.roleRepository.findByScopeAndReferenceIdAndReferenceType(this.convert(scope), GraviteeContext.getCurrentOrganization(), RoleReferenceType.ORGANIZATION).stream().map(this::convert).sorted(Comparator.comparing(RoleEntity::getName)).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find roles by scope", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find roles by scope", ex);
        }
    }

    @Override
    public Optional<RoleEntity> findByScopeAndName(io.gravitee.rest.api.model.permissions.RoleScope scope, String name) {
        return this.findByScopeAndName(scope, name, GraviteeContext.getCurrentOrganization());
    }

    private Optional<RoleEntity> findByScopeAndName(io.gravitee.rest.api.model.permissions.RoleScope scope, String name, String organizationId) {
        try {
            this.LOGGER.debug("Find Roles by scope and name");
            Optional optRole = this.roleRepository.findByScopeAndNameAndReferenceIdAndReferenceType(this.convert(scope), name, organizationId, RoleReferenceType.ORGANIZATION);
            if (optRole.isPresent()) {
                return Optional.of(this.convert((Role)optRole.get()));
            }
            return Optional.empty();
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find roles by scope", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find roles by scope", ex);
        }
    }

    @Override
    public List<RoleEntity> findDefaultRoleByScopes(io.gravitee.rest.api.model.permissions.RoleScope ... scopes) {
        try {
            this.LOGGER.debug("Find default Roles by scope");
            ArrayList<RoleEntity> roles = new ArrayList<RoleEntity>();
            for (io.gravitee.rest.api.model.permissions.RoleScope scope : scopes) {
                roles.addAll(this.roleRepository.findByScopeAndReferenceIdAndReferenceType(this.convert(scope), GraviteeContext.getCurrentOrganization(), RoleReferenceType.ORGANIZATION).stream().filter(Role::isDefaultRole).map(this::convert).collect(Collectors.toList()));
            }
            return roles;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find default roles by scope", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find default roles by scope", ex);
        }
    }

    @Override
    public boolean hasPermission(Map<String, char[]> userPermissions, Permission permission, RolePermissionAction[] acls) {
        boolean hasPermission = false;
        if (userPermissions != null) {
            Iterator<Map.Entry<String, char[]>> it = userPermissions.entrySet().iterator();
            while (it.hasNext() && !hasPermission) {
                Map.Entry<String, char[]> entry = it.next();
                if (!permission.getName().equals(entry.getKey())) continue;
                String crud = Arrays.toString(entry.getValue());
                for (RolePermissionAction perm : acls) {
                    if (crud.indexOf(perm.getId()) == -1) continue;
                    hasPermission = true;
                }
            }
        }
        return hasPermission;
    }

    private void toggleDefaultRole(io.gravitee.rest.api.model.permissions.RoleScope scope, String newDefaultRoleName) throws TechnicalException {
        List roles = this.roleRepository.findByScopeAndReferenceIdAndReferenceType(this.convert(scope), GraviteeContext.getCurrentOrganization(), RoleReferenceType.ORGANIZATION).stream().filter(Role::isDefaultRole).collect(Collectors.toList());
        for (Role role : roles) {
            if (role.getName().equals(newDefaultRoleName)) continue;
            Role previousRole = new Role(role);
            role.setDefaultRole(false);
            role.setUpdatedAt(new Date());
            this.roleRepository.update(role);
            this.auditService.createOrganizationAuditLog(Collections.singletonMap(Audit.AuditProperties.ROLE, role.getScope() + ":" + role.getName()), (Audit.AuditEvent)Role.AuditEvent.ROLE_UPDATED, role.getUpdatedAt(), previousRole, role);
        }
    }

    private Role convert(NewRoleEntity roleEntity) {
        Role role = new Role();
        role.setName(this.generateId(roleEntity.getName()));
        role.setDescription(roleEntity.getDescription());
        role.setScope(this.convert(roleEntity.getScope()));
        role.setDefaultRole(roleEntity.isDefaultRole());
        role.setPermissions(this.convertPermissions(roleEntity.getScope(), roleEntity.getPermissions()));
        role.setCreatedAt(new Date());
        role.setUpdatedAt(role.getCreatedAt());
        return role;
    }

    private Role convert(UpdateRoleEntity roleEntity) {
        if (roleEntity == null) {
            return null;
        }
        Role role = new Role();
        role.setName(this.generateId(roleEntity.getName()));
        role.setId(roleEntity.getId());
        role.setDescription(roleEntity.getDescription());
        role.setScope(this.convert(roleEntity.getScope()));
        role.setDefaultRole(roleEntity.isDefaultRole());
        role.setPermissions(this.convertPermissions(roleEntity.getScope(), roleEntity.getPermissions()));
        role.setUpdatedAt(new Date());
        return role;
    }

    private RoleEntity convert(Role role) {
        if (role == null) {
            return null;
        }
        RoleEntity roleEntity = new RoleEntity();
        roleEntity.setId(role.getId());
        roleEntity.setName(role.getName());
        roleEntity.setDescription(role.getDescription());
        roleEntity.setScope(this.convert(role.getScope()));
        roleEntity.setDefaultRole(role.isDefaultRole());
        roleEntity.setSystem(role.isSystem());
        roleEntity.setPermissions(this.convertPermissions(roleEntity.getScope(), role.getPermissions()));
        return roleEntity;
    }

    private int[] convertPermissions(io.gravitee.rest.api.model.permissions.RoleScope scope, Map<String, char[]> perms) {
        if (perms == null || perms.isEmpty()) {
            return new int[0];
        }
        int[] result = new int[perms.size()];
        int idx = 0;
        for (Map.Entry<String, char[]> entry : perms.entrySet()) {
            int perm = 0;
            for (char c : entry.getValue()) {
                perm += RolePermissionAction.findById((char)c).getMask();
            }
            result[idx++] = Permission.findByScopeAndName((io.gravitee.rest.api.model.permissions.RoleScope)scope, (String)entry.getKey()).getMask() + perm;
        }
        return result;
    }

    private Map<String, char[]> convertPermissions(io.gravitee.rest.api.model.permissions.RoleScope scope, int[] perms) {
        if (perms == null) {
            return Collections.emptyMap();
        }
        HashMap<String, char[]> result = new HashMap<String, char[]>();
        Stream.of(Permission.findByScope((io.gravitee.rest.api.model.permissions.RoleScope)scope)).forEach(perm -> {
            for (int action : perms) {
                if (action / 100 != perm.getMask() / 100) continue;
                ArrayList<Character> crud = new ArrayList<Character>();
                for (RolePermissionAction rolePermissionAction : RolePermissionAction.values()) {
                    if ((action - perm.getMask() & rolePermissionAction.getMask()) == 0) continue;
                    crud.add(Character.valueOf(rolePermissionAction.getId()));
                }
                result.put(perm.getName(), ArrayUtils.toPrimitive((Character[])crud.toArray(new Character[crud.size()])));
            }
        });
        return result;
    }

    private RoleScope convert(io.gravitee.rest.api.model.permissions.RoleScope scope) {
        if (scope == null) {
            return null;
        }
        return RoleScope.valueOf((String)scope.name());
    }

    private io.gravitee.rest.api.model.permissions.RoleScope convert(RoleScope scope) {
        if (scope == null) {
            return null;
        }
        return io.gravitee.rest.api.model.permissions.RoleScope.valueOf((String)scope.name());
    }

    private String generateId(String name) {
        String id = name.trim().toUpperCase().replaceAll(" +", " ").replaceAll(" ", "_").replaceAll("[^\\w\\s]", "_").replaceAll("-+", "_");
        if (this.isReserved(id)) {
            throw new RoleReservedNameException(id);
        }
        return id;
    }

    private boolean isReserved(String name) {
        for (SystemRole systemRole : SystemRole.values()) {
            if (!systemRole.name().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initialize(String organizationId) {
        this.LOGGER.info("     - <ORGANIZATION> USER (default)");
        this.create(DefaultRoleEntityDefinition.DEFAULT_ROLE_ORGANIZATION_USER, organizationId);
        this.LOGGER.info("     - <ENVIRONMENT> API_PUBLISHER");
        this.create(DefaultRoleEntityDefinition.ROLE_ENVIRONMENT_API_PUBLISHER, organizationId);
        this.LOGGER.info("     - <ENVIRONMENT> USER (default)");
        this.create(DefaultRoleEntityDefinition.DEFAULT_ROLE_ENVIRONMENT_USER, organizationId);
        this.LOGGER.info("     - <API> USER (default)");
        this.create(DefaultRoleEntityDefinition.DEFAULT_ROLE_API_USER, organizationId);
        this.LOGGER.info("     - <API> OWNER");
        this.create(DefaultRoleEntityDefinition.ROLE_API_OWNER, organizationId);
        this.LOGGER.info("     - <API> REVIEWER");
        this.create(DefaultRoleEntityDefinition.ROLE_API_REVIEWER, organizationId);
        this.LOGGER.info("     - <APPLICATION> USER (default)");
        this.create(DefaultRoleEntityDefinition.DEFAULT_ROLE_APPLICATION_USER, organizationId);
        this.LOGGER.info("     - <APPLICATION> OWNER");
        this.create(DefaultRoleEntityDefinition.ROLE_APPLICATION_OWNER, organizationId);
    }

    @Override
    public void createOrUpdateSystemRoles(String organizationId) {
        try {
            this.createOrUpdateSystemRole(SystemRole.ADMIN, io.gravitee.rest.api.model.permissions.RoleScope.ORGANIZATION, (Permission[])OrganizationPermission.values(), organizationId);
            this.createOrUpdateSystemRole(SystemRole.ADMIN, io.gravitee.rest.api.model.permissions.RoleScope.ENVIRONMENT, (Permission[])EnvironmentPermission.values(), organizationId);
            this.createOrUpdateSystemRole(SystemRole.PRIMARY_OWNER, io.gravitee.rest.api.model.permissions.RoleScope.API, (Permission[])Arrays.stream(ApiPermission.values()).filter(permission -> !ApiPermission.REVIEWS.equals(permission)).toArray(Permission[]::new), organizationId);
            this.createOrUpdateSystemRole(SystemRole.PRIMARY_OWNER, io.gravitee.rest.api.model.permissions.RoleScope.APPLICATION, (Permission[])ApplicationPermission.values(), organizationId);
            this.createOrUpdateSystemRole(SystemRole.ADMIN, io.gravitee.rest.api.model.permissions.RoleScope.GROUP, (Permission[])GroupPermission.values(), organizationId);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create admin roles", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to create admin roles ", ex);
        }
    }

    @Override
    public io.gravitee.rest.api.model.permissions.RoleScope findScopeByMembershipReferenceType(MembershipReferenceType type) {
        switch (type) {
            case API: {
                return io.gravitee.rest.api.model.permissions.RoleScope.API;
            }
            case GROUP: {
                return io.gravitee.rest.api.model.permissions.RoleScope.GROUP;
            }
            case APPLICATION: {
                return io.gravitee.rest.api.model.permissions.RoleScope.APPLICATION;
            }
            case ENVIRONMENT: {
                return io.gravitee.rest.api.model.permissions.RoleScope.ENVIRONMENT;
            }
            case ORGANIZATION: {
                return io.gravitee.rest.api.model.permissions.RoleScope.ORGANIZATION;
            }
            case PLATFORM: {
                return io.gravitee.rest.api.model.permissions.RoleScope.PLATFORM;
            }
        }
        return null;
    }

    @Override
    public RoleEntity findPrimaryOwnerRoleByOrganization(String organizationId, io.gravitee.rest.api.model.permissions.RoleScope roleScope) {
        if (roleScope == io.gravitee.rest.api.model.permissions.RoleScope.API) {
            return this.apiPrimaryOwnersByOrganization.computeIfAbsent(organizationId, s -> this.findByScopeAndName(io.gravitee.rest.api.model.permissions.RoleScope.API, SystemRole.PRIMARY_OWNER.name(), (String)s).get());
        }
        if (roleScope == io.gravitee.rest.api.model.permissions.RoleScope.APPLICATION) {
            return this.applicationPrimaryOwnersByOrganization.computeIfAbsent(organizationId, s -> this.findByScopeAndName(io.gravitee.rest.api.model.permissions.RoleScope.APPLICATION, SystemRole.PRIMARY_OWNER.name(), (String)s).get());
        }
        throw new RoleNotFoundException(roleScope + "_PRIMARY_OWNER");
    }

    private void createOrUpdateSystemRole(SystemRole roleName, io.gravitee.rest.api.model.permissions.RoleScope roleScope, Permission[] permissions, String organizationId) throws TechnicalException {
        Role systemRole = this.createSystemRoleWithoutPermissions(roleName.name(), roleScope, new Date());
        HashMap<String, char[]> perms = new HashMap<String, char[]>();
        for (Permission perm : permissions) {
            perms.put(perm.getName(), new char[]{RolePermissionAction.CREATE.getId(), RolePermissionAction.READ.getId(), RolePermissionAction.UPDATE.getId(), RolePermissionAction.DELETE.getId()});
        }
        systemRole.setPermissions(this.convertPermissions(roleScope, perms));
        systemRole.setReferenceId(organizationId);
        systemRole.setReferenceType(RoleReferenceType.ORGANIZATION);
        Optional existingRole = this.roleRepository.findByScopeAndNameAndReferenceIdAndReferenceType(systemRole.getScope(), systemRole.getName(), organizationId, RoleReferenceType.ORGANIZATION);
        if (existingRole.isPresent() && this.permissionsAreDifferent((Role)existingRole.get(), systemRole)) {
            systemRole.setId(((Role)existingRole.get()).getId());
            systemRole.setUpdatedAt(new Date());
            this.roleRepository.update(systemRole);
            this.auditService.createOrganizationAuditLog(Collections.singletonMap(Audit.AuditProperties.ROLE, systemRole.getScope() + ":" + systemRole.getName()), (Audit.AuditEvent)Role.AuditEvent.ROLE_UPDATED, systemRole.getCreatedAt(), existingRole, systemRole);
        } else if (!existingRole.isPresent()) {
            this.roleRepository.create(systemRole);
            this.auditService.createOrganizationAuditLog(Collections.singletonMap(Audit.AuditProperties.ROLE, systemRole.getScope() + ":" + systemRole.getName()), (Audit.AuditEvent)Role.AuditEvent.ROLE_CREATED, systemRole.getCreatedAt(), null, systemRole);
        }
    }

    private Role createSystemRoleWithoutPermissions(String name, io.gravitee.rest.api.model.permissions.RoleScope scope, Date date) {
        this.LOGGER.info("      - <" + scope + "> " + name + " (system)");
        Role systemRole = new Role();
        systemRole.setId(RandomString.generate());
        systemRole.setName(name);
        systemRole.setDescription("System Role. Created by Gravitee.io");
        systemRole.setDefaultRole(false);
        systemRole.setSystem(true);
        systemRole.setScope(this.convert(scope));
        systemRole.setCreatedAt(date);
        systemRole.setUpdatedAt(date);
        return systemRole;
    }

    private boolean permissionsAreDifferent(Role role1, Role role2) {
        return Arrays.stream(role1.getPermissions()).reduce(Math::addExact).orElse(0) != Arrays.stream(role2.getPermissions()).reduce(Math::addExact).orElse(0);
    }
}

