/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.notification;

import io.gravitee.repository.management.model.ApiKey;
import io.gravitee.rest.api.model.ApiModelEntity;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class NotificationParamsBuilder {
    private final Map<String, Object> params = new HashMap<String, Object>();
    public static final String PARAM_APPLICATION = "application";
    public static final String PARAM_API = "api";
    public static final String PARAM_OWNER = "owner";
    public static final String PARAM_API_KEY = "apiKey";
    public static final String PARAM_PLAN = "plan";
    public static final String PARAM_USER_URL = "userUrl";
    public static final String PARAM_USER = "user";
    public static final String PARAM_USERNAME = "username";
    public static final String PARAM_GROUP = "group";
    public static final String PARAM_SUBSCRIPTION_URL = "subscriptionsUrl";
    public static final String PARAM_SUBSCRIPTION = "subscription";
    public static final String PARAM_TOKEN = "token";
    public static final String PARAM_REGISTRATION_URL = "registrationUrl";
    public static final String PARAM_EXPIRATION_DATE = "expirationDate";
    public static final String REGISTRATION_PATH = "/#!/registration/confirm/";
    public static final String RESET_PASSWORD_PATH = "/#!/resetPassword/";
    public static final String DEFAULT_MANAGEMENT_URL = "http://localhost:3000";

    public Map<String, Object> build() {
        return this.params;
    }

    public NotificationParamsBuilder application(ApplicationEntity app) {
        this.params.put(PARAM_APPLICATION, app);
        return this;
    }

    public NotificationParamsBuilder plan(PlanEntity plan) {
        this.params.put(PARAM_PLAN, plan);
        return this;
    }

    public NotificationParamsBuilder api(ApiModelEntity api) {
        this.params.put(PARAM_API, api);
        return this;
    }

    public NotificationParamsBuilder api(ApiEntity api) {
        this.params.put(PARAM_API, api);
        return this;
    }

    public NotificationParamsBuilder owner(PrimaryOwnerEntity owner) {
        this.params.put(PARAM_OWNER, owner);
        return this;
    }

    public NotificationParamsBuilder apikey(ApiKey apikey) {
        this.params.put(PARAM_API_KEY, apikey.getKey());
        return this;
    }

    public NotificationParamsBuilder userUrl(String userUrl) {
        this.params.put(PARAM_USER_URL, userUrl);
        return this;
    }

    public NotificationParamsBuilder user(UserEntity user) {
        this.params.put(PARAM_USER, user);
        this.params.put(PARAM_USERNAME, user.getDisplayName());
        return this;
    }

    public NotificationParamsBuilder group(GroupEntity group) {
        this.params.put(PARAM_GROUP, group);
        return this;
    }

    public NotificationParamsBuilder subscriptionsUrl(String subscriptionsUrl) {
        this.params.put(PARAM_SUBSCRIPTION_URL, subscriptionsUrl);
        return this;
    }

    public NotificationParamsBuilder subscription(SubscriptionEntity subscription) {
        this.params.put(PARAM_SUBSCRIPTION, subscription);
        return this;
    }

    public NotificationParamsBuilder token(String token) {
        this.params.put(PARAM_TOKEN, token);
        return this;
    }

    public NotificationParamsBuilder registrationUrl(String registrationUrl) {
        this.params.put(PARAM_REGISTRATION_URL, registrationUrl);
        return this;
    }

    public NotificationParamsBuilder expirationDate(Date expirationDate) {
        this.params.put(PARAM_EXPIRATION_DATE, expirationDate);
        return this;
    }
}

