/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.management.api.search.UserCriteria;
import io.gravitee.repository.management.model.UserStatus;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PageType;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import io.gravitee.rest.api.model.documentation.PageQuery;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.Upgrader;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.search.SearchEngineService;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class SearchIndexUpgrader
implements Upgrader,
Ordered {
    @Autowired
    private ApiService apiService;
    @Autowired
    private PageService pageService;
    @Autowired
    private UserService userService;
    @Autowired
    private SearchEngineService searchEngineService;

    @Override
    public boolean upgrade() {
        Set<ApiEntity> apis = this.apiService.findAllLight(false);
        final ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2, new ThreadFactory(){
            private final AtomicLong counter = new AtomicLong(0L);

            @Override
            public Thread newThread(@NotNull Runnable r) {
                return new Thread(r, "gio.search-indexer-upgrader-" + this.counter.getAndIncrement());
            }
        });
        final ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        apis.stream().forEach(new Consumer<ApiEntity>(){

            @Override
            public void accept(ApiEntity apiEntity) {
                futures.add(CompletableFuture.runAsync(() -> {
                    SearchIndexUpgrader.this.searchEngineService.index((Indexable)apiEntity, true, false);
                    List<PageEntity> apiPages = SearchIndexUpgrader.this.pageService.search(new PageQuery.Builder().api(apiEntity.getId()).published(Boolean.valueOf(true)).build(), true);
                    apiPages.forEach(page -> {
                        try {
                            if (!(PageType.FOLDER.name().equals(page.getType()) || PageType.ROOT.name().equals(page.getType()) || PageType.SYSTEM_FOLDER.name().equals(page.getType()) || PageType.LINK.name().equals(page.getType()))) {
                                SearchIndexUpgrader.this.pageService.transformSwagger((PageEntity)page, apiEntity.getId());
                                SearchIndexUpgrader.this.searchEngineService.index((Indexable)page, true, false);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                }, executorService));
            }
        });
        futures.add(CompletableFuture.runAsync(() -> {
            Page<UserEntity> users = this.userService.search(new UserCriteria.Builder().statuses(new UserStatus[]{UserStatus.ACTIVE}).build(), (Pageable)new PageableImpl(1, Integer.MAX_VALUE));
            users.getContent().forEach(userEntity -> this.searchEngineService.index((Indexable)userEntity, true, false));
        }));
        CompletableFuture<Void> future = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        future.whenCompleteAsync((unused, throwable) -> {
            executorService.shutdown();
            this.searchEngineService.commit();
        }, (Executor)executorService);
        return true;
    }

    @Override
    public int getOrder() {
        return 250;
    }
}

