/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.filtering;

import io.gravitee.rest.api.model.RatingSummaryEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.SubscriptionStatus;
import io.gravitee.rest.api.model.TopApiEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.application.ApplicationListItem;
import io.gravitee.rest.api.model.filtering.FilterableItem;
import io.gravitee.rest.api.model.filtering.FilteredEntities;
import io.gravitee.rest.api.model.subscription.SubscriptionQuery;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.RatingService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.TopApiService;
import io.gravitee.rest.api.service.filtering.FilteringService;
import io.gravitee.rest.api.service.impl.AbstractService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FilteringServiceImpl
extends AbstractService
implements FilteringService {
    @Autowired
    SubscriptionService subscriptionService;
    @Autowired
    RatingService ratingService;
    @Autowired
    TopApiService topApiService;
    @Autowired
    ApplicationService applicationService;

    @Override
    public <T extends FilterableItem> FilteredEntities<T> getEntitiesOrderByNumberOfSubscriptions(Collection<T> items, Boolean excluded, boolean isAsc) {
        Function<SubscriptionEntity, String> getItemFunction;
        if (items == null || items.isEmpty()) {
            return new FilteredEntities(Collections.emptyList(), new HashMap());
        }
        if (items.toArray()[0] instanceof ApiEntity) {
            getItemFunction = sub -> sub.getApi();
        } else if (items.toArray()[0] instanceof ApplicationListItem) {
            getItemFunction = sub -> sub.getApplication();
        } else {
            throw new IllegalStateException("Only ApiEntity and ApplicationListItem are allowed");
        }
        SubscriptionQuery subscriptionQuery = new SubscriptionQuery();
        subscriptionQuery.setApis((Collection)items.stream().map(FilterableItem::getId).collect(Collectors.toList()));
        subscriptionQuery.setStatuses(Arrays.asList(SubscriptionStatus.ACCEPTED, SubscriptionStatus.PAUSED));
        Map<String, Long> subscribedItemsWithCount = this.subscriptionService.search(subscriptionQuery).stream().collect(Collectors.groupingBy(getItemFunction, Collectors.counting()));
        HashMap itemsWithCount = new HashMap();
        HashMap itemsMetadata = new HashMap();
        HashMap subscriptionsMetadata = new HashMap();
        itemsMetadata.put("subscriptions", subscriptionsMetadata);
        items.forEach(item -> {
            Long itemSubscriptionsCount = (Long)subscribedItemsWithCount.get(item.getId());
            if (excluded == null || !excluded.booleanValue() && itemSubscriptionsCount != null || excluded.booleanValue() && itemSubscriptionsCount == null) {
                itemsWithCount.put(item, itemSubscriptionsCount == null ? 0L : itemSubscriptionsCount);
                subscriptionsMetadata.put(item.getId(), itemSubscriptionsCount == null ? 0L : itemSubscriptionsCount);
            }
        });
        Comparator comparingByValue = Map.Entry.comparingByValue();
        if (!isAsc) {
            comparingByValue = comparingByValue.reversed();
        }
        return new FilteredEntities(itemsWithCount.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed().thenComparing(Map.Entry.comparingByKey(Comparator.comparing(FilterableItem::getName, String.CASE_INSENSITIVE_ORDER)))).map(Map.Entry::getKey).collect(Collectors.toList()), itemsMetadata);
    }

    @Override
    public FilteredEntities<ApiEntity> filterApis(Collection<ApiEntity> apis, FilteringService.FilterType filterType, FilteringService.FilterType excludedFilterType) {
        boolean excluded;
        FilteringService.FilterType filter = excludedFilterType == null ? filterType : excludedFilterType;
        boolean bl = excluded = excludedFilterType != null;
        if (filter != null) {
            switch (filter) {
                case MINE: {
                    if (this.isAuthenticated()) {
                        return this.getCurrentUserSubscribedApis(apis, excluded);
                    }
                    return new FilteredEntities(Collections.emptyList(), null);
                }
                case STARRED: {
                    if (this.ratingService.isEnabled()) {
                        return this.getRatedApis(apis, excluded);
                    }
                    return new FilteredEntities(Collections.emptyList(), null);
                }
                case TRENDINGS: {
                    return this.getEntitiesOrderByNumberOfSubscriptions(apis, excluded, false);
                }
                case FEATURED: {
                    return this.getTopApis(apis, excluded);
                }
            }
        }
        return new FilteredEntities(apis.stream().sorted((o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getName(), o2.getName())).collect(Collectors.toList()), null);
    }

    private FilteredEntities<ApiEntity> getTopApis(Collection<ApiEntity> apis, boolean excluded) {
        Map<String, Integer> topApiIdAndOrderMap = this.topApiService.findAll().stream().collect(Collectors.toMap(TopApiEntity::getApi, TopApiEntity::getOrder));
        if (topApiIdAndOrderMap.isEmpty()) {
            if (excluded) {
                return new FilteredEntities(apis.stream().sorted(Comparator.comparing(ApiEntity::getName)).collect(Collectors.toList()), null);
            }
            return new FilteredEntities(Collections.emptyList(), null);
        }
        if (excluded) {
            return new FilteredEntities(apis.stream().filter(api -> !topApiIdAndOrderMap.containsKey(api.getId())).sorted(Comparator.comparing(ApiEntity::getName)).collect(Collectors.toList()), null);
        }
        return new FilteredEntities(apis.stream().filter(api -> topApiIdAndOrderMap.containsKey(api.getId())).sorted(Comparator.comparing(o -> (Integer)topApiIdAndOrderMap.get(o.getId()))).collect(Collectors.toList()), null);
    }

    private FilteredEntities<ApiEntity> getRatedApis(Collection<ApiEntity> apis, boolean excluded) {
        HashMap ratings = new HashMap();
        apis.forEach(api -> {
            RatingSummaryEntity apiRatingSummary = this.ratingService.findSummaryByApi(api.getId());
            if (apiRatingSummary != null && apiRatingSummary.getNumberOfRatings() > 0) {
                ratings.put(api, apiRatingSummary);
            }
        });
        if (excluded) {
            return new FilteredEntities(apis.stream().filter(api -> !ratings.containsKey(api)).collect(Collectors.toList()), null);
        }
        return new FilteredEntities(ratings.entrySet().stream().sorted((e1, e2) -> {
            RatingSummaryEntity o1 = (RatingSummaryEntity)e1.getValue();
            RatingSummaryEntity o2 = (RatingSummaryEntity)e2.getValue();
            int averageRateComparaison = Double.compare(o2.getAverageRate(), o1.getAverageRate());
            if (averageRateComparaison != 0) {
                return averageRateComparaison;
            }
            int nbRatingsComparaison = Integer.compare(o2.getNumberOfRatings(), o1.getNumberOfRatings());
            if (nbRatingsComparaison != 0) {
                return nbRatingsComparaison;
            }
            return String.CASE_INSENSITIVE_ORDER.compare(((ApiEntity)e1.getKey()).getName(), ((ApiEntity)e2.getKey()).getName());
        }).map(Map.Entry::getKey).collect(Collectors.toList()), null);
    }

    private FilteredEntities<ApiEntity> getCurrentUserSubscribedApis(Collection<ApiEntity> apis, boolean excluded) {
        List currentUserApplicationsId = this.applicationService.findByUser(this.getAuthenticatedUser().getUsername()).stream().map(ApplicationListItem::getId).collect(Collectors.toList());
        SubscriptionQuery subscriptionQuery = new SubscriptionQuery();
        subscriptionQuery.setApplications(currentUserApplicationsId);
        List subscribedApis = this.subscriptionService.search(subscriptionQuery).stream().map(SubscriptionEntity::getApi).distinct().collect(Collectors.toList());
        return new FilteredEntities(apis.stream().filter(api -> !excluded && subscribedApis.contains(api.getId()) || excluded && !subscribedApis.contains(api.getId())).sorted((a1, a2) -> String.CASE_INSENSITIVE_ORDER.compare(a1.getName(), a2.getName())).collect(Collectors.toList()), null);
    }
}

