/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import io.gravitee.fetcher.api.Fetcher;
import io.gravitee.fetcher.api.FetcherConfiguration;
import io.gravitee.fetcher.api.FetcherException;
import io.gravitee.fetcher.api.FilepathAwareFetcherConfiguration;
import io.gravitee.fetcher.api.FilesFetcher;
import io.gravitee.fetcher.api.Resource;
import io.gravitee.fetcher.api.Sensitive;
import io.gravitee.plugin.core.api.PluginManager;
import io.gravitee.plugin.fetcher.FetcherPlugin;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.PageRepository;
import io.gravitee.repository.management.api.search.PageCriteria;
import io.gravitee.repository.management.api.search.Pageable;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Page;
import io.gravitee.repository.management.model.PageMedia;
import io.gravitee.repository.management.model.PageReferenceType;
import io.gravitee.repository.management.model.PageSource;
import io.gravitee.rest.api.fetcher.FetcherConfigurationFactory;
import io.gravitee.rest.api.model.ApiModelEntity;
import io.gravitee.rest.api.model.ApiPageEntity;
import io.gravitee.rest.api.model.CategoryEntity;
import io.gravitee.rest.api.model.ImportPageEntity;
import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.MetadataEntity;
import io.gravitee.rest.api.model.NewPageEntity;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PageMediaEntity;
import io.gravitee.rest.api.model.PageRevisionEntity;
import io.gravitee.rest.api.model.PageSourceEntity;
import io.gravitee.rest.api.model.PageType;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.PlanStatus;
import io.gravitee.rest.api.model.SystemFolderType;
import io.gravitee.rest.api.model.UpdatePageEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.descriptor.GraviteeDescriptorEntity;
import io.gravitee.rest.api.model.descriptor.GraviteeDescriptorPageEntity;
import io.gravitee.rest.api.model.documentation.PageQuery;
import io.gravitee.rest.api.model.permissions.ApiPermission;
import io.gravitee.rest.api.model.permissions.Permission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.CategoryService;
import io.gravitee.rest.api.service.GraviteeDescriptorService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.MetadataService;
import io.gravitee.rest.api.service.PageRevisionService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.SwaggerService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.common.RandomString;
import io.gravitee.rest.api.service.exceptions.InvalidDataException;
import io.gravitee.rest.api.service.exceptions.NoFetcherDefinedException;
import io.gravitee.rest.api.service.exceptions.PageActionException;
import io.gravitee.rest.api.service.exceptions.PageContentUnsafeException;
import io.gravitee.rest.api.service.exceptions.PageFolderActionException;
import io.gravitee.rest.api.service.exceptions.PageNotFoundException;
import io.gravitee.rest.api.service.exceptions.PageUsedAsGeneralConditionsException;
import io.gravitee.rest.api.service.exceptions.PageUsedByCategoryException;
import io.gravitee.rest.api.service.exceptions.SwaggerDescriptorException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.exceptions.TemplateProcessingException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import io.gravitee.rest.api.service.impl.swagger.parser.OAIParser;
import io.gravitee.rest.api.service.impl.swagger.transformer.entrypoints.EntrypointsOAITransformer;
import io.gravitee.rest.api.service.impl.swagger.transformer.page.PageConfigurationOAITransformer;
import io.gravitee.rest.api.service.notification.NotificationTemplateService;
import io.gravitee.rest.api.service.sanitizer.HtmlSanitizer;
import io.gravitee.rest.api.service.sanitizer.UrlSanitizerUtils;
import io.gravitee.rest.api.service.search.SearchEngineService;
import io.gravitee.rest.api.service.spring.ImportConfiguration;
import io.gravitee.rest.api.service.swagger.OAIDescriptor;
import io.gravitee.rest.api.service.swagger.SwaggerDescriptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.support.CronSequenceGenerator;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class PageServiceImpl
extends TransactionalService
implements PageService,
ApplicationContextAware {
    public static final String SYSTEM_CONTRIBUTOR = "system";
    private static final Gson gson = new Gson();
    private static final Logger logger = LoggerFactory.getLogger(PageServiceImpl.class);
    private static final String SENSITIVE_DATA_REPLACEMENT = "********";
    @Value(value="${documentation.markdown.sanitize:false}")
    private boolean markdownSanitize;
    @Autowired
    private PageRepository pageRepository;
    @Autowired
    private ApiService apiService;
    @Autowired
    private SwaggerService swaggerService;
    @Autowired
    private PluginManager<FetcherPlugin> fetcherPluginManager;
    @Autowired
    private FetcherConfigurationFactory fetcherConfigurationFactory;
    @Autowired
    private NotificationTemplateService notificationTemplateService;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private MembershipService membershipService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private AuditService auditService;
    @Autowired
    private SearchEngineService searchEngineService;
    @Autowired
    private MetadataService metadataService;
    @Autowired
    private PageRevisionService pageRevisionService;
    @Autowired
    private GraviteeDescriptorService graviteeDescriptorService;
    @Autowired
    private CategoryService categoryService;
    @Autowired
    private ImportConfiguration importConfiguration;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private PlanService planService;

    private static Page convert(NewPageEntity newPageEntity) {
        Page page = new Page();
        page.setName(newPageEntity.getName());
        PageType type = newPageEntity.getType();
        if (type != null) {
            page.setType(type.name());
        }
        page.setContent(newPageEntity.getContent());
        page.setLastContributor(newPageEntity.getLastContributor());
        page.setOrder(newPageEntity.getOrder());
        page.setPublished(newPageEntity.isPublished());
        page.setHomepage(newPageEntity.isHomepage());
        page.setSource(PageServiceImpl.convert(newPageEntity.getSource()));
        page.setConfiguration(newPageEntity.getConfiguration());
        page.setExcludedGroups(newPageEntity.getExcludedGroups());
        page.setParentId("".equals(newPageEntity.getParentId()) ? null : newPageEntity.getParentId());
        return page;
    }

    private static Page convert(ImportPageEntity importPageEntity) {
        Page page = new Page();
        PageType type = importPageEntity.getType();
        if (type != null) {
            page.setType(type.name());
        }
        page.setLastContributor(importPageEntity.getLastContributor());
        page.setPublished(importPageEntity.isPublished());
        page.setSource(PageServiceImpl.convert(importPageEntity.getSource()));
        page.setConfiguration(importPageEntity.getConfiguration());
        page.setExcludedGroups(importPageEntity.getExcludedGroups());
        return page;
    }

    private static Page merge(UpdatePageEntity updatePageEntity, Page withUpdatePage) {
        Page page = new Page();
        page.setName(updatePageEntity.getName() != null ? updatePageEntity.getName() : withUpdatePage.getName());
        page.setContent(updatePageEntity.getContent() != null ? updatePageEntity.getContent() : withUpdatePage.getContent());
        page.setLastContributor(updatePageEntity.getLastContributor() != null ? updatePageEntity.getLastContributor() : withUpdatePage.getLastContributor());
        page.setOrder(updatePageEntity.getOrder() != null ? updatePageEntity.getOrder().intValue() : withUpdatePage.getOrder());
        page.setPublished(updatePageEntity.isPublished() != null ? updatePageEntity.isPublished().booleanValue() : withUpdatePage.isPublished());
        PageSource pageSource = PageServiceImpl.convert(updatePageEntity.getSource());
        page.setSource(pageSource != null ? pageSource : withUpdatePage.getSource());
        page.setConfiguration(updatePageEntity.getConfiguration() != null ? updatePageEntity.getConfiguration() : withUpdatePage.getConfiguration());
        page.setHomepage(updatePageEntity.isHomepage() != null ? updatePageEntity.isHomepage().booleanValue() : withUpdatePage.isHomepage());
        page.setExcludedGroups(updatePageEntity.getExcludedGroups() != null ? updatePageEntity.getExcludedGroups() : withUpdatePage.getExcludedGroups());
        List pageMediaList = PageServiceImpl.convertMediaEntity(updatePageEntity.getAttachedMedia());
        page.setAttachedMedia(pageMediaList != null ? pageMediaList : withUpdatePage.getAttachedMedia());
        page.setParentId((String)(updatePageEntity.getParentId() != null ? (updatePageEntity.getParentId().isEmpty() ? null : updatePageEntity.getParentId()) : withUpdatePage.getParentId()));
        return page;
    }

    private static Page convert(UpdatePageEntity updatePageEntity) {
        Page page = new Page();
        page.setName(updatePageEntity.getName());
        page.setContent(updatePageEntity.getContent());
        page.setLastContributor(updatePageEntity.getLastContributor());
        page.setOrder(updatePageEntity.getOrder().intValue());
        page.setPublished(Boolean.TRUE.equals(updatePageEntity.isPublished()));
        page.setSource(PageServiceImpl.convert(updatePageEntity.getSource()));
        page.setConfiguration(updatePageEntity.getConfiguration());
        page.setHomepage(Boolean.TRUE.equals(updatePageEntity.isHomepage()));
        page.setExcludedGroups(updatePageEntity.getExcludedGroups());
        page.setAttachedMedia(PageServiceImpl.convertMediaEntity(updatePageEntity.getAttachedMedia()));
        page.setParentId("".equals(updatePageEntity.getParentId()) ? null : updatePageEntity.getParentId());
        return page;
    }

    private static PageSource convert(PageSourceEntity pageSourceEntity) {
        PageSource source = null;
        if (pageSourceEntity != null && pageSourceEntity.getType() != null && pageSourceEntity.getConfiguration() != null) {
            source = new PageSource();
            source.setType(pageSourceEntity.getType());
            source.setConfiguration(pageSourceEntity.getConfiguration());
        }
        return source;
    }

    private static boolean isJson(String content) {
        try {
            gson.fromJson(content, Object.class);
            return true;
        }
        catch (JsonSyntaxException ex) {
            return false;
        }
    }

    private static List<PageMediaEntity> convertMedia(List<PageMedia> pages) {
        if (pages == null) {
            return Collections.emptyList();
        }
        return pages.stream().map(PageServiceImpl::convertMedia).collect(Collectors.toList());
    }

    private static PageMediaEntity convertMedia(PageMedia pm) {
        PageMediaEntity pageMediaEntity = new PageMediaEntity();
        pageMediaEntity.setMediaHash(pm.getMediaHash());
        pageMediaEntity.setMediaName(pm.getMediaName());
        pageMediaEntity.setAttachedAt(pm.getAttachedAt());
        return pageMediaEntity;
    }

    private static List<PageMedia> convertMediaEntity(List<PageMediaEntity> pages) {
        if (pages == null) {
            return Collections.emptyList();
        }
        return pages.stream().map(PageServiceImpl::convertMediaEntity).collect(Collectors.toList());
    }

    private static PageMedia convertMediaEntity(PageMediaEntity pme) {
        PageMedia pageMedia = new PageMedia();
        pageMedia.setMediaHash(pme.getMediaHash());
        pageMedia.setMediaName(pme.getMediaName());
        pageMedia.setAttachedAt(pme.getAttachedAt());
        return pageMedia;
    }

    private PageSituation getPageSituation(String pageId) throws TechnicalException {
        if (pageId == null) {
            return PageSituation.ROOT;
        }
        Optional optionalPage = this.pageRepository.findById(pageId);
        if (optionalPage.isPresent()) {
            Page page = (Page)optionalPage.get();
            if (PageType.SYSTEM_FOLDER.name().equalsIgnoreCase(page.getType())) {
                return PageSituation.SYSTEM_FOLDER;
            }
            if (PageType.TRANSLATION.name().equalsIgnoreCase(page.getType())) {
                return PageSituation.TRANSLATION;
            }
            String parentId = page.getParentId();
            if (parentId == null) {
                return PageSituation.IN_ROOT;
            }
            Optional optionalParent = this.pageRepository.findById(parentId);
            if (optionalParent.isPresent()) {
                Page parentPage = (Page)optionalParent.get();
                if (PageType.SYSTEM_FOLDER.name().equalsIgnoreCase(parentPage.getType())) {
                    return PageSituation.IN_SYSTEM_FOLDER;
                }
                if (PageType.FOLDER.name().equalsIgnoreCase(parentPage.getType())) {
                    String grandParentId = parentPage.getParentId();
                    if (grandParentId == null) {
                        return PageSituation.IN_FOLDER_IN_ROOT;
                    }
                    Optional optionalGrandParent = this.pageRepository.findById(grandParentId);
                    if (optionalGrandParent.isPresent()) {
                        Page grandParentPage = (Page)optionalGrandParent.get();
                        if (PageType.SYSTEM_FOLDER.name().equalsIgnoreCase(grandParentPage.getType())) {
                            return PageSituation.IN_FOLDER_IN_SYSTEM_FOLDER;
                        }
                        if (PageType.FOLDER.name().equalsIgnoreCase(grandParentPage.getType())) {
                            return PageSituation.IN_FOLDER_IN_FOLDER;
                        }
                    }
                }
            }
        }
        logger.debug("Impossible to determine page situation for the page " + pageId);
        return null;
    }

    @Override
    public boolean isPageUsedAsGeneralConditions(PageEntity page, String apiId) {
        boolean result = false;
        if (PageType.MARKDOWN.name().equals(page.getType())) {
            Optional<PlanEntity> optPlan = this.planService.findByApi(apiId).stream().filter(p -> p.getGeneralConditions() != null).filter(p -> !PlanStatus.CLOSED.equals((Object)p.getStatus()) && !PlanStatus.STAGING.equals((Object)p.getStatus())).filter(p -> page.getId().equals(p.getGeneralConditions())).findFirst();
            result = optPlan.isPresent();
        }
        return result;
    }

    @Override
    public io.gravitee.common.data.domain.Page<PageEntity> findAll(io.gravitee.rest.api.model.common.Pageable pageable) {
        Objects.requireNonNull(pageable, "FindAll requires a pageable parameter");
        logger.debug("Find all pages with pageNumber {} and pageSize {}", (Object)pageable.getPageNumber(), (Object)pageable.getPageSize());
        try {
            Pageable repoPageable = new PageableBuilder().pageSize(pageable.getPageSize()).pageNumber(pageable.getPageNumber()).build();
            io.gravitee.common.data.domain.Page pages = this.pageRepository.findAll(repoPageable);
            List entities = pages.getContent().stream().map(this::convert).collect(Collectors.toList());
            logger.debug("{} pages found", (Object)pages.getPageElements());
            return new io.gravitee.common.data.domain.Page(entities, pages.getPageNumber(), entities.size(), pages.getTotalElements());
        }
        catch (TechnicalException ex) {
            logger.error("An error occurs while trying to fetch pages", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to fetch pages", ex);
        }
    }

    @Override
    public PageEntity findById(String pageId) {
        return this.findById(pageId, null);
    }

    @Override
    public PageEntity findById(String pageId, String acceptedLocale) {
        try {
            logger.debug("Find page by ID: {}", (Object)pageId);
            Optional page = this.pageRepository.findById(pageId);
            if (page.isPresent()) {
                String contentPageId = pageId;
                PageEntity foundPageEntity = this.convert((Page)page.get());
                if (acceptedLocale != null && !acceptedLocale.isEmpty()) {
                    Page translation = this.getTranslation(foundPageEntity, acceptedLocale);
                    if (translation != null) {
                        String inheritContent;
                        String translationName = translation.getName();
                        if (translationName != null && !translationName.isEmpty()) {
                            foundPageEntity.setName(translationName);
                        }
                        if ((inheritContent = (String)translation.getConfiguration().get("inheritContent")) != null && "false".equals(inheritContent)) {
                            foundPageEntity.setContent(translation.getContent());
                        }
                        contentPageId = translation.getId();
                    }
                } else {
                    List<PageEntity> translations = this.convert(this.getTranslations(foundPageEntity.getId()));
                    if (translations != null && !translations.isEmpty()) {
                        foundPageEntity.setTranslations(translations);
                    }
                }
                this.fillContentRevisionId(foundPageEntity, contentPageId);
                return foundPageEntity;
            }
            throw new PageNotFoundException(pageId);
        }
        catch (TechnicalException ex) {
            logger.error("An error occurs while trying to find a page using its ID {}", (Object)pageId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find a page using its ID " + pageId, ex);
        }
    }

    private void fillContentRevisionId(PageEntity foundPageEntity, String pageId) {
        if (foundPageEntity.getType() != null && this.shouldHaveRevision(foundPageEntity.getType())) {
            Optional<PageRevisionEntity> revision = this.pageRevisionService.findLastByPageId(pageId);
            if (revision.isPresent()) {
                foundPageEntity.setContentRevisionId(new PageEntity.PageRevisionId(revision.get().getPageId(), revision.get().getRevision()));
            } else {
                logger.info("Revision is missing for the page {}", (Object)pageId);
            }
        }
    }

    @Override
    public void transformSwagger(PageEntity pageEntity) {
        String apiId = null;
        if (pageEntity instanceof ApiPageEntity) {
            apiId = ((ApiPageEntity)pageEntity).getApi();
        }
        this.transformSwagger(pageEntity, apiId);
    }

    @Override
    public void transformSwagger(PageEntity pageEntity, String apiId) {
        if (apiId != null) {
            this.transformWithTemplate(pageEntity, apiId);
        }
        if (this.markdownSanitize && PageType.MARKDOWN.name().equalsIgnoreCase(pageEntity.getType())) {
            HtmlSanitizer.SanitizeInfos safe = HtmlSanitizer.isSafe(pageEntity.getContent());
            if (!safe.isSafe()) {
                pageEntity.setContent(HtmlSanitizer.sanitize(pageEntity.getContent()));
            }
        } else if (PageType.SWAGGER.name().equalsIgnoreCase(pageEntity.getType())) {
            SwaggerDescriptor descriptor;
            try {
                descriptor = this.swaggerService.parse(pageEntity.getContent());
            }
            catch (SwaggerDescriptorException sde) {
                if (apiId != null) {
                    logger.error("Parsing error for API id[{}]: {}", (Object)apiId, (Object)sde.getMessage());
                }
                throw sde;
            }
            ArrayList transformers = new ArrayList();
            transformers.add(new PageConfigurationOAITransformer(pageEntity));
            if (apiId != null) {
                ApiEntity api = this.apiService.findById(apiId);
                transformers.add(new EntrypointsOAITransformer(pageEntity, api));
            }
            this.swaggerService.transform((OAIDescriptor)descriptor, transformers);
            if (pageEntity.getContentType().equalsIgnoreCase("application/json")) {
                try {
                    pageEntity.setContent(descriptor.toJson());
                }
                catch (JsonProcessingException e) {
                    logger.error("Unexpected error", (Throwable)e);
                }
            } else {
                try {
                    pageEntity.setContent(descriptor.toYaml());
                }
                catch (JsonProcessingException e) {
                    logger.error("Unexpected error", (Throwable)e);
                }
            }
        }
    }

    @Override
    public List<PageEntity> search(PageQuery query) {
        return this.search(query, null, false, true);
    }

    @Override
    public List<PageEntity> search(PageQuery query, boolean withTranslations) {
        return this.search(query, null, withTranslations, true);
    }

    @Override
    public List<PageEntity> search(PageQuery query, String acceptedLocale) {
        return this.search(query, acceptedLocale, false, true);
    }

    private List<PageEntity> search(PageQuery query, String acceptedLocale, boolean withTranslations, boolean withLinks) {
        try {
            Stream<Object> pagesStream = this.pageRepository.search(this.queryToCriteria(query)).stream();
            if (!withTranslations) {
                pagesStream = pagesStream.filter(page -> !PageType.TRANSLATION.name().equals(page.getType()));
            }
            if (!withLinks) {
                pagesStream = pagesStream.filter(page -> !PageType.LINK.name().equals(page.getType()));
            }
            List<PageEntity> pages = pagesStream.map(this::convert).collect(Collectors.toList());
            if (acceptedLocale == null || acceptedLocale.isEmpty()) {
                pages.forEach(p -> {
                    List<PageEntity> translations;
                    if (!PageType.TRANSLATION.name().equals(p.getType()) && (translations = this.convert(this.getTranslations(p.getId()))) != null && !translations.isEmpty()) {
                        p.setTranslations(translations);
                    }
                });
            } else {
                pages.forEach(p -> {
                    Page translation;
                    if (!PageType.TRANSLATION.name().equals(p.getType()) && (translation = this.getTranslation((PageEntity)p, acceptedLocale)) != null) {
                        String inheritContent;
                        String translationName = translation.getName();
                        if (translationName != null && !translationName.isEmpty()) {
                            p.setName(translationName);
                        }
                        if ((inheritContent = (String)translation.getConfiguration().get("inheritContent")) != null && "false".equals(inheritContent)) {
                            p.setContent(translation.getContent());
                        }
                    }
                });
            }
            if (query != null && query.getPublished() != null && query.getPublished().booleanValue()) {
                return pages.stream().filter(page -> {
                    if (page.getParentId() != null) {
                        return this.findById(page.getParentId()).isPublished();
                    }
                    return true;
                }).collect(Collectors.toList());
            }
            return pages;
        }
        catch (TechnicalException ex) {
            logger.error("An error occurs while trying to search pages", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to search pages", ex);
        }
    }

    private Page getTranslation(PageEntity pageToTranslate, String acceptedLocale) {
        if (PageType.LINK.name().equals(pageToTranslate.getType()) && pageToTranslate.getConfiguration() != null && "true".equals(pageToTranslate.getConfiguration().get("inherit"))) {
            Page relatedTranslation = this.getTranslation(pageToTranslate.getContent(), acceptedLocale);
            Page linkTranslation = null;
            if (relatedTranslation != null) {
                linkTranslation = new Page();
                linkTranslation.setName(relatedTranslation.getName());
                linkTranslation.setContent(relatedTranslation.getContent());
                linkTranslation.setConfiguration(Collections.emptyMap());
            }
            return linkTranslation;
        }
        return this.getTranslation(pageToTranslate.getId(), acceptedLocale);
    }

    private Page getTranslation(String pageId, String acceptedLocale) {
        try {
            Optional<Page> optTranslation = this.pageRepository.search(new PageCriteria.Builder().parent(pageId).type(PageType.TRANSLATION.name()).build()).stream().filter(t -> acceptedLocale.equalsIgnoreCase((String)t.getConfiguration().get("lang"))).findFirst();
            if (optTranslation.isPresent()) {
                return optTranslation.get();
            }
            return null;
        }
        catch (TechnicalException ex) {
            logger.error("An error occurs while trying to search pages", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to search pages", ex);
        }
    }

    @Override
    public void transformWithTemplate(PageEntity pageEntity, String api) {
        if (pageEntity.getContent() != null) {
            HashMap model = new HashMap();
            if (api == null) {
                List<MetadataEntity> metadataList = this.metadataService.findAllDefault();
                if (metadataList != null) {
                    HashMap mapMetadata = new HashMap(metadataList.size());
                    metadataList.forEach(metadata -> mapMetadata.put(metadata.getKey(), metadata.getValue()));
                    model.put("metadata", mapMetadata);
                }
            } else {
                ApiModelEntity apiEntity = this.apiService.findByIdForTemplates(api, true);
                model.put("api", apiEntity);
            }
            try {
                String content = this.notificationTemplateService.resolveInlineTemplateWithParam(pageEntity.getId(), pageEntity.getContent(), model, false);
                pageEntity.setContent(content);
            }
            catch (TemplateProcessingException e) {
                if (pageEntity.getMessages() == null) {
                    pageEntity.setMessages(new ArrayList());
                }
                pageEntity.getMessages().add("Invalid expression or value is missing for " + e.getBlamedExpressionString());
            }
        }
    }

    @Override
    public PageEntity createPage(String apiId, NewPageEntity newPageEntity) {
        return this.createPage(apiId, newPageEntity, GraviteeContext.getCurrentEnvironment());
    }

    private PageEntity createPage(String apiId, NewPageEntity newPageEntity, String environmentId) {
        return this.createPage(apiId, newPageEntity, environmentId, null);
    }

    private PageEntity createPage(String apiId, NewPageEntity newPageEntity, String environmentId, String pageId) {
        try {
            Page page;
            logger.debug("Create page {} for API {}", (Object)newPageEntity, (Object)apiId);
            String id = pageId != null && UUID.fromString(pageId) != null ? pageId : RandomString.generate();
            PageType newPageType = newPageEntity.getType();
            boolean createRevision = false;
            if (PageType.TRANSLATION.equals((Object)newPageType)) {
                this.checkTranslationConsistency(newPageEntity.getParentId(), newPageEntity.getConfiguration(), true);
                Optional optTranslatedPage = this.pageRepository.findById(newPageEntity.getParentId());
                if (optTranslatedPage.isPresent()) {
                    newPageEntity.setPublished(((Page)optTranslatedPage.get()).isPublished());
                    createRevision = this.isSwaggerOrMarkdown(((Page)optTranslatedPage.get()).getType());
                }
            }
            if (PageType.FOLDER.equals((Object)newPageType)) {
                this.checkFolderConsistency(newPageEntity);
            }
            if (PageType.LINK.equals((Object)newPageType)) {
                String resourceType = (String)newPageEntity.getConfiguration().get("resourceType");
                String content = newPageEntity.getContent();
                if (content == null || content.isEmpty()) {
                    throw new PageActionException(PageType.LINK, "be created. It must have a URL, a page Id or a category Id");
                }
                if ("root".equals(content) || "external".equals(resourceType) || "category".equals(resourceType)) {
                    newPageEntity.setPublished(true);
                } else {
                    Optional optionalRelatedPage = this.pageRepository.findById(content);
                    if (optionalRelatedPage.isPresent()) {
                        Page relatedPage = (Page)optionalRelatedPage.get();
                        this.checkLinkRelatedPageType(relatedPage);
                        newPageEntity.setPublished(relatedPage.isPublished());
                    }
                }
            }
            if (PageType.SWAGGER == newPageType || PageType.MARKDOWN == newPageType) {
                this.checkMarkdownOrSwaggerConsistency(newPageEntity, newPageType);
                createRevision = true;
            }
            if ((page = PageServiceImpl.convert(newPageEntity)).getSource() != null) {
                this.fetchPage(page);
            }
            page.setId(id);
            if (StringUtils.isEmpty((CharSequence)apiId)) {
                page.setReferenceId(environmentId);
                page.setReferenceType(PageReferenceType.ENVIRONMENT);
            } else {
                page.setReferenceId(apiId);
                page.setReferenceType(PageReferenceType.API);
            }
            page.setCreatedAt(new Date());
            page.setUpdatedAt(page.getCreatedAt());
            List<String> messages = this.validateSafeContent(page);
            Page createdPage = this.pageRepository.create(page);
            if (createRevision) {
                this.createPageRevision(createdPage);
            }
            this.onlyOneHomepage(page);
            this.createAuditLog(PageReferenceType.API.equals((Object)page.getReferenceType()) ? page.getReferenceId() : null, (Audit.AuditEvent)Page.AuditEvent.PAGE_CREATED, page.getCreatedAt(), null, page);
            PageEntity pageEntity = this.convert(createdPage);
            if (messages != null && messages.size() > 0) {
                pageEntity.setMessages(messages);
            }
            this.index(pageEntity);
            return pageEntity;
        }
        catch (FetcherException | TechnicalException ex) {
            logger.error("An error occurs while trying to create {}", (Object)newPageEntity, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying create " + newPageEntity, ex);
        }
    }

    private void createPageRevision(Page page) {
        try {
            if (PageType.valueOf((String)page.getType()) == PageType.TRANSLATION && page.getConfiguration() != null && !page.getConfiguration().isEmpty() && ((String)page.getConfiguration().get("inheritContent")).equalsIgnoreCase("true")) {
                String translatedPageId = page.getParentId();
                this.pageRepository.findById(translatedPageId).ifPresent(translatedPage -> page.setContent(translatedPage.getContent()));
            }
            this.pageRevisionService.create(page);
        }
        catch (TechnicalException ex) {
            logger.error("An error occurs while trying to create a revision for {}", (Object)page, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying create a revision for " + page, ex);
        }
    }

    private void checkMarkdownOrSwaggerConsistency(NewPageEntity newPageEntity, PageType newPageType) throws TechnicalException {
        PageSituation newPageParentSituation = this.getPageSituation(newPageEntity.getParentId());
        if (newPageParentSituation == PageSituation.SYSTEM_FOLDER || newPageParentSituation == PageSituation.IN_SYSTEM_FOLDER) {
            throw new PageActionException(newPageType, "be created under a system folder");
        }
    }

    private void checkFolderConsistency(NewPageEntity newPageEntity) throws TechnicalException {
        if (newPageEntity.getContent() != null && newPageEntity.getContent().length() > 0) {
            throw new PageFolderActionException("have a content");
        }
        if (newPageEntity.isHomepage()) {
            throw new PageFolderActionException("be affected to the home page");
        }
        PageSituation newPageParentSituation = this.getPageSituation(newPageEntity.getParentId());
        if (newPageParentSituation == PageSituation.IN_SYSTEM_FOLDER) {
            throw new PageFolderActionException("be created in a folder of a system folder");
        }
    }

    private void checkTranslationConsistency(String parentId, Map<String, String> configuration, boolean forCreation) throws TechnicalException {
        if (parentId == null || parentId.isEmpty()) {
            throw new PageActionException(PageType.TRANSLATION, "have no parentId");
        }
        if (configuration == null || configuration.get("lang") == null || configuration.get("lang").isEmpty()) {
            throw new PageActionException(PageType.TRANSLATION, "have no configured language");
        }
        Optional optTranslatedPage = this.pageRepository.findById(parentId);
        if (optTranslatedPage.isPresent()) {
            String newTranslationLang;
            Page existingTranslation;
            Page translatedPage = (Page)optTranslatedPage.get();
            PageType translatedPageType = PageType.valueOf((String)translatedPage.getType());
            if (PageType.ROOT == translatedPageType || PageType.SYSTEM_FOLDER == translatedPageType || PageType.TRANSLATION == translatedPageType) {
                throw new PageActionException(PageType.TRANSLATION, "have a parent with type " + translatedPageType.name() + ". Parent " + parentId + " is not one of this type : FOLDER, LINK, MARKDOWN, SWAGGER");
            }
            if (forCreation && (existingTranslation = this.getTranslation(parentId, newTranslationLang = configuration.get("lang"))) != null) {
                throw new PageActionException(PageType.TRANSLATION, "be created. A translation for this language already exist");
            }
        }
    }

    private void checkLinkRelatedPageType(Page relatedPage) throws TechnicalException {
        PageSituation relatedPageSituation = this.getPageSituation(relatedPage.getId());
        if (PageType.LINK.name().equalsIgnoreCase(relatedPage.getType()) || PageType.SYSTEM_FOLDER.name().equalsIgnoreCase(relatedPage.getType()) || PageType.FOLDER.name().equalsIgnoreCase(relatedPage.getType()) && relatedPageSituation == PageSituation.IN_SYSTEM_FOLDER) {
            throw new PageActionException(PageType.LINK, "be related to a Link, a System folder or a folder in a System folder");
        }
    }

    @Override
    public PageEntity createPage(NewPageEntity newPageEntity) {
        return this.createPage(null, newPageEntity);
    }

    @Override
    public PageEntity create(String apiId, PageEntity pageEntity) {
        NewPageEntity newPageEntity = this.convert(pageEntity);
        newPageEntity.setLastContributor(null);
        return this.createPage(apiId, newPageEntity);
    }

    private void onlyOneHomepage(Page page) throws TechnicalException {
        if (page.isHomepage()) {
            List pages = this.pageRepository.search(new PageCriteria.Builder().referenceId(page.getReferenceId()).referenceType(page.getReferenceType().name()).homepage(Boolean.valueOf(true)).build());
            pages.stream().filter(i -> !i.getId().equals(page.getId())).forEach(i -> {
                try {
                    i.setHomepage(false);
                    this.pageRepository.update(i);
                }
                catch (TechnicalException e) {
                    logger.error("An error occurs while trying update homepage attribute from {}", (Object)page, (Object)e);
                }
            });
        }
    }

    @Override
    public PageEntity update(String pageId, UpdatePageEntity updatePageEntity) {
        return this.update(pageId, updatePageEntity, false);
    }

    @Override
    public PageEntity update(String pageId, UpdatePageEntity updatePageEntity, boolean partial) {
        try {
            List<CategoryEntity> categoriesUsingPage;
            Optional<PlanEntity> activePlan;
            logger.debug("Update Page {}", (Object)pageId);
            Optional optPageToUpdate = this.pageRepository.findById(pageId);
            if (!optPageToUpdate.isPresent()) {
                throw new PageNotFoundException(pageId);
            }
            Page pageToUpdate = (Page)optPageToUpdate.get();
            Page page = null;
            String pageType = pageToUpdate.getType();
            boolean createRevision = false;
            if (PageType.LINK.name().equalsIgnoreCase(pageType)) {
                String newResourceRef = updatePageEntity.getContent();
                String actualResourceRef = pageToUpdate.getContent();
                if (newResourceRef != null && !newResourceRef.equals(actualResourceRef)) {
                    String resourceType;
                    String string = resourceType = updatePageEntity.getConfiguration() != null ? (String)updatePageEntity.getConfiguration().get("resourceType") : (String)pageToUpdate.getConfiguration().get("resourceType");
                    if ("external".equals(resourceType) && updatePageEntity.getContent() != null && updatePageEntity.getContent().isEmpty()) {
                        throw new PageActionException(PageType.LINK, "be created. An external Link must have a URL");
                    }
                    if ("root".equals(newResourceRef) || "external".equals(resourceType) || "category".equals(resourceType)) {
                        updatePageEntity.setPublished(Boolean.valueOf(true));
                    } else {
                        Optional optionalRelatedPage = this.pageRepository.findById(newResourceRef);
                        if (optionalRelatedPage.isPresent()) {
                            Page relatedPage = (Page)optionalRelatedPage.get();
                            this.checkLinkRelatedPageType(relatedPage);
                            updatePageEntity.setPublished(Boolean.valueOf(relatedPage.isPublished()));
                        }
                    }
                } else if (newResourceRef != null && newResourceRef.equals(actualResourceRef)) {
                    updatePageEntity.setPublished(Boolean.valueOf(pageToUpdate.isPublished()));
                }
            }
            if (PageType.TRANSLATION.name().equalsIgnoreCase(pageType)) {
                String parentId = updatePageEntity.getParentId() != null && !updatePageEntity.getParentId().isEmpty() ? updatePageEntity.getParentId() : pageToUpdate.getParentId();
                Map configuration = updatePageEntity.getConfiguration() != null ? updatePageEntity.getConfiguration() : pageToUpdate.getConfiguration();
                this.checkTranslationConsistency(parentId, configuration, false);
                boolean hasChanged = this.pageHasChanged(updatePageEntity, pageToUpdate);
                Optional optParentPage = this.pageRepository.findById(parentId);
                if (optParentPage.isPresent()) {
                    boolean bl = createRevision = this.isSwaggerOrMarkdown(((Page)optParentPage.get()).getType()) && hasChanged;
                }
            }
            if (updatePageEntity.getParentId() != null && !updatePageEntity.getParentId().equals(pageToUpdate.getParentId())) {
                Optional optionalTranslatedPage;
                this.checkUpdatedPageSituation(updatePageEntity, pageType, pageId);
                if (PageType.TRANSLATION.name().equalsIgnoreCase(pageType) && (optionalTranslatedPage = this.pageRepository.findById(updatePageEntity.getParentId())).isPresent()) {
                    updatePageEntity.setPublished(Boolean.valueOf(((Page)optionalTranslatedPage.get()).isPublished()));
                }
            }
            if ((page = partial ? PageServiceImpl.merge(updatePageEntity, pageToUpdate) : PageServiceImpl.convert(updatePageEntity)).getSource() != null) {
                try {
                    if (pageToUpdate.getSource() != null && pageToUpdate.getSource().getConfiguration() != null) {
                        this.mergeSensitiveData(this.getFetcher(pageToUpdate.getSource()).getConfiguration(), page);
                    }
                    this.fetchPage(page);
                }
                catch (FetcherException e) {
                    throw this.onUpdateFail(pageId, e);
                }
            } else {
                page.setUseAutoFetch(null);
            }
            if (this.isSwaggerOrMarkdown(pageType)) {
                createRevision = this.pageHasChanged(pageToUpdate, page);
            }
            page.setId(pageId);
            page.setUpdatedAt(new Date());
            page.setCreatedAt(pageToUpdate.getCreatedAt());
            page.setType(pageType);
            page.setReferenceId(pageToUpdate.getReferenceId());
            page.setReferenceType(pageToUpdate.getReferenceType());
            this.onlyOneHomepage(page);
            if (PageReferenceType.API.equals((Object)pageToUpdate.getReferenceType()) && updatePageEntity.isPublished() != null && !updatePageEntity.isPublished().booleanValue() && (activePlan = this.planService.findByApi(pageToUpdate.getReferenceId()).stream().filter(plan -> plan.getGeneralConditions() != null).filter(plan -> pageToUpdate.getId().equals(plan.getGeneralConditions())).filter(plan -> !PlanStatus.CLOSED.equals((Object)plan.getStatus()) && !PlanStatus.STAGING.equals((Object)plan.getStatus())).findFirst()).isPresent()) {
                throw new PageUsedAsGeneralConditionsException(pageId, page.getName(), "unpublish", activePlan.get().getName());
            }
            if (PageReferenceType.ENVIRONMENT.equals((Object)pageToUpdate.getReferenceType()) && updatePageEntity.isPublished() != null && !updatePageEntity.isPublished().booleanValue() && !(categoriesUsingPage = this.categoryService.findByPage(pageId)).isEmpty()) {
                String categoriesName = categoriesUsingPage.stream().map(CategoryEntity::getName).collect(Collectors.joining(", ", "{ ", " }"));
                throw new PageUsedByCategoryException(pageId, page.getName(), "unpublish", categoriesName);
            }
            if (page.getOrder() != pageToUpdate.getOrder()) {
                this.reorderAndSavePages(page);
            }
            List<String> messages = this.validateSafeContent(page);
            Page updatedPage = this.pageRepository.update(page);
            if (pageToUpdate.isPublished() != page.isPublished() && !PageType.LINK.name().equalsIgnoreCase(pageType) && !PageType.TRANSLATION.name().equalsIgnoreCase(pageType)) {
                this.changeRelatedPagesPublicationStatus(pageId, updatePageEntity.isPublished());
            }
            this.createAuditLog(PageReferenceType.API.equals((Object)page.getReferenceType()) ? page.getReferenceId() : null, (Audit.AuditEvent)Page.AuditEvent.PAGE_UPDATED, page.getUpdatedAt(), pageToUpdate, page);
            if (createRevision) {
                this.createPageRevision(updatedPage);
            }
            PageEntity pageEntity = this.convert(updatedPage);
            pageEntity.setMessages(messages);
            if (pageToUpdate.isPublished() && !page.isPublished()) {
                this.searchEngineService.delete((Indexable)this.convert(pageToUpdate), false);
            } else {
                this.index(pageEntity);
            }
            return pageEntity;
        }
        catch (TechnicalException ex) {
            throw this.onUpdateFail(pageId, ex);
        }
    }

    private boolean pageHasChanged(UpdatePageEntity updatePageEntity, Page pageToUpdate) {
        return this.pageHasChanged(PageServiceImpl.convert(updatePageEntity), pageToUpdate);
    }

    private boolean pageHasChanged(Page updatedPage, Page pageToUpdate) {
        String newContent = updatedPage.getContent();
        String actualContent = pageToUpdate.getContent();
        String newName = updatedPage.getName();
        String actualName = pageToUpdate.getName();
        boolean hasChanged = newContent != null && !newContent.equals(actualContent) || newName != null && !newName.equals(actualName);
        return hasChanged;
    }

    private boolean isSwaggerOrMarkdown(String pageType) {
        return PageType.SWAGGER.name().equalsIgnoreCase(pageType) || PageType.MARKDOWN.name().equalsIgnoreCase(pageType);
    }

    private void checkUpdatedPageSituation(UpdatePageEntity updatePageEntity, String pageType, String pageId) throws TechnicalException {
        PageSituation newParentSituation = this.getPageSituation(updatePageEntity.getParentId());
        switch (pageType) {
            case "SYSTEM_FOLDER": {
                if (newParentSituation == PageSituation.ROOT) break;
                throw new PageActionException(PageType.SYSTEM_FOLDER, " be moved in this folder");
            }
            case "MARKDOWN": {
                if (newParentSituation != PageSituation.SYSTEM_FOLDER && newParentSituation != PageSituation.IN_SYSTEM_FOLDER) break;
                throw new PageActionException(PageType.MARKDOWN, " be moved in a system folder or in a folder of a system folder");
            }
            case "SWAGGER": {
                if (newParentSituation != PageSituation.SYSTEM_FOLDER && newParentSituation != PageSituation.IN_SYSTEM_FOLDER) break;
                throw new PageActionException(PageType.SWAGGER, " be moved in a system folder or in a folder of a system folder");
            }
            case "FOLDER": {
                PageSituation folderSituation = this.getPageSituation(pageId);
                if (folderSituation == PageSituation.IN_SYSTEM_FOLDER && newParentSituation != PageSituation.SYSTEM_FOLDER) {
                    throw new PageActionException(PageType.FOLDER, " be moved anywhere other than in a system folder");
                }
                if (folderSituation == PageSituation.IN_SYSTEM_FOLDER || newParentSituation != PageSituation.SYSTEM_FOLDER) break;
                throw new PageActionException(PageType.FOLDER, " be moved in a system folder");
            }
            case "LINK": {
                if (newParentSituation == PageSituation.SYSTEM_FOLDER || newParentSituation == PageSituation.IN_SYSTEM_FOLDER) break;
                throw new PageActionException(PageType.LINK, " be moved anywhere other than in a system folder or in a folder of a system folder");
            }
            case "TRANSLATION": {
                if (newParentSituation != PageSituation.ROOT && newParentSituation != PageSituation.SYSTEM_FOLDER && newParentSituation != PageSituation.TRANSLATION) break;
                throw new PageActionException(PageType.TRANSLATION, "be updated. Parent " + updatePageEntity.getParentId() + " is not one of this type : FOLDER, LINK, MARKDOWN, SWAGGER");
            }
        }
    }

    private void changeRelatedPagesPublicationStatus(String pageId, Boolean published) {
        try {
            this.pageRepository.search(new PageCriteria.Builder().type(PageType.LINK.name()).build()).stream().filter(p -> pageId.equals(p.getContent())).forEach(p -> {
                try {
                    p.setPublished(published.booleanValue());
                    this.pageRepository.update(p);
                    this.changeTranslationPagesPublicationStatus(p.getId(), published);
                }
                catch (TechnicalException ex) {
                    throw this.onUpdateFail(p.getId(), ex);
                }
            });
            this.changeTranslationPagesPublicationStatus(pageId, published);
        }
        catch (TechnicalException ex) {
            logger.error("An error occurs while trying to search pages", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to search pages", ex);
        }
    }

    private void changeTranslationPagesPublicationStatus(String translatedPageId, Boolean published) {
        try {
            this.pageRepository.search(new PageCriteria.Builder().parent(translatedPageId).type(PageType.TRANSLATION.name()).build()).stream().forEach(p -> {
                try {
                    p.setPublished(published.booleanValue());
                    this.pageRepository.update(p);
                }
                catch (TechnicalException ex) {
                    throw this.onUpdateFail(p.getId(), ex);
                }
            });
        }
        catch (TechnicalException ex) {
            logger.error("An error occurs while trying to search pages", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to search pages", ex);
        }
    }

    private void deleteRelatedPages(String pageId) {
        try {
            this.pageRepository.search(new PageCriteria.Builder().type("LINK").build()).stream().filter(p -> pageId.equals(p.getContent())).forEach(p -> {
                try {
                    this.pageRepository.delete(p.getId());
                    this.deleteRelatedTranslations(p.getId());
                }
                catch (TechnicalException ex) {
                    logger.error("An error occurs while trying to delete Page {}", (Object)p.getId(), (Object)ex);
                    throw new TechnicalManagementException("An error occurs while trying to delete Page " + p.getId(), ex);
                }
            });
            this.deleteRelatedTranslations(pageId);
        }
        catch (TechnicalException ex) {
            logger.error("An error occurs while trying to search pages", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to search pages", ex);
        }
    }

    private void deleteRelatedTranslations(String pageId) {
        try {
            this.pageRepository.search(new PageCriteria.Builder().parent(pageId).type(PageType.TRANSLATION.name()).build()).stream().forEach(p -> {
                try {
                    this.pageRepository.delete(p.getId());
                }
                catch (TechnicalException ex) {
                    logger.error("An error occurs while trying to delete Page {}", (Object)p.getId(), (Object)ex);
                    throw new TechnicalManagementException("An error occurs while trying to delete Page " + p.getId(), ex);
                }
            });
        }
        catch (TechnicalException ex) {
            logger.error("An error occurs while trying to search pages", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to search pages", ex);
        }
    }

    private void index(PageEntity pageEntity) {
        if (pageEntity.isPublished()) {
            this.searchEngineService.index((Indexable)pageEntity, false);
        }
    }

    private void fetchPage(Page page) throws FetcherException {
        this.validateSafeSource(page);
        Fetcher fetcher = this.getFetcher(page.getSource());
        if (fetcher != null) {
            try {
                Resource resource = fetcher.fetch();
                page.setContent(this.getResourceContentAsString(resource));
                if (resource.getMetadata() != null) {
                    page.setMetadata(new HashMap(resource.getMetadata().size()));
                    for (Map.Entry entry : resource.getMetadata().entrySet()) {
                        if (entry.getValue() instanceof Map) continue;
                        page.getMetadata().put((String)entry.getKey(), String.valueOf(entry.getValue()));
                    }
                }
                if (fetcher.getConfiguration().isAutoFetch()) {
                    page.setUseAutoFetch(Boolean.TRUE);
                } else {
                    page.setUseAutoFetch(null);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new FetcherException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private Fetcher getFetcher(PageSource ps) throws FetcherException {
        if (ps.getConfiguration().isEmpty()) {
            return null;
        }
        try {
            Fetcher fetcher;
            FetcherPlugin fetcherPlugin = (FetcherPlugin)this.fetcherPluginManager.get(ps.getType());
            ClassLoader fetcherCL = fetcherPlugin.fetcher().getClassLoader();
            if (fetcherPlugin.configuration().getName().equals(FilepathAwareFetcherConfiguration.class.getName())) {
                Class<?> fetcherConfigurationClass = fetcherCL.loadClass(fetcherPlugin.configuration().getName());
                Class<?> fetcherClass = fetcherCL.loadClass(fetcherPlugin.clazz());
                FetcherConfiguration fetcherConfigurationInstance = this.fetcherConfigurationFactory.create(fetcherConfigurationClass, ps.getConfiguration());
                fetcher = (Fetcher)fetcherClass.getConstructor(fetcherConfigurationClass).newInstance(fetcherConfigurationInstance);
            } else {
                Class<?> fetcherConfigurationClass = fetcherCL.loadClass(fetcherPlugin.configuration().getName());
                Class<?> fetcherClass = fetcherCL.loadClass(fetcherPlugin.clazz());
                FetcherConfiguration fetcherConfigurationInstance = this.fetcherConfigurationFactory.create(fetcherConfigurationClass, ps.getConfiguration());
                fetcher = (Fetcher)fetcherClass.getConstructor(fetcherConfigurationClass).newInstance(fetcherConfigurationInstance);
            }
            this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)fetcher);
            return fetcher;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new FetcherException(e.getMessage(), (Throwable)e);
        }
    }

    private String getResourceContentAsString(Resource resource) throws FetcherException {
        try {
            StringBuilder sb = new StringBuilder();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(resource.getContent()));){
                String line;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.append("\n");
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new FetcherException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<PageEntity> importFiles(ImportPageEntity pageEntity) {
        return this.importFiles(null, pageEntity);
    }

    @Override
    public List<PageEntity> importFiles(String apiId, ImportPageEntity pageEntity) {
        Page page = this.upsertRootPage(apiId, pageEntity);
        pageEntity.setSource(this.convert(page.getSource(), false));
        return this.fetchPages(apiId, pageEntity);
    }

    @Override
    public long execAutoFetch() {
        logger.debug("Auto Fetch pages");
        try {
            List autoFetchPages = this.pageRepository.search(new PageCriteria.Builder().withAutoFetch().build());
            long nbOfFetchedPages = autoFetchPages.stream().filter(pageListItem -> pageListItem.getSource() != null).filter(this::isFetchRequired).map(this::executeAutoFetch).flatMap(Collection::stream).count();
            logger.debug("{} pages fetched", (Object)nbOfFetchedPages);
            return nbOfFetchedPages;
        }
        catch (TechnicalException ex) {
            logger.error("An error occurs while trying to fetch pages", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to fetch pages", ex);
        }
    }

    private boolean isFetchRequired(Page pageItem) {
        boolean fetchRequired = false;
        try {
            String cron;
            FetcherConfiguration configuration = this.getFetcher(pageItem.getSource()).getConfiguration();
            if (configuration.isAutoFetch() && (cron = configuration.getFetchCron()) != null && !cron.isEmpty()) {
                CronSequenceGenerator cronSequenceGenerator = new CronSequenceGenerator(cron);
                if (pageItem.getUpdatedAt() != null) {
                    Date nextRun = cronSequenceGenerator.next(pageItem.getUpdatedAt());
                    fetchRequired = nextRun.before(new Date());
                }
            }
        }
        catch (FetcherException e) {
            logger.error("An error occurs while trying to initialize fetcher '{}'", (Object)pageItem.getSource().getType(), (Object)e);
        }
        catch (IllegalArgumentException e) {
            logger.error("An error occurs while trying to parse the cron expression", (Throwable)e);
        }
        return fetchRequired;
    }

    private List<PageEntity> executeAutoFetch(Page page) {
        try {
            if (page.getType() != null && page.getType().toString().equals("ROOT")) {
                ImportPageEntity pageEntity = new ImportPageEntity();
                pageEntity.setType(PageType.valueOf((String)page.getType().toString()));
                pageEntity.setSource(this.convert(page.getSource(), false));
                pageEntity.setConfiguration(page.getConfiguration());
                pageEntity.setPublished(page.isPublished());
                pageEntity.setExcludedGroups(page.getExcludedGroups());
                pageEntity.setLastContributor(SYSTEM_CONTRIBUTOR);
                return this.fetchPages(page.getReferenceId(), pageEntity);
            }
            return Arrays.asList(this.fetch(page, SYSTEM_CONTRIBUTOR));
        }
        catch (TechnicalException e) {
            logger.error("An error occurs while trying to auto fetch page {}", (Object)page.getId(), (Object)e);
            return Collections.emptyList();
        }
    }

    @Override
    public void fetchAll(PageQuery query, String contributor) {
        try {
            this.pageRepository.search(this.queryToCriteria(query)).stream().filter(pageListItem -> pageListItem.getSource() != null).forEach(pageListItem -> {
                if (pageListItem.getType() != null && pageListItem.getType().toString().equals("ROOT")) {
                    ImportPageEntity pageEntity = new ImportPageEntity();
                    pageEntity.setType(PageType.valueOf((String)pageListItem.getType().toString()));
                    pageEntity.setSource(this.convert(pageListItem.getSource(), false));
                    pageEntity.setConfiguration(pageListItem.getConfiguration());
                    pageEntity.setPublished(pageListItem.isPublished());
                    pageEntity.setExcludedGroups(pageListItem.getExcludedGroups());
                    pageEntity.setLastContributor(contributor);
                    this.fetchPages(query.getApi(), pageEntity);
                } else {
                    this.fetch(pageListItem.getId(), contributor);
                }
            });
        }
        catch (TechnicalException ex) {
            logger.error("An error occurs while trying to fetch pages", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to fetch pages", ex);
        }
    }

    private List<PageEntity> importDescriptor(String apiId, ImportPageEntity descriptorPageEntity, FilesFetcher fetcher, GraviteeDescriptorEntity descriptorEntity) {
        if (descriptorEntity.getDocumentation() == null || descriptorEntity.getDocumentation().getPages() == null || descriptorEntity.getDocumentation().getPages().isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, String> parentsIdByPath = new HashMap<String, String>();
        ArrayList<PageEntity> createdPages = new ArrayList<PageEntity>();
        int order = 0;
        for (GraviteeDescriptorPageEntity descriptorPage : descriptorEntity.getDocumentation().getPages()) {
            NewPageEntity newPage = this.getPageFromPath(descriptorPage.getSrc());
            if (newPage == null) {
                logger.warn("Unable to find a source file to import. Please fix the descriptor content.");
                continue;
            }
            if (descriptorPage.getName() != null && !descriptorPage.getName().isEmpty()) {
                newPage.setName(descriptorPage.getName());
            }
            newPage.setHomepage(descriptorPage.isHomepage());
            newPage.setLastContributor(descriptorPageEntity.getLastContributor());
            newPage.setPublished(descriptorPageEntity.isPublished());
            newPage.setSource(descriptorPageEntity.getSource());
            newPage.setOrder(order++);
            String parentPath = descriptorPage.getDest() == null || descriptorPage.getDest().isEmpty() ? this.getParentPathFromFilePath(descriptorPage.getSrc()) : descriptorPage.getDest();
            try {
                createdPages.addAll(this.upsertPageAndParentFolders(parentPath, newPage, parentsIdByPath, fetcher, apiId, descriptorPage.getSrc()));
            }
            catch (TechnicalException ex) {
                logger.error("An error occurs while trying to import a gravitee descriptor", (Throwable)ex);
                throw new TechnicalManagementException("An error occurs while trying to import a gravitee descriptor", ex);
            }
        }
        return createdPages;
    }

    private List<PageEntity> importDirectory(String apiId, ImportPageEntity pageEntity, FilesFetcher fetcher) {
        try {
            String[] files = fetcher.files();
            Optional<String> optDescriptor = Arrays.stream(files).filter(f -> f.endsWith(this.graviteeDescriptorService.descriptorName())).findFirst();
            if (optDescriptor.isPresent()) {
                try {
                    ((FilepathAwareFetcherConfiguration)fetcher.getConfiguration()).setFilepath(optDescriptor.get());
                    Resource resource = fetcher.fetch();
                    GraviteeDescriptorEntity descriptorEntity = this.graviteeDescriptorService.read(this.getResourceContentAsString(resource));
                    return this.importDescriptor(apiId, pageEntity, fetcher, descriptorEntity);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new FetcherException(e.getMessage(), (Throwable)e);
                }
            }
            HashMap<String, String> parentsIdByPath = new HashMap<String, String>();
            ArrayList<PageEntity> createdPages = new ArrayList<PageEntity>();
            int order = 0;
            for (String file : files) {
                NewPageEntity pageFromPath = this.getPageFromPath(file);
                if (pageFromPath == null) continue;
                pageFromPath.setLastContributor(pageEntity.getLastContributor());
                pageFromPath.setPublished(pageEntity.isPublished());
                pageFromPath.setSource(pageEntity.getSource());
                pageFromPath.setOrder(order++);
                try {
                    createdPages.addAll(this.upsertPageAndParentFolders(this.getParentPathFromFilePath(file), pageFromPath, parentsIdByPath, fetcher, apiId, file));
                }
                catch (TechnicalException ex) {
                    logger.error("An error occurs while trying to import a directory", (Throwable)ex);
                    throw new TechnicalManagementException("An error occurs while trying to import a directory", ex);
                }
            }
            return createdPages;
        }
        catch (FetcherException ex) {
            logger.error("An error occurs while trying to import a directory", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying import a directory", ex);
        }
    }

    private NewPageEntity getPageFromPath(String path) {
        String[] pathElements;
        PageType supportedPageType;
        String[] extensions;
        if (path != null && (extensions = path.split("\\.")).length > 0 && (supportedPageType = this.getSupportedPageType(extensions[extensions.length - 1])) != null && (pathElements = path.split("/")).length > 0) {
            String filename = pathElements[pathElements.length - 1];
            NewPageEntity newPage = new NewPageEntity();
            newPage.setName(filename.substring(0, filename.lastIndexOf(".")));
            newPage.setType(supportedPageType);
            return newPage;
        }
        logger.warn("Unable to extract Page informations from :[" + path + "]");
        return null;
    }

    private String getParentPathFromFilePath(String filePath) {
        String[] pathElements;
        if (filePath != null && !filePath.isEmpty() && (pathElements = filePath.split("/")).length > 0) {
            StringJoiner stringJoiner = new StringJoiner("/");
            for (int i = 0; i < pathElements.length - 1; ++i) {
                stringJoiner.add(pathElements[i]);
            }
            return stringJoiner.toString();
        }
        return "/";
    }

    private List<PageEntity> upsertPageAndParentFolders(String parentPath, NewPageEntity newPageEntity, Map<String, String> parentsIdByPath, FilesFetcher fetcher, String apiId, String src) throws TechnicalException {
        ObjectMapper mapper = new ObjectMapper();
        String[] pathElements = parentPath.split("/");
        String pwd = "";
        ArrayList<PageEntity> createdPages = new ArrayList<PageEntity>();
        for (String pathElement : pathElements) {
            if (pathElement.isEmpty()) continue;
            String futurePwd = pwd + "/" + pathElement;
            if (!parentsIdByPath.containsKey(futurePwd)) {
                PageEntity folder;
                String parentId = parentsIdByPath.get(pwd);
                List pages = this.pageRepository.search(new PageCriteria.Builder().parent(parentId).referenceId(apiId).referenceType(PageReferenceType.API.name()).name(pathElement).type(PageType.FOLDER.name()).build());
                if (pages.isEmpty()) {
                    NewPageEntity newPage = new NewPageEntity();
                    newPage.setParentId(parentId);
                    newPage.setPublished(newPageEntity.isPublished());
                    newPage.setLastContributor(newPageEntity.getLastContributor());
                    newPage.setName(pathElement);
                    newPage.setType(PageType.FOLDER);
                    folder = this.createPage(apiId, newPage);
                } else {
                    folder = this.convert((Page)pages.get(0));
                }
                parentsIdByPath.put(futurePwd, folder.getId());
                createdPages.add(folder);
            }
            pwd = futurePwd;
        }
        String parentId = parentsIdByPath.get(pwd);
        List pages = this.pageRepository.search(new PageCriteria.Builder().parent(parentId).referenceId(apiId).referenceType(PageReferenceType.API.name()).name(newPageEntity.getName()).type(newPageEntity.getType().name()).build());
        if (pages.isEmpty()) {
            newPageEntity.setParentId(parentId);
            FilepathAwareFetcherConfiguration configuration = (FilepathAwareFetcherConfiguration)fetcher.getConfiguration();
            configuration.setFilepath(src);
            newPageEntity.getSource().setConfiguration(mapper.valueToTree((Object)configuration));
            createdPages.add(this.createPage(apiId, newPageEntity));
        } else {
            Page page = (Page)pages.get(0);
            UpdatePageEntity updatePage = this.convertToUpdateEntity(page);
            updatePage.setLastContributor(newPageEntity.getLastContributor());
            updatePage.setPublished(Boolean.valueOf(newPageEntity.isPublished()));
            updatePage.setOrder(Integer.valueOf(newPageEntity.getOrder()));
            updatePage.setHomepage(Boolean.valueOf(newPageEntity.isHomepage()));
            FilepathAwareFetcherConfiguration configuration = (FilepathAwareFetcherConfiguration)fetcher.getConfiguration();
            configuration.setFilepath(src);
            updatePage.setSource(newPageEntity.getSource());
            updatePage.getSource().setConfiguration(mapper.valueToTree((Object)configuration));
            createdPages.add(this.update(page.getId(), updatePage, false));
        }
        return createdPages;
    }

    private Page upsertRootPage(String apiId, ImportPageEntity rootPage) {
        try {
            FetcherConfiguration configuration;
            List searchResult = this.pageRepository.search(new PageCriteria.Builder().referenceId(apiId).referenceType(PageReferenceType.API.name()).type(PageType.ROOT.name()).build());
            Page page = PageServiceImpl.convert(rootPage);
            page.setReferenceId(apiId);
            page.setReferenceType(PageReferenceType.API);
            if (page.getSource() != null) {
                configuration = this.getFetcher(page.getSource()).getConfiguration();
                if (configuration.isAutoFetch()) {
                    page.setUseAutoFetch(Boolean.TRUE);
                } else {
                    page.setUseAutoFetch(null);
                }
            }
            if (searchResult.isEmpty()) {
                page.setCreatedAt(new Date());
                page.setUpdatedAt(page.getCreatedAt());
                page.setId(RandomString.generate());
                this.validateSafeContent(page);
                return this.pageRepository.create(page);
            }
            page.setId(((Page)searchResult.get(0)).getId());
            configuration = this.getFetcher(((Page)searchResult.get(0)).getSource()).getConfiguration();
            this.mergeSensitiveData(configuration, page);
            page.setUpdatedAt(new Date());
            this.validateSafeContent(page);
            return this.pageRepository.update(page);
        }
        catch (FetcherException | TechnicalException ex) {
            logger.error("An error occurs while trying to save the configuration", ex);
            throw new TechnicalManagementException("An error occurs while trying to save the configuration", ex);
        }
    }

    private PageType getSupportedPageType(String extension) {
        for (PageType pageType : PageType.values()) {
            if (!pageType.extensions().contains(extension.toLowerCase())) continue;
            return pageType;
        }
        return null;
    }

    private void reorderAndSavePages(Page pageToReorder) throws TechnicalException {
        PageCriteria.Builder q = new PageCriteria.Builder().referenceId(pageToReorder.getReferenceId()).referenceType(pageToReorder.getReferenceType().name());
        if (pageToReorder.getParentId() == null) {
            q.rootParent(Boolean.TRUE);
        } else {
            q.parent(pageToReorder.getParentId());
        }
        List pages = this.pageRepository.search(q.build());
        List<Boolean> increment = Arrays.asList(true);
        pages.stream().sorted(Comparator.comparingInt(Page::getOrder)).forEachOrdered(page -> {
            try {
                if (page.equals((Object)pageToReorder)) {
                    increment.set(0, false);
                    page.setOrder(pageToReorder.getOrder());
                } else {
                    Boolean isIncrement = (Boolean)increment.get(0);
                    int newOrder = page.getOrder() < pageToReorder.getOrder() ? page.getOrder() - (isIncrement != false ? 0 : 1) : (page.getOrder() > pageToReorder.getOrder() ? page.getOrder() + (isIncrement != false ? 1 : 0) : page.getOrder() + (isIncrement != false ? 1 : -1));
                    page.setOrder(newOrder);
                }
                this.pageRepository.update(page);
            }
            catch (TechnicalException ex) {
                throw this.onUpdateFail(page.getId(), ex);
            }
        });
    }

    private TechnicalManagementException onUpdateFail(String pageId, TechnicalException ex) {
        logger.error("An error occurs while trying to update page {}", (Object)pageId, (Object)ex);
        return new TechnicalManagementException("An error occurs while trying to update page " + pageId, ex);
    }

    private TechnicalManagementException onUpdateFail(String pageId, FetcherException ex) {
        logger.error("An error occurs while trying to update page {}", (Object)pageId, (Object)ex);
        return new TechnicalManagementException("An error occurs while trying to fetch content. " + ex.getMessage(), ex);
    }

    @Override
    public void delete(String pageId) {
        try {
            Optional<PlanEntity> activePlan;
            List search;
            logger.debug("Delete Page : {}", (Object)pageId);
            Optional optPage = this.pageRepository.findById(pageId);
            if (!optPage.isPresent()) {
                throw new PageNotFoundException(pageId);
            }
            Page page = (Page)optPage.get();
            if (PageType.FOLDER.name().equalsIgnoreCase(page.getType()) && !(search = this.pageRepository.search(new PageCriteria.Builder().referenceId(page.getReferenceId()).referenceType(page.getReferenceType().name()).parent(page.getId()).build())).isEmpty()) {
                throw new TechnicalManagementException("Unable to remove the folder. It must be empty before being removed.");
            }
            List<CategoryEntity> categories = this.categoryService.findByPage(pageId);
            if (categories != null && !categories.isEmpty()) {
                String categoriesKeys = categories.stream().map(CategoryEntity::getKey).collect(Collectors.joining(","));
                throw new PageActionException(PageType.valueOf((String)page.getType()), "be deleted since it is used in categories [" + categoriesKeys + "]");
            }
            if (page.getReferenceType() != null && page.getReferenceType().equals((Object)PageReferenceType.API) && (activePlan = this.planService.findByApi(page.getReferenceId()).stream().filter(plan -> plan.getGeneralConditions() != null).filter(plan -> PageType.TRANSLATION.name().equals(page.getType()) && plan.getGeneralConditions().equals(page.getParentId()) || plan.getGeneralConditions().equals(page.getId())).filter(plan -> !PlanStatus.CLOSED.equals((Object)plan.getStatus())).findFirst()).isPresent()) {
                throw new PageUsedAsGeneralConditionsException(pageId, page.getName(), "remove", activePlan.get().getName());
            }
            this.pageRepository.delete(pageId);
            if (!PageType.LINK.name().equalsIgnoreCase(page.getType()) && !PageType.TRANSLATION.name().equalsIgnoreCase(page.getType())) {
                this.deleteRelatedPages(page.getId());
            }
            this.createAuditLog(PageReferenceType.API.equals((Object)page.getReferenceType()) ? page.getReferenceId() : null, (Audit.AuditEvent)Page.AuditEvent.PAGE_DELETED, new Date(), page, null);
            this.searchEngineService.delete((Indexable)this.convert(page), false);
        }
        catch (TechnicalException ex) {
            logger.error("An error occurs while trying to delete Page {}", (Object)pageId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete Page " + pageId, ex);
        }
    }

    @Override
    public void deleteAllByApi(String apiId) {
        List<PageEntity> pages = this.search(new PageQuery.Builder().api(apiId).build(), null, false, false);
        pages.sort(new Comparator<PageEntity>(){

            @Override
            public int compare(PageEntity p0, PageEntity p1) {
                Integer r1;
                Integer r0 = PageType.valueOf((String)p0.getType()).getRemoveOrder();
                if (r0.equals(r1 = PageType.valueOf((String)p1.getType()).getRemoveOrder())) {
                    return Integer.compare(p1.getOrder(), p0.getOrder());
                }
                return r0.compareTo(r1);
            }
        });
        pages.forEach(pageEntity -> this.delete(pageEntity.getId()));
    }

    @Override
    public int findMaxApiPageOrderByApi(String apiName) {
        try {
            logger.debug("Find Max Order Page for api name : {}", (Object)apiName);
            Integer maxPageOrder = this.pageRepository.findMaxPageReferenceIdAndReferenceTypeOrder(apiName, PageReferenceType.API);
            return maxPageOrder == null ? 0 : maxPageOrder;
        }
        catch (TechnicalException ex) {
            logger.error("An error occured when searching max order page for api name [{}]", (Object)apiName, (Object)ex);
            throw new TechnicalManagementException("An error occured when searching max order page for api name " + apiName, ex);
        }
    }

    @Override
    public int findMaxPortalPageOrder() {
        try {
            logger.debug("Find Max Order Portal Page");
            Integer maxPageOrder = this.pageRepository.findMaxPageReferenceIdAndReferenceTypeOrder(GraviteeContext.getCurrentEnvironment(), PageReferenceType.ENVIRONMENT);
            return maxPageOrder == null ? 0 : maxPageOrder;
        }
        catch (TechnicalException ex) {
            logger.error("An error occured when searching max order portal page", (Throwable)ex);
            throw new TechnicalManagementException("An error occured when searching max order portal ", ex);
        }
    }

    @Override
    public boolean isDisplayable(ApiEntity api, boolean pageIsPublished, String username) {
        boolean isDisplayable = false;
        if (api.getVisibility() == Visibility.PUBLIC && pageIsPublished) {
            isDisplayable = true;
        } else if (username != null) {
            MemberEntity member = this.membershipService.getUserMember(MembershipReferenceType.API, api.getId(), username);
            if (member == null && api.getGroups() != null) {
                Iterator groupIdIterator = api.getGroups().iterator();
                while (!isDisplayable && groupIdIterator.hasNext()) {
                    String groupId = (String)groupIdIterator.next();
                    member = this.membershipService.getUserMember(MembershipReferenceType.GROUP, groupId, username);
                    isDisplayable = this.isDisplayableForMember(member, pageIsPublished);
                }
            } else {
                isDisplayable = this.isDisplayableForMember(member, pageIsPublished);
            }
        }
        return isDisplayable;
    }

    private boolean isDisplayableForMember(MemberEntity member, boolean pageIsPublished) {
        if (member == null) {
            return false;
        }
        if (pageIsPublished) {
            return true;
        }
        return this.roleService.hasPermission(member.getPermissions(), (Permission)ApiPermission.DOCUMENTATION, new RolePermissionAction[]{RolePermissionAction.UPDATE, RolePermissionAction.CREATE, RolePermissionAction.DELETE});
    }

    @Override
    public PageEntity fetch(String pageId, String contributor) {
        try {
            logger.debug("Fetch page {}", (Object)pageId);
            Optional optPageToUpdate = this.pageRepository.findById(pageId);
            if (!optPageToUpdate.isPresent()) {
                throw new PageNotFoundException(pageId);
            }
            Page page = (Page)optPageToUpdate.get();
            if (page.getSource() == null) {
                throw new NoFetcherDefinedException(pageId);
            }
            return this.fetch(page, contributor);
        }
        catch (TechnicalException ex) {
            throw this.onUpdateFail(pageId, ex);
        }
    }

    private PageEntity fetch(Page page, String contributor) throws TechnicalException {
        Page previousPage = new Page();
        previousPage.setContent(page.getContent());
        previousPage.setName(page.getName());
        try {
            this.fetchPage(page);
        }
        catch (FetcherException e) {
            throw this.onUpdateFail(page.getId(), e);
        }
        page.setUpdatedAt(new Date());
        page.setLastContributor(contributor);
        List<String> messages = this.validateSafeContent(page);
        Page updatedPage = this.pageRepository.update(page);
        if (this.isSwaggerOrMarkdown(updatedPage.getType()) && this.pageHasChanged(updatedPage, previousPage)) {
            this.createPageRevision(updatedPage);
        }
        this.createAuditLog(PageReferenceType.API.equals((Object)page.getReferenceType()) ? page.getReferenceId() : null, (Audit.AuditEvent)Page.AuditEvent.PAGE_UPDATED, page.getUpdatedAt(), page, page);
        PageEntity pageEntity = this.convert(updatedPage);
        pageEntity.setMessages(messages);
        return pageEntity;
    }

    private List<PageEntity> fetchPages(String apiId, ImportPageEntity pageEntity) {
        try {
            Fetcher _fetcher = this.getFetcher(PageServiceImpl.convert(pageEntity.getSource()));
            if (_fetcher == null) {
                return Collections.emptyList();
            }
            if (!(_fetcher instanceof FilesFetcher)) {
                throw new UnsupportedOperationException("The plugin does not support to import a directory.");
            }
            FilesFetcher fetcher = (FilesFetcher)_fetcher;
            return this.importDirectory(apiId, pageEntity, fetcher);
        }
        catch (FetcherException ex) {
            logger.error("An error occurs while trying to import a directory", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying import a directory", ex);
        }
    }

    private NewPageEntity convert(PageEntity pageEntity) {
        NewPageEntity newPageEntity = new NewPageEntity();
        newPageEntity.setName(pageEntity.getName());
        newPageEntity.setOrder(pageEntity.getOrder());
        newPageEntity.setPublished(pageEntity.isPublished());
        newPageEntity.setSource(pageEntity.getSource());
        newPageEntity.setType(PageType.valueOf((String)pageEntity.getType()));
        newPageEntity.setParentId(pageEntity.getParentId());
        newPageEntity.setHomepage(pageEntity.isHomepage());
        newPageEntity.setContent(pageEntity.getContent());
        newPageEntity.setConfiguration(pageEntity.getConfiguration());
        newPageEntity.setExcludedGroups(pageEntity.getExcludedGroups());
        newPageEntity.setLastContributor(pageEntity.getLastContributor());
        return newPageEntity;
    }

    private List<PageEntity> convert(List<Page> pages) {
        if (pages == null) {
            return Collections.emptyList();
        }
        return pages.stream().map(this::convert).collect(Collectors.toList());
    }

    private PageEntity convert(Page page) {
        PageEntity pageEntity;
        if (page.getReferenceId() != null && PageReferenceType.API.equals((Object)page.getReferenceType())) {
            pageEntity = new ApiPageEntity();
            ((ApiPageEntity)pageEntity).setApi(page.getReferenceId());
        } else {
            pageEntity = new PageEntity();
        }
        pageEntity.setId(page.getId());
        pageEntity.setName(page.getName());
        pageEntity.setHomepage(page.isHomepage());
        pageEntity.setType(page.getType());
        pageEntity.setContent(page.getContent());
        if (PageServiceImpl.isJson(page.getContent())) {
            pageEntity.setContentType("application/json");
        } else {
            pageEntity.setContentType("text/yaml");
        }
        pageEntity.setLastContributor(page.getLastContributor());
        pageEntity.setLastModificationDate(page.getUpdatedAt());
        pageEntity.setOrder(page.getOrder());
        pageEntity.setPublished(page.isPublished());
        if (page.getSource() != null) {
            pageEntity.setSource(this.convert(page.getSource()));
        }
        if (page.getConfiguration() != null) {
            pageEntity.setConfiguration(page.getConfiguration());
        }
        if (page.getAttachedMedia() != null) {
            pageEntity.setAttachedMedia(PageServiceImpl.convertMedia(page.getAttachedMedia()));
        }
        pageEntity.setExcludedGroups(page.getExcludedGroups());
        pageEntity.setParentId("".equals(page.getParentId()) ? null : page.getParentId());
        pageEntity.setMetadata(page.getMetadata());
        pageEntity.setParentPath(this.computeParentPath(page, ""));
        return pageEntity;
    }

    private String computeParentPath(Page page, String suffix) {
        String path = suffix;
        String parentId = page.getParentId();
        if (!StringUtils.isEmpty((CharSequence)parentId)) {
            try {
                Optional optParent = this.pageRepository.findById(parentId);
                if (optParent.isPresent()) {
                    return this.computeParentPath((Page)optParent.get(), "/" + ((Page)optParent.get()).getName() + path);
                }
            }
            catch (TechnicalException ex) {
                logger.error("An error occurs while trying to find a page using its ID {}", (Object)parentId, (Object)ex);
            }
        }
        return path;
    }

    private List<Page> getTranslations(String pageId) {
        try {
            List searchResult = this.pageRepository.search(new PageCriteria.Builder().parent(pageId).type(PageType.TRANSLATION.name()).build());
            searchResult.sort((p1, p2) -> {
                String lang1 = (String)p1.getConfiguration().get("lang");
                String lang2 = (String)p2.getConfiguration().get("lang");
                return lang1.compareTo(lang2);
            });
            return searchResult;
        }
        catch (TechnicalException ex) {
            logger.error("An error occurs while trying to search pages", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to search pages", ex);
        }
    }

    private UpdatePageEntity convertToUpdateEntity(Page page) {
        UpdatePageEntity updatePageEntity = new UpdatePageEntity();
        updatePageEntity.setName(page.getName());
        updatePageEntity.setContent(page.getContent());
        updatePageEntity.setLastContributor(page.getLastContributor());
        updatePageEntity.setOrder(Integer.valueOf(page.getOrder()));
        updatePageEntity.setPublished(Boolean.valueOf(page.isPublished()));
        updatePageEntity.setSource(this.convert(page.getSource()));
        updatePageEntity.setConfiguration(page.getConfiguration());
        updatePageEntity.setHomepage(Boolean.valueOf(page.isHomepage()));
        updatePageEntity.setExcludedGroups(page.getExcludedGroups());
        updatePageEntity.setAttachedMedia(PageServiceImpl.convertMedia(page.getAttachedMedia()));
        updatePageEntity.setParentId("".equals(page.getParentId()) ? null : page.getParentId());
        return updatePageEntity;
    }

    private PageSourceEntity convert(PageSource pageSource) {
        return this.convert(pageSource, true);
    }

    private PageSourceEntity convert(PageSource pageSource, boolean removeSensitiveData) {
        PageSourceEntity entity = null;
        if (pageSource != null) {
            entity = new PageSourceEntity();
            entity.setType(pageSource.getType());
            try {
                FetcherConfiguration fetcherConfiguration = this.getFetcher(pageSource).getConfiguration();
                if (removeSensitiveData) {
                    this.removeSensitiveData(fetcherConfiguration);
                }
                entity.setConfiguration(new ObjectMapper().valueToTree((Object)fetcherConfiguration));
            }
            catch (FetcherException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return entity;
    }

    private void removeSensitiveData(FetcherConfiguration fetcherConfiguration) {
        Field[] fields;
        for (Field field : fields = fetcherConfiguration.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Sensitive.class)) continue;
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            try {
                field.set(fetcherConfiguration, SENSITIVE_DATA_REPLACEMENT);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            field.setAccessible(accessible);
        }
    }

    private void mergeSensitiveData(FetcherConfiguration originalFetcherConfiguration, Page page) throws FetcherException {
        Field[] fields;
        FetcherConfiguration updatedFetcherConfiguration = this.getFetcher(page.getSource()).getConfiguration();
        boolean updated = false;
        for (Field field : fields = originalFetcherConfiguration.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Sensitive.class)) continue;
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            try {
                Object updatedValue = field.get(updatedFetcherConfiguration);
                if (SENSITIVE_DATA_REPLACEMENT.equals(updatedValue)) {
                    updated = true;
                    field.set(updatedFetcherConfiguration, field.get(originalFetcherConfiguration));
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            field.setAccessible(accessible);
        }
        if (updated) {
            page.getSource().setConfiguration(new ObjectMapper().valueToTree((Object)updatedFetcherConfiguration).toString());
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private List<String> validateSafeContent(Page page) {
        String apiId = null;
        if (PageReferenceType.API.equals((Object)page.getReferenceType())) {
            apiId = page.getReferenceId();
        }
        return this.validateSafeContent(this.convert(page), apiId);
    }

    @Override
    public List<String> validateSafeContent(PageEntity pageEntity, String apiId) {
        if (pageEntity != null) {
            OAIDescriptor openApiDescriptor;
            if (this.markdownSanitize && PageType.MARKDOWN.name().equals(pageEntity.getType())) {
                this.transformWithTemplate(pageEntity, apiId);
                if (!CollectionUtils.isEmpty((Collection)pageEntity.getMessages())) {
                    return Arrays.asList(pageEntity.getMessages().toString());
                }
                HtmlSanitizer.SanitizeInfos sanitizeInfos = HtmlSanitizer.isSafe(pageEntity.getContent());
                if (!sanitizeInfos.isSafe()) {
                    throw new PageContentUnsafeException(sanitizeInfos.getRejectedMessage());
                }
            } else if (PageType.SWAGGER.name().equals(pageEntity.getType()) && pageEntity.getContent() != null && (openApiDescriptor = new OAIParser().parse(pageEntity.getContent())) != null && openApiDescriptor.getMessages() != null) {
                return openApiDescriptor.getMessages();
            }
        }
        return new ArrayList<String>();
    }

    private void validateSafeSource(Page page) {
        Map map;
        if (this.importConfiguration.isAllowImportFromPrivate() || page.getSource() == null || page.getSource().getConfiguration() == null) {
            return;
        }
        PageSource source = page.getSource();
        try {
            map = (Map)new ObjectMapper().readValue(source.getConfiguration(), (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (IOException e2) {
            throw new InvalidDataException("Source is invalid", e2);
        }
        Optional<String> urlOpt = map.entrySet().stream().filter(e -> ((String)e.getKey()).equals("repository") || ((String)e.getKey()).matches(".*[uU]rl")).map(Map.Entry::getValue).findFirst();
        if (!urlOpt.isPresent()) {
            return;
        }
        UrlSanitizerUtils.checkAllowed(urlOpt.get(), this.importConfiguration.getImportWhitelist(), false);
    }

    private void createAuditLog(String apiId, Audit.AuditEvent event, Date createdAt, Page oldValue, Page newValue) {
        String pageId;
        String string = pageId = oldValue != null ? oldValue.getId() : newValue.getId();
        if (apiId == null) {
            this.auditService.createEnvironmentAuditLog(Collections.singletonMap(Audit.AuditProperties.PAGE, pageId), event, createdAt, oldValue, newValue);
        } else {
            this.auditService.createApiAuditLog(apiId, Collections.singletonMap(Audit.AuditProperties.PAGE, pageId), event, createdAt, oldValue, newValue);
        }
    }

    private PageCriteria queryToCriteria(PageQuery query) {
        PageCriteria.Builder builder = new PageCriteria.Builder();
        if (query != null) {
            builder.homepage(query.getHomepage());
            if (query.getApi() != null) {
                builder.referenceId(query.getApi());
                builder.referenceType(PageReferenceType.API.name());
            } else {
                builder.referenceId(GraviteeContext.getCurrentEnvironment());
                builder.referenceType(PageReferenceType.ENVIRONMENT.name());
            }
            builder.name(query.getName());
            builder.parent(query.getParent());
            builder.published(query.getPublished());
            if (query.getType() != null) {
                builder.type(query.getType().name());
            }
            builder.rootParent(query.getRootParent());
        }
        return builder.build();
    }

    @Override
    public Map<SystemFolderType, String> initialize(String environmentId) {
        HashMap<SystemFolderType, String> result = new HashMap<SystemFolderType, String>();
        result.put(SystemFolderType.HEADER, this.createSystemFolder(null, SystemFolderType.HEADER, 1, environmentId).getId());
        result.put(SystemFolderType.TOPFOOTER, this.createSystemFolder(null, SystemFolderType.TOPFOOTER, 2, environmentId).getId());
        result.put(SystemFolderType.FOOTER, this.createSystemFolder(null, SystemFolderType.FOOTER, 3, environmentId).getId());
        return result;
    }

    @Override
    public PageEntity createSystemFolder(String apiId, SystemFolderType systemFolderType, int order, String environmentId) {
        NewPageEntity newSysFolder = new NewPageEntity();
        newSysFolder.setName(systemFolderType.folderName());
        newSysFolder.setOrder(order);
        newSysFolder.setPublished(true);
        newSysFolder.setType(PageType.SYSTEM_FOLDER);
        return this.createPage(apiId, newSysFolder, environmentId);
    }

    @Override
    public boolean shouldHaveRevision(String pageType) {
        PageType type = PageType.valueOf((String)pageType);
        switch (type) {
            case MARKDOWN: 
            case SWAGGER: 
            case TRANSLATION: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void attachMedia(String pageId, String mediaId, String mediaName) {
        try {
            Optional optPage = this.pageRepository.findById(pageId);
            if (optPage.isPresent()) {
                Page page = (Page)optPage.get();
                if (page.getAttachedMedia() == null) {
                    page.setAttachedMedia(new ArrayList());
                }
                page.getAttachedMedia().add(new PageMedia(mediaId, mediaName, new Date()));
                this.pageRepository.update(page);
            }
        }
        catch (TechnicalException ex) {
            throw this.onUpdateFail(pageId, ex);
        }
    }

    @Override
    public PageEntity createWithDefinition(String apiId, String pageDefinition) {
        try {
            NewPageEntity newPage = this.convertToEntity(pageDefinition);
            JsonNode jsonNode = this.objectMapper.readTree(pageDefinition);
            return this.createPage(apiId, newPage, GraviteeContext.getCurrentEnvironment(), jsonNode.get("id") != null ? jsonNode.get("id").asText() : null);
        }
        catch (JsonProcessingException e) {
            logger.error("An error occurs while trying to JSON deserialize the Page {}", (Object)pageDefinition, (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to JSON deserialize the Page definition.");
        }
    }

    private NewPageEntity convertToEntity(String pageDefinition) throws JsonProcessingException {
        return (NewPageEntity)this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(pageDefinition, NewPageEntity.class);
    }

    private static enum PageSituation {
        ROOT,
        IN_ROOT,
        IN_FOLDER_IN_ROOT,
        IN_FOLDER_IN_FOLDER,
        SYSTEM_FOLDER,
        IN_SYSTEM_FOLDER,
        IN_FOLDER_IN_SYSTEM_FOLDER,
        TRANSLATION;

    }
}

