/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.repository.management.model.MetadataReferenceType;
import io.gravitee.rest.api.model.ApplicationMetadataEntity;
import io.gravitee.rest.api.model.NewApplicationMetadataEntity;
import io.gravitee.rest.api.model.NewReferenceMetadataEntity;
import io.gravitee.rest.api.model.ReferenceMetadataEntity;
import io.gravitee.rest.api.model.UpdateApplicationMetadataEntity;
import io.gravitee.rest.api.model.UpdateReferenceMetadataEntity;
import io.gravitee.rest.api.service.ApplicationMetadataService;
import io.gravitee.rest.api.service.impl.AbstractReferenceMetadataService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ApplicationMetadataServiceImpl
extends AbstractReferenceMetadataService
implements ApplicationMetadataService {
    @Override
    public List<ApplicationMetadataEntity> findAllByApplication(String applicationId) {
        List<ReferenceMetadataEntity> allMetadata = this.findAllByReference(MetadataReferenceType.APPLICATION, applicationId, false);
        return allMetadata.stream().map(m -> this.convert((ReferenceMetadataEntity)m, applicationId)).collect(Collectors.toList());
    }

    @Override
    public ApplicationMetadataEntity findByIdAndApplication(String metadataId, String applicationId) {
        return this.convert(this.findByIdAndReference(metadataId, MetadataReferenceType.APPLICATION, applicationId, false), applicationId);
    }

    @Override
    public void delete(String metadataId, String applicationId) {
        this.delete(metadataId, MetadataReferenceType.APPLICATION, applicationId);
    }

    @Override
    public ApplicationMetadataEntity create(NewApplicationMetadataEntity metadataEntity) {
        return this.convert(this.create((NewReferenceMetadataEntity)metadataEntity, MetadataReferenceType.APPLICATION, metadataEntity.getApplicationId(), false), metadataEntity.getApplicationId());
    }

    @Override
    public ApplicationMetadataEntity update(UpdateApplicationMetadataEntity metadataEntity) {
        return this.convert(this.update((UpdateReferenceMetadataEntity)metadataEntity, MetadataReferenceType.APPLICATION, metadataEntity.getApplicationId(), false), metadataEntity.getApplicationId());
    }

    private ApplicationMetadataEntity convert(ReferenceMetadataEntity m, String applicationId) {
        ApplicationMetadataEntity applicationMetadataEntity = new ApplicationMetadataEntity();
        applicationMetadataEntity.setKey(m.getKey());
        applicationMetadataEntity.setName(m.getName());
        applicationMetadataEntity.setFormat(m.getFormat());
        applicationMetadataEntity.setValue(m.getValue());
        applicationMetadataEntity.setDefaultValue(m.getDefaultValue());
        applicationMetadataEntity.setApplicationId(applicationId);
        return applicationMetadataEntity;
    }
}

