/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.plugin.core.api.ConfigurablePlugin;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.rest.api.model.platform.plugin.PluginEntity;
import io.gravitee.rest.api.service.PluginService;
import io.gravitee.rest.api.service.exceptions.PluginNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractPluginService<T extends ConfigurablePlugin, E extends PluginEntity>
extends TransactionalService
implements PluginService<E> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected ConfigurablePluginManager<T> pluginManager;

    protected Set<T> list() {
        try {
            this.logger.debug("List all plugins");
            Collection plugins = this.pluginManager.findAll();
            return new HashSet(plugins);
        }
        catch (Exception ex) {
            this.logger.error("An error occurs while trying to list all policies", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to list all policies", ex);
        }
    }

    protected T get(String pluginId) {
        this.logger.debug("Find plugin by ID: {}", (Object)pluginId);
        ConfigurablePlugin plugin = (ConfigurablePlugin)this.pluginManager.get(pluginId);
        if (plugin == null) {
            throw new PluginNotFoundException(pluginId);
        }
        return (T)plugin;
    }

    @Override
    public String getSchema(String pluginId) {
        try {
            this.logger.debug("Find plugin schema by ID: {}", (Object)pluginId);
            return this.pluginManager.getSchema(pluginId);
        }
        catch (IOException ioex) {
            this.logger.error("An error occurs while trying to get plugin schema for plugin {}", (Object)pluginId, (Object)ioex);
            throw new TechnicalManagementException("An error occurs while trying to get plugin schema for plugin " + pluginId, ioex);
        }
    }

    @Override
    public String getIcon(String pluginId) {
        try {
            this.logger.debug("Find plugin icon by ID: {}", (Object)pluginId);
            return this.pluginManager.getIcon(pluginId);
        }
        catch (IOException ioex) {
            this.logger.error("An error occurs while trying to get plugin icon for plugin {}", (Object)pluginId, (Object)ioex);
            throw new TechnicalManagementException("An error occurs while trying to get plugin icon for plugin " + pluginId, ioex);
        }
    }

    @Override
    public String getDocumentation(String pluginId) {
        try {
            this.logger.debug("Find plugin documentation by ID: {}", (Object)pluginId);
            return this.pluginManager.getDocumentation(pluginId);
        }
        catch (IOException ioex) {
            this.logger.error("An error occurs while trying to get plugin documentation for plugin {}", (Object)pluginId, (Object)ioex);
            throw new TechnicalManagementException("An error occurs while trying to get plugin documentation for plugin " + pluginId, ioex);
        }
    }

    protected PluginEntity convert(Plugin plugin) {
        PluginEntity entity = new PluginEntity();
        entity.setId(plugin.id());
        entity.setDescription(plugin.manifest().description());
        entity.setName(plugin.manifest().name());
        entity.setVersion(plugin.manifest().version());
        return entity;
    }
}

