/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.http.HttpMethod;
import io.gravitee.rest.api.service.EmailValidator;
import io.gravitee.rest.api.service.HttpClientService;
import io.gravitee.rest.api.service.NewsletterService;
import io.gravitee.rest.api.service.exceptions.EmailFormatInvalidException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import io.vertx.core.buffer.Buffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class NewsletterServiceImpl
extends TransactionalService
implements NewsletterService {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewsletterServiceImpl.class);
    @Autowired
    private HttpClientService httpClientService;
    @Autowired
    private ObjectMapper mapper;
    @Value(value="${newsletter.enabled:true}")
    private boolean newsletterEnabled;
    @Value(value="${newsletter.url:https://newsletter.gravitee.io/}")
    private String newsletterUrl;

    @Override
    @Async
    public void subscribe(String email) {
        try {
            if (this.isEnabled()) {
                if (!EmailValidator.isValid(email)) {
                    throw new EmailFormatInvalidException(email);
                }
                HashMap<String, String> newsletterInfo = new HashMap<String, String>();
                newsletterInfo.put("email", email);
                this.httpClientService.request(HttpMethod.POST, this.newsletterUrl, Collections.emptyMap(), this.mapper.writeValueAsString(newsletterInfo), null);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while subscribing to newsletters cause: {}", (Object)e.getMessage());
        }
    }

    @Override
    public List<String> getTaglines() {
        try {
            if (this.isEnabled()) {
                String taglinesPath = "taglines";
                if (this.newsletterUrl.lastIndexOf(47) != this.newsletterUrl.length() - 1) {
                    taglinesPath = "/" + taglinesPath;
                }
                Buffer buffer = this.httpClientService.request(HttpMethod.GET, this.newsletterUrl + taglinesPath, Collections.emptyMap(), null, null);
                return (List)this.mapper.readValue(buffer.toString(), List.class);
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error while reading the taglines response: {}", (Object)e.getMessage());
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        return this.newsletterEnabled;
    }
}

