/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.exceptions;

import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.service.exceptions.AbstractNotFoundException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;

public class DefaultRoleNotFoundException
extends AbstractNotFoundException {
    private final String scopes;

    public DefaultRoleNotFoundException(RoleScope ... scopes) {
        this.scopes = Arrays.stream(scopes).map(Enum::name).reduce((s, s2) -> s + ", " + s2).orElse("null");
    }

    @Override
    public String getMessage() {
        return "Default roles for scopes [" + this.scopes + "] can not be found.";
    }

    @Override
    public String getTechnicalCode() {
        return "role.default.notFound";
    }

    @Override
    public Map<String, String> getParameters() {
        return Collections.singletonMap("scopes", this.scopes);
    }
}

