/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl.validation;

import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.WorkflowState;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.NewApiEntity;
import io.gravitee.rest.api.model.v4.api.UpdateApiEntity;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.DefinitionVersionException;
import io.gravitee.rest.api.service.exceptions.InvalidDataException;
import io.gravitee.rest.api.service.exceptions.LifecycleStateChangeNotAllowedException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import io.gravitee.rest.api.service.v4.exception.ApiTypeException;
import io.gravitee.rest.api.service.v4.validation.ApiValidationService;
import io.gravitee.rest.api.service.v4.validation.EndpointGroupsValidationService;
import io.gravitee.rest.api.service.v4.validation.FlowValidationService;
import io.gravitee.rest.api.service.v4.validation.GroupValidationService;
import io.gravitee.rest.api.service.v4.validation.ListenerValidationService;
import io.gravitee.rest.api.service.v4.validation.ResourcesValidationService;
import io.gravitee.rest.api.service.v4.validation.TagsValidationService;
import org.springframework.stereotype.Component;

@Component
public class ApiValidationServiceImpl
extends TransactionalService
implements ApiValidationService {
    private final TagsValidationService tagsValidationService;
    private final GroupValidationService groupValidationService;
    private final ListenerValidationService listenerValidationService;
    private final EndpointGroupsValidationService endpointGroupsValidationService;
    private final FlowValidationService flowValidationService;
    private final ResourcesValidationService resourcesValidationService;

    public ApiValidationServiceImpl(TagsValidationService tagsValidationService, GroupValidationService groupValidationService, ListenerValidationService listenerValidationService, EndpointGroupsValidationService endpointGroupsValidationService, FlowValidationService flowValidationService, ResourcesValidationService resourcesValidationService) {
        this.tagsValidationService = tagsValidationService;
        this.groupValidationService = groupValidationService;
        this.listenerValidationService = listenerValidationService;
        this.endpointGroupsValidationService = endpointGroupsValidationService;
        this.flowValidationService = flowValidationService;
        this.resourcesValidationService = resourcesValidationService;
    }

    @Override
    public void validateAndSanitizeNewApi(ExecutionContext executionContext, NewApiEntity newApiEntity, PrimaryOwnerEntity currentPrimaryOwnerEntity) {
        this.validateDefinitionVersion(null, newApiEntity.getDefinitionVersion());
        this.validateApiType(null, newApiEntity.getType());
        newApiEntity.setTags(this.tagsValidationService.validateAndSanitize(executionContext, null, newApiEntity.getTags()));
        newApiEntity.setGroups(this.groupValidationService.validateAndSanitize(executionContext, null, newApiEntity.getGroups(), currentPrimaryOwnerEntity));
        newApiEntity.setListeners(this.listenerValidationService.validateAndSanitize(executionContext, null, newApiEntity.getListeners()));
        newApiEntity.setEndpointGroups(this.endpointGroupsValidationService.validateAndSanitize(newApiEntity.getEndpointGroups()));
        newApiEntity.setFlows(this.flowValidationService.validateAndSanitize(newApiEntity.getType(), newApiEntity.getFlows()));
    }

    @Override
    public void validateAndSanitizeUpdateApi(ExecutionContext executionContext, UpdateApiEntity updateApiEntity, PrimaryOwnerEntity primaryOwnerEntity, ApiEntity existingApiEntity) {
        this.validateDefinitionVersion(existingApiEntity.getDefinitionVersion(), updateApiEntity.getDefinitionVersion());
        this.validateApiType(existingApiEntity.getType(), updateApiEntity.getType());
        updateApiEntity.setLifecycleState(this.validateAndSanitizeLifecycleState(existingApiEntity, updateApiEntity));
        updateApiEntity.setTags(this.tagsValidationService.validateAndSanitize(executionContext, existingApiEntity.getTags(), updateApiEntity.getTags()));
        updateApiEntity.setGroups(this.groupValidationService.validateAndSanitize(executionContext, updateApiEntity.getId(), updateApiEntity.getGroups(), primaryOwnerEntity));
        updateApiEntity.setListeners(this.listenerValidationService.validateAndSanitize(executionContext, updateApiEntity.getId(), updateApiEntity.getListeners()));
        updateApiEntity.setEndpointGroups(this.endpointGroupsValidationService.validateAndSanitize(updateApiEntity.getEndpointGroups()));
        updateApiEntity.setFlows(this.flowValidationService.validateAndSanitize(updateApiEntity.getType(), updateApiEntity.getFlows()));
        updateApiEntity.setResources(this.resourcesValidationService.validateAndSanitize(updateApiEntity.getResources()));
    }

    private void validateDefinitionVersion(DefinitionVersion oldDefinitionVersion, DefinitionVersion newDefinitionVersion) {
        if (newDefinitionVersion != DefinitionVersion.V4) {
            throw new InvalidDataException("Definition version is unsupported, should be V4 or higher");
        }
        if (oldDefinitionVersion != null && oldDefinitionVersion.asInteger() > newDefinitionVersion.asInteger()) {
            throw new DefinitionVersionException();
        }
    }

    private void validateApiType(ApiType oldApiType, ApiType newApiType) {
        if (newApiType == null) {
            throw new InvalidDataException("ApiType cannot be null.");
        }
        if (oldApiType != null && oldApiType != newApiType) {
            throw new ApiTypeException();
        }
    }

    private ApiLifecycleState validateAndSanitizeLifecycleState(ApiEntity existingApiEntity, UpdateApiEntity updateApiEntity) {
        if (updateApiEntity.getLifecycleState() == null) {
            return existingApiEntity.getLifecycleState();
        }
        if (ApiLifecycleState.DEPRECATED == existingApiEntity.getLifecycleState()) {
            throw new LifecycleStateChangeNotAllowedException(updateApiEntity.getLifecycleState().name());
        }
        if (existingApiEntity.getLifecycleState() == updateApiEntity.getLifecycleState()) {
            return existingApiEntity.getLifecycleState();
        }
        if (ApiLifecycleState.ARCHIVED == existingApiEntity.getLifecycleState() && ApiLifecycleState.ARCHIVED != updateApiEntity.getLifecycleState() || ApiLifecycleState.UNPUBLISHED == existingApiEntity.getLifecycleState() && ApiLifecycleState.CREATED == updateApiEntity.getLifecycleState() || ApiLifecycleState.CREATED == existingApiEntity.getLifecycleState() && WorkflowState.IN_REVIEW == existingApiEntity.getWorkflowState()) {
            throw new LifecycleStateChangeNotAllowedException(updateApiEntity.getLifecycleState().name());
        }
        return updateApiEntity.getLifecycleState();
    }
}

