/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import io.gravitee.definition.model.DefinitionContext;
import io.gravitee.definition.model.Logging;
import io.gravitee.definition.model.LoggingMode;
import io.gravitee.definition.model.v4.listener.Listener;
import io.gravitee.definition.model.v4.listener.ListenerType;
import io.gravitee.definition.model.v4.listener.http.HttpListener;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiQualityRuleRepository;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Event;
import io.gravitee.repository.management.model.LifecycleState;
import io.gravitee.repository.management.model.NotificationReferenceType;
import io.gravitee.repository.management.model.flow.FlowReferenceType;
import io.gravitee.rest.api.model.EventType;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.MetadataFormat;
import io.gravitee.rest.api.model.NewApiMetadataEntity;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.WorkflowReferenceType;
import io.gravitee.rest.api.model.WorkflowState;
import io.gravitee.rest.api.model.WorkflowType;
import io.gravitee.rest.api.model.alert.AlertReferenceType;
import io.gravitee.rest.api.model.alert.AlertTriggerEntity;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.notification.GenericNotificationConfigEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.model.v4.api.NewApiEntity;
import io.gravitee.rest.api.model.v4.api.UpdateApiEntity;
import io.gravitee.rest.api.model.v4.plan.PlanEntity;
import io.gravitee.rest.api.service.AlertService;
import io.gravitee.rest.api.service.ApiMetadataService;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.EventService;
import io.gravitee.rest.api.service.GenericNotificationConfigService;
import io.gravitee.rest.api.service.MediaService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.PortalNotificationConfigService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.TopApiService;
import io.gravitee.rest.api.service.WorkflowService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.ApiNotDeletableException;
import io.gravitee.rest.api.service.exceptions.ApiNotFoundException;
import io.gravitee.rest.api.service.exceptions.ApiRunningStateException;
import io.gravitee.rest.api.service.exceptions.InvalidDataException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.notification.ApiHook;
import io.gravitee.rest.api.service.notification.HookScope;
import io.gravitee.rest.api.service.search.SearchEngineService;
import io.gravitee.rest.api.service.v4.ApiNotificationService;
import io.gravitee.rest.api.service.v4.ApiService;
import io.gravitee.rest.api.service.v4.FlowService;
import io.gravitee.rest.api.service.v4.PlanSearchService;
import io.gravitee.rest.api.service.v4.PlanService;
import io.gravitee.rest.api.service.v4.PrimaryOwnerService;
import io.gravitee.rest.api.service.v4.PropertiesService;
import io.gravitee.rest.api.service.v4.mapper.ApiMapper;
import io.gravitee.rest.api.service.v4.validation.ApiValidationService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="ApiServiceImplV4")
public class ApiServiceImpl
extends AbstractService
implements ApiService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiServiceImpl.class);
    private final ApiRepository apiRepository;
    private final ApiMapper apiMapper;
    private final PrimaryOwnerService primaryOwnerService;
    private final ApiValidationService apiValidationService;
    private final ParameterService parameterService;
    private final WorkflowService workflowService;
    private final AuditService auditService;
    private final MembershipService membershipService;
    private final GenericNotificationConfigService genericNotificationConfigService;
    private final ApiMetadataService apiMetadataService;
    private final FlowService flowService;
    private final SearchEngineService searchEngineService;
    private final PlanService planService;
    private final PlanSearchService planSearchService;
    private final SubscriptionService subscriptionService;
    private final EventService eventService;
    private final PageService pageService;
    private final TopApiService topApiService;
    private final PortalNotificationConfigService portalNotificationConfigService;
    private final AlertService alertService;
    private final ApiQualityRuleRepository apiQualityRuleRepository;
    private final MediaService mediaService;
    private final PropertiesService propertiesService;
    private final ApiNotificationService apiNotificationService;

    public ApiServiceImpl(@Lazy ApiRepository apiRepository, ApiMapper apiMapper, PrimaryOwnerService primaryOwnerService, ApiValidationService apiValidationService, ParameterService parameterService, WorkflowService workflowService, AuditService auditService, MembershipService membershipService, GenericNotificationConfigService genericNotificationConfigService, @Lazy ApiMetadataService apiMetadataService, FlowService flowService, @Lazy SearchEngineService searchEngineService, PlanService planService, PlanSearchService planSearchService, @Lazy SubscriptionService subscriptionService, EventService eventService, @Lazy PageService pageService, @Lazy TopApiService topApiService, PortalNotificationConfigService portalNotificationConfigService, @Lazy AlertService alertService, @Lazy ApiQualityRuleRepository apiQualityRuleRepository, MediaService mediaService, PropertiesService propertiesService, ApiNotificationService apiNotificationService) {
        this.apiRepository = apiRepository;
        this.apiMapper = apiMapper;
        this.primaryOwnerService = primaryOwnerService;
        this.apiValidationService = apiValidationService;
        this.parameterService = parameterService;
        this.workflowService = workflowService;
        this.auditService = auditService;
        this.membershipService = membershipService;
        this.genericNotificationConfigService = genericNotificationConfigService;
        this.apiMetadataService = apiMetadataService;
        this.flowService = flowService;
        this.searchEngineService = searchEngineService;
        this.planService = planService;
        this.planSearchService = planSearchService;
        this.subscriptionService = subscriptionService;
        this.eventService = eventService;
        this.pageService = pageService;
        this.topApiService = topApiService;
        this.portalNotificationConfigService = portalNotificationConfigService;
        this.alertService = alertService;
        this.apiQualityRuleRepository = apiQualityRuleRepository;
        this.mediaService = mediaService;
        this.propertiesService = propertiesService;
        this.apiNotificationService = apiNotificationService;
    }

    @Override
    public ApiEntity create(ExecutionContext executionContext, NewApiEntity newApiEntity, String userId) {
        try {
            PrimaryOwnerEntity primaryOwner = this.primaryOwnerService.getPrimaryOwner(executionContext, userId, null);
            this.apiValidationService.validateAndSanitizeNewApi(executionContext, newApiEntity, primaryOwner);
            Api repositoryApi = this.apiMapper.toRepository(executionContext, newApiEntity);
            repositoryApi.setApiLifecycleState(io.gravitee.repository.management.model.ApiLifecycleState.CREATED);
            if (this.parameterService.findAsBoolean(executionContext, Key.API_REVIEW_ENABLED, ParameterReferenceType.ENVIRONMENT)) {
                this.workflowService.create(WorkflowReferenceType.API, repositoryApi.getId(), WorkflowType.REVIEW, userId, WorkflowState.DRAFT, "");
            }
            Api createdApi = (Api)this.apiRepository.create((Object)repositoryApi);
            this.auditService.createApiAuditLog(executionContext, createdApi.getId(), Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_CREATED, createdApi.getCreatedAt(), null, createdApi);
            this.membershipService.addRoleToMemberOnReference(executionContext, new MembershipService.MembershipReference(MembershipReferenceType.API, createdApi.getId()), new MembershipService.MembershipMember(primaryOwner.getId(), null, MembershipMemberType.valueOf((String)primaryOwner.getType())), new MembershipService.MembershipRole(RoleScope.API, SystemRole.PRIMARY_OWNER.name()));
            String emailMetadataValue = "${(api.primaryOwner.email)!''}";
            GenericNotificationConfigEntity notificationConfigEntity = new GenericNotificationConfigEntity();
            notificationConfigEntity.setName("Default Mail Notifications");
            notificationConfigEntity.setReferenceType(HookScope.API.name());
            notificationConfigEntity.setReferenceId(createdApi.getId());
            notificationConfigEntity.setHooks(Arrays.stream(ApiHook.values()).map(Enum::name).collect(Collectors.toList()));
            notificationConfigEntity.setNotifier("default-email");
            notificationConfigEntity.setConfig("${(api.primaryOwner.email)!''}");
            this.genericNotificationConfigService.create(notificationConfigEntity);
            NewApiMetadataEntity newApiMetadataEntity = new NewApiMetadataEntity();
            newApiMetadataEntity.setFormat(MetadataFormat.MAIL);
            newApiMetadataEntity.setName("email-support");
            newApiMetadataEntity.setDefaultValue("${(api.primaryOwner.email)!''}");
            newApiMetadataEntity.setValue("${(api.primaryOwner.email)!''}");
            newApiMetadataEntity.setApiId(createdApi.getId());
            this.apiMetadataService.create(executionContext, newApiMetadataEntity);
            this.flowService.save(FlowReferenceType.API, createdApi.getId(), newApiEntity.getFlows());
            ApiEntity apiEntity = this.apiMapper.toEntity(executionContext, createdApi, primaryOwner, null, true);
            GenericApiEntity apiWithMetadata = this.apiMetadataService.fetchMetadataForApi(executionContext, (GenericApiEntity)apiEntity);
            this.searchEngineService.index(executionContext, (Indexable)apiWithMetadata, false);
            return apiEntity;
        }
        catch (TechnicalException | IllegalStateException ex) {
            String errorMsg = String.format("An error occurs while trying to create '%s' for user '%s'", newApiEntity, userId);
            log.error(errorMsg, ex);
            throw new TechnicalManagementException(errorMsg, ex);
        }
    }

    @Override
    public ApiEntity update(ExecutionContext executionContext, String apiId, UpdateApiEntity api, String userId) {
        return this.update(executionContext, apiId, api, false, userId);
    }

    @Override
    public ApiEntity update(ExecutionContext executionContext, String apiId, UpdateApiEntity updateApiEntity, boolean checkPlans, String userId) {
        try {
            PrimaryOwnerEntity primaryOwner = this.primaryOwnerService.getPrimaryOwner(executionContext, userId, null);
            Api apiToUpdate = (Api)this.apiRepository.findById((Object)apiId).orElseThrow(() -> new ApiNotFoundException(apiId));
            ApiEntity existingApiEntity = this.apiMapper.toEntity(executionContext, apiToUpdate, primaryOwner, null, false);
            this.apiValidationService.validateAndSanitizeUpdateApi(executionContext, updateApiEntity, primaryOwner, existingApiEntity);
            if (updateApiEntity.getPlans() == null) {
                updateApiEntity.setPlans(new HashSet());
            } else if (checkPlans) {
                Set existingPlans = existingApiEntity.getPlans();
                HashMap<String, PlanStatus> planStatuses = new HashMap<String, PlanStatus>();
                if (existingPlans != null && !existingPlans.isEmpty()) {
                    planStatuses.putAll(existingPlans.stream().collect(Collectors.toMap(PlanEntity::getId, PlanEntity::getStatus)));
                }
                updateApiEntity.getPlans().forEach(planToUpdate -> {
                    if (!planStatuses.containsKey(planToUpdate.getId()) || planStatuses.containsKey(planToUpdate.getId()) && planStatuses.get(planToUpdate.getId()) == PlanStatus.CLOSED && planStatuses.get(planToUpdate.getId()) != planToUpdate.getStatus()) {
                        throw new InvalidDataException("Invalid status for plan '" + planToUpdate.getName() + "'");
                    }
                });
            }
            this.propertiesService.encryptProperties(updateApiEntity.getProperties());
            if (ApiLifecycleState.DEPRECATED == updateApiEntity.getLifecycleState()) {
                this.planSearchService.findByApi(executionContext, apiId).forEach(plan -> {
                    if (PlanStatus.PUBLISHED == plan.getPlanStatus() || PlanStatus.STAGING == plan.getPlanStatus()) {
                        this.planService.deprecate(executionContext, plan.getId(), true);
                        updateApiEntity.getPlans().stream().filter(p -> p.getId().equals(plan.getId())).forEach(p -> p.setStatus(PlanStatus.DEPRECATED));
                    }
                });
            }
            Api api = this.apiMapper.toRepository(executionContext, updateApiEntity);
            api.setEnvironmentId(apiToUpdate.getEnvironmentId());
            api.setDeployedAt(apiToUpdate.getDeployedAt());
            api.setCreatedAt(apiToUpdate.getCreatedAt());
            api.setLifecycleState(apiToUpdate.getLifecycleState());
            if (updateApiEntity.getCrossId() == null) {
                api.setCrossId(apiToUpdate.getCrossId());
            }
            if (updateApiEntity.getPicture() == null && updateApiEntity.getPictureUrl() != null && updateApiEntity.getPictureUrl().indexOf("?hash") > 0) {
                api.setPicture(apiToUpdate.getPicture());
            }
            if (updateApiEntity.getBackground() == null && updateApiEntity.getBackgroundUrl() != null && updateApiEntity.getBackgroundUrl().indexOf("?hash") > 0) {
                api.setBackground(apiToUpdate.getBackground());
            }
            if (updateApiEntity.getGroups() == null) {
                api.setGroups(apiToUpdate.getGroups());
            }
            if (updateApiEntity.getLabels() == null && apiToUpdate.getLabels() != null) {
                api.setLabels(new ArrayList(new HashSet(apiToUpdate.getLabels())));
            }
            if (updateApiEntity.getCategories() == null) {
                api.setCategories(apiToUpdate.getCategories());
            }
            if (io.gravitee.repository.management.model.ApiLifecycleState.DEPRECATED.equals((Object)api.getApiLifecycleState())) {
                GenericApiEntity apiWithMetadata = this.apiMetadataService.fetchMetadataForApi(executionContext, (GenericApiEntity)existingApiEntity);
                this.apiNotificationService.triggerDeprecatedNotification(executionContext, apiWithMetadata);
            }
            Api updatedApi = (Api)this.apiRepository.update((Object)api);
            this.flowService.save(FlowReferenceType.API, api.getId(), updateApiEntity.getFlows());
            updateApiEntity.getPlans().forEach(plan -> {
                plan.setApiId(api.getId());
                this.planService.createOrUpdatePlan(executionContext, (PlanEntity)plan);
            });
            this.auditService.createApiAuditLog(executionContext, updatedApi.getId(), Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_UPDATED, updatedApi.getUpdatedAt(), apiToUpdate, updatedApi);
            if (this.parameterService.findAsBoolean(executionContext, Key.LOGGING_AUDIT_TRAIL_ENABLED, ParameterReferenceType.ENVIRONMENT)) {
                Optional<Listener> firstUpdateHttpListener = updateApiEntity.getListeners().stream().filter(listener -> ListenerType.HTTP == listener.getType()).findFirst();
                Optional<Listener> firstExistingHttpListener = existingApiEntity.getListeners().stream().filter(listener -> ListenerType.HTTP == listener.getType()).findFirst();
                if (firstUpdateHttpListener.isPresent() && firstExistingHttpListener.isPresent()) {
                    HttpListener updateHttpListener = (HttpListener)firstUpdateHttpListener.get();
                    HttpListener existingHttpListener = (HttpListener)firstExistingHttpListener.get();
                    this.auditApiLogging(executionContext, updateApiEntity.getId(), existingHttpListener.getLogging(), updateHttpListener.getLogging());
                }
            }
            ApiEntity apiEntity = this.apiMapper.toEntity(executionContext, updatedApi, primaryOwner, null, true);
            GenericApiEntity apiWithMetadata = this.apiMetadataService.fetchMetadataForApi(executionContext, (GenericApiEntity)apiEntity);
            this.apiNotificationService.triggerUpdateNotification(executionContext, apiWithMetadata);
            this.searchEngineService.index(executionContext, (Indexable)apiWithMetadata, false);
            return apiEntity;
        }
        catch (TechnicalException ex) {
            String errorMsg = String.format("An error occurs while trying to update API '%s'", apiId);
            log.error(errorMsg, (Object)apiId, (Object)ex);
            throw new TechnicalManagementException(errorMsg, ex);
        }
    }

    @Override
    public void delete(ExecutionContext executionContext, String apiId, boolean closePlans) {
        try {
            Set<String> plansNotClosed;
            log.debug("Delete API {}", (Object)apiId);
            Api api = (Api)this.apiRepository.findById((Object)apiId).orElseThrow(() -> new ApiNotFoundException(apiId));
            if (DefinitionContext.isManagement((String)api.getOrigin()) && api.getLifecycleState() == LifecycleState.STARTED) {
                throw new ApiRunningStateException(apiId);
            }
            Set<Object> plans = this.planService.findByApi(executionContext, apiId);
            if (closePlans) {
                plans = plans.stream().filter(plan -> plan.getStatus() != PlanStatus.CLOSED).map(plan -> this.planService.close(executionContext, plan.getId())).collect(Collectors.toSet());
            }
            if (!(plansNotClosed = plans.stream().filter(plan -> plan.getStatus() == PlanStatus.PUBLISHED).map(PlanEntity::getName).collect(Collectors.toSet())).isEmpty()) {
                throw new ApiNotDeletableException(plansNotClosed);
            }
            Collection<SubscriptionEntity> subscriptions = this.subscriptionService.findByApi(executionContext, apiId);
            subscriptions.forEach(sub -> this.subscriptionService.delete(executionContext, sub.getId()));
            plans.forEach(plan -> this.planService.delete(executionContext, plan.getId()));
            this.flowService.save(FlowReferenceType.API, apiId, null);
            this.eventService.deleteApiEvents(apiId);
            HashMap<String, String> properties = new HashMap<String, String>(2);
            properties.put(Event.EventProperties.API_ID.getValue(), apiId);
            if (this.getAuthenticatedUser() != null) {
                properties.put(Event.EventProperties.USER.getValue(), this.getAuthenticatedUser().getUsername());
            }
            this.eventService.createApiEvent(executionContext, Collections.singleton(executionContext.getEnvironmentId()), EventType.UNPUBLISH_API, null, properties);
            this.pageService.deleteAllByApi(executionContext, apiId);
            this.topApiService.delete(executionContext, apiId);
            this.apiRepository.delete((Object)apiId);
            this.membershipService.deleteReference(executionContext, MembershipReferenceType.API, apiId);
            this.genericNotificationConfigService.deleteReference(NotificationReferenceType.API, apiId);
            this.portalNotificationConfigService.deleteReference(NotificationReferenceType.API, apiId);
            List<AlertTriggerEntity> alerts = this.alertService.findByReferenceWithEventCounts(AlertReferenceType.API, apiId);
            alerts.forEach(alert -> this.alertService.delete(alert.getId(), alert.getReferenceId()));
            this.apiQualityRuleRepository.deleteByApi(apiId);
            this.auditService.createApiAuditLog(executionContext, apiId, Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_DELETED, new Date(), api, null);
            this.searchEngineService.delete(executionContext, (Indexable)this.apiMapper.toEntity(executionContext, api, null, null, false));
            this.mediaService.deleteAllByApi(apiId);
            this.apiMetadataService.deleteAllByApi(executionContext, apiId);
        }
        catch (TechnicalException ex) {
            throw new TechnicalManagementException("An error occurs while trying to delete API " + apiId, ex);
        }
    }

    private void auditApiLogging(ExecutionContext executionContext, String apiId, Logging loggingToUpdate, Logging loggingUpdated) {
        try {
            if (loggingToUpdate == loggingUpdated || loggingToUpdate != null && loggingUpdated != null && Objects.equals(loggingToUpdate.getMode(), loggingUpdated.getMode()) && Objects.equals(loggingToUpdate.getCondition(), loggingUpdated.getCondition())) {
                return;
            }
            Api.AuditEvent auditEvent = (loggingToUpdate == null || loggingToUpdate.getMode().equals((Object)LoggingMode.NONE)) && loggingUpdated != null && !loggingUpdated.getMode().equals((Object)LoggingMode.NONE) ? Api.AuditEvent.API_LOGGING_ENABLED : (loggingToUpdate != null && !loggingToUpdate.getMode().equals((Object)LoggingMode.NONE) && (loggingUpdated == null || loggingUpdated.getMode().equals((Object)LoggingMode.NONE)) ? Api.AuditEvent.API_LOGGING_DISABLED : Api.AuditEvent.API_LOGGING_UPDATED);
            this.auditService.createApiAuditLog(executionContext, apiId, Collections.emptyMap(), (Audit.AuditEvent)auditEvent, new Date(), loggingToUpdate, loggingUpdated);
        }
        catch (Exception ex) {
            String errorMsg = String.format("An error occurs while auditing API logging configuration for API:  %s", apiId);
            log.error(errorMsg, (Object)apiId, (Object)ex);
            throw new TechnicalManagementException(errorMsg, ex);
        }
    }
}

