/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import io.gravitee.gateway.jupiter.api.connector.ConnectorFactory;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.entrypoint.EntrypointConnectorPlugin;
import io.gravitee.plugin.entrypoint.EntrypointConnectorPluginManager;
import io.gravitee.rest.api.service.JsonSchemaService;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.v4.EntrypointConnectorPluginService;
import io.gravitee.rest.api.service.v4.impl.AbstractConnectorPluginService;
import java.io.IOException;
import org.springframework.stereotype.Component;

@Component(value="EntrypointPluginServiceImplV4")
public class EntrypointConnectorPluginServiceImpl
extends AbstractConnectorPluginService<EntrypointConnectorPlugin<?, ?>>
implements EntrypointConnectorPluginService {
    public EntrypointConnectorPluginServiceImpl(JsonSchemaService jsonSchemaService, ConfigurablePluginManager<EntrypointConnectorPlugin<?, ?>> pluginManager) {
        super(jsonSchemaService, pluginManager);
    }

    @Override
    protected ConnectorFactory<?> getConnectorFactory(String connectorId) {
        return ((EntrypointConnectorPluginManager)this.pluginManager).getFactoryById(connectorId);
    }

    @Override
    public String getSubscriptionSchema(String connectorId) {
        try {
            this.logger.debug("Find entrypoint subscription schema by ID: {}", (Object)connectorId);
            return ((EntrypointConnectorPluginManager)this.pluginManager).getSubscriptionSchema(connectorId);
        }
        catch (IOException ioex) {
            this.logger.error("An error occurs while trying to get entrypoint subscription schema for plugin {}", (Object)connectorId, (Object)ioex);
            throw new TechnicalManagementException("An error occurs while trying to get entrypoint subscription schema for plugin " + connectorId, ioex);
        }
    }

    @Override
    public String validateEntrypointSubscriptionConfiguration(String entrypointId, String configuration) {
        this.findById(entrypointId);
        return this.validateSubscriptionConfiguration(entrypointId, configuration);
    }

    private String validateSubscriptionConfiguration(String pluginId, String configuration) {
        if (pluginId != null && configuration != null) {
            String schema = this.getSubscriptionSchema(pluginId);
            return this.jsonSchemaService.validate(schema, configuration);
        }
        return configuration;
    }
}

