/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.data.domain.Page;
import io.gravitee.definition.model.Api;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.debug.DebugApi;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.EventRepository;
import io.gravitee.repository.management.api.search.EventCriteria;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.Dictionary;
import io.gravitee.repository.management.model.Event;
import io.gravitee.repository.management.model.EventType;
import io.gravitee.repository.management.model.flow.FlowReferenceType;
import io.gravitee.rest.api.model.EventEntity;
import io.gravitee.rest.api.model.EventQuery;
import io.gravitee.rest.api.model.NewEventEntity;
import io.gravitee.rest.api.model.OrganizationEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.v4.plan.PlanEntity;
import io.gravitee.rest.api.service.EventService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.converter.PlanConverter;
import io.gravitee.rest.api.service.exceptions.EventNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.exceptions.UserNotFoundException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import io.gravitee.rest.api.service.v4.FlowService;
import io.gravitee.rest.api.service.v4.mapper.PlanMapper;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class EventServiceImpl
extends TransactionalService
implements EventService {
    private final Logger LOGGER = LoggerFactory.getLogger(EventServiceImpl.class);
    @Lazy
    @Autowired
    private EventRepository eventRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private PlanService planService;
    @Autowired
    private io.gravitee.rest.api.service.v4.PlanService planServiceV4;
    @Autowired
    private io.gravitee.rest.api.service.configuration.flow.FlowService flowService;
    @Autowired
    private PlanMapper planMapper;
    @Autowired
    private FlowService flowServiceV4;
    @Autowired
    private PlanConverter planConverter;
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public EventEntity findById(ExecutionContext executionContext, String id) {
        try {
            this.LOGGER.debug("Find event by ID: {}", (Object)id);
            Optional event = this.eventRepository.findById((Object)id);
            if (event.isPresent()) {
                return this.convert(executionContext, (Event)event.get());
            }
            throw new EventNotFoundException(id);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find an event using its ID {}", (Object)id, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find an event using its ID " + id, ex);
        }
    }

    @Override
    public EventEntity createApiEvent(ExecutionContext executionContext, Set<String> environmentsIds, io.gravitee.rest.api.model.EventType type, io.gravitee.repository.management.model.Api api, Map<String, String> properties) {
        io.gravitee.repository.management.model.Api apiDefinition = api != null ? this.buildApiEventPayload(executionContext, api) : null;
        return this.createEvent(executionContext, environmentsIds, type, apiDefinition, properties);
    }

    @Override
    public EventEntity createDebugApiEvent(ExecutionContext executionContext, Set<String> environmentsIds, io.gravitee.rest.api.model.EventType type, DebugApi debugApi, Map<String, String> properties) {
        return this.createEvent(executionContext, environmentsIds, type, debugApi, properties);
    }

    @Override
    public EventEntity createDictionaryEvent(ExecutionContext executionContext, Set<String> environmentsIds, io.gravitee.rest.api.model.EventType type, Dictionary dictionary, Map<String, String> properties) {
        return this.createEvent(executionContext, environmentsIds, type, dictionary, properties);
    }

    @Override
    public EventEntity createOrganizationEvent(ExecutionContext executionContext, Set<String> environmentsIds, io.gravitee.rest.api.model.EventType type, OrganizationEntity organization, Map<String, String> properties) {
        return this.createEvent(executionContext, environmentsIds, type, organization, properties);
    }

    private EventEntity createEvent(ExecutionContext executionContext, Set<String> environmentsIds, io.gravitee.rest.api.model.EventType type, Object object, Map<String, String> properties) {
        try {
            String payload = object != null ? this.objectMapper.writeValueAsString(object) : null;
            NewEventEntity event = NewEventEntity.builder().type(type).payload(payload).properties(properties).build();
            return this.createNewEventEntity(executionContext, environmentsIds, event);
        }
        catch (JsonProcessingException e) {
            throw new TechnicalManagementException(String.format("Failed to create event [%s]", type), e);
        }
    }

    protected EventEntity createNewEventEntity(ExecutionContext executionContext, Set<String> environmentsIds, NewEventEntity newEventEntity) {
        String hostAddress = "";
        try {
            hostAddress = InetAddress.getLocalHost().getHostAddress();
            this.LOGGER.debug("Create {} for server {}", (Object)newEventEntity, (Object)hostAddress);
            Event event = this.convert(newEventEntity);
            event.setId(UuidString.generateRandom());
            event.setEnvironments(environmentsIds);
            event.getProperties().put(Event.EventProperties.ORIGIN.getValue(), hostAddress);
            event.setCreatedAt(new Date());
            event.setUpdatedAt(event.getCreatedAt());
            Event createdEvent = (Event)this.eventRepository.create((Object)event);
            return this.convert(executionContext, createdEvent);
        }
        catch (UnknownHostException e) {
            this.LOGGER.error("An error occurs while getting the server IP address", (Throwable)e);
            throw new TechnicalManagementException("An error occurs while getting the server IP address", e);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create {} for server {}", new Object[]{newEventEntity, hostAddress, ex});
            throw new TechnicalManagementException("An error occurs while trying create " + newEventEntity + " for server " + hostAddress, ex);
        }
    }

    @Override
    public void delete(String eventId) {
        try {
            this.LOGGER.debug("Delete Event {}", (Object)eventId);
            this.eventRepository.delete((Object)eventId);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete Event {}", (Object)eventId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete Event " + eventId, ex);
        }
    }

    @Override
    public void deleteApiEvents(String apiId) {
        try {
            this.LOGGER.debug("Delete Events for API {}", (Object)apiId);
            long deleteApiEvents = this.eventRepository.deleteApiEvents(apiId);
            this.LOGGER.debug("{} events deleted for API {}", (Object)deleteApiEvents, (Object)apiId);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete Events for API {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete Events for API " + apiId, ex);
        }
    }

    @Override
    public Page<EventEntity> search(ExecutionContext executionContext, List<io.gravitee.rest.api.model.EventType> eventTypes, Map<String, Object> properties, Long from, Long to, int page, int size, List<String> environmentsIds) {
        EventCriteria.Builder builder = new EventCriteria.Builder();
        if (from != null) {
            builder.from(from.longValue());
        }
        if (to != null) {
            builder.to(to.longValue());
        }
        if (eventTypes != null) {
            EventType[] eventTypesArr = (EventType[])eventTypes.stream().map(eventType -> EventType.valueOf((String)eventType.toString())).toArray(EventType[]::new);
            builder.types(eventTypesArr);
        }
        if (properties != null) {
            properties.forEach((arg_0, arg_1) -> ((EventCriteria.Builder)builder).property(arg_0, arg_1));
        }
        builder.environments(environmentsIds);
        Page pageEvent = this.eventRepository.search(builder.build(), new PageableBuilder().pageNumber(page).pageSize(size).build());
        List content = pageEvent.getContent().stream().map(event -> this.convert(executionContext, (Event)event)).collect(Collectors.toList());
        return new Page(content, pageEvent.getPageNumber(), (int)pageEvent.getPageElements(), pageEvent.getTotalElements());
    }

    @Override
    public Collection<EventEntity> search(ExecutionContext executionContext, EventQuery query) {
        this.LOGGER.debug("Search APIs by {}", (Object)query);
        return this.convert(executionContext, this.eventRepository.search(this.queryToCriteria(executionContext, query).build()));
    }

    private EventCriteria.Builder queryToCriteria(ExecutionContext executionContext, EventQuery query) {
        EventCriteria.Builder builder = new EventCriteria.Builder().environments(Collections.singletonList(executionContext.getEnvironmentId()));
        if (query == null) {
            return builder;
        }
        builder.from(query.getFrom()).to(query.getTo());
        if (!CollectionUtils.isEmpty((Collection)query.getTypes())) {
            query.getTypes().forEach(eventType -> builder.types(new EventType[]{EventType.valueOf((String)eventType.name())}));
        }
        if (!CollectionUtils.isEmpty((Map)query.getProperties())) {
            query.getProperties().forEach((arg_0, arg_1) -> ((EventCriteria.Builder)builder).property(arg_0, arg_1));
        }
        if (!StringUtils.isBlank((CharSequence)query.getApi())) {
            builder.property(Event.EventProperties.API_ID.getValue(), (Object)query.getApi());
        }
        if (!StringUtils.isBlank((CharSequence)query.getId())) {
            builder.property(Event.EventProperties.ID.getValue(), (Object)query.getId());
        }
        return builder;
    }

    private Set<EventEntity> convert(ExecutionContext executionContext, List<Event> events) {
        return events.stream().map(event -> this.convert(executionContext, (Event)event)).collect(Collectors.toSet());
    }

    private EventEntity convert(ExecutionContext executionContext, Event event) {
        String userId;
        EventEntity eventEntity = new EventEntity();
        eventEntity.setId(event.getId());
        eventEntity.setType(io.gravitee.rest.api.model.EventType.valueOf((String)event.getType().toString()));
        eventEntity.setPayload(event.getPayload());
        eventEntity.setParentId(event.getParentId());
        eventEntity.setProperties(event.getProperties());
        eventEntity.setCreatedAt(event.getCreatedAt());
        eventEntity.setUpdatedAt(event.getUpdatedAt());
        eventEntity.setEnvironments(event.getEnvironments());
        if (event.getProperties() != null && (userId = (String)event.getProperties().get(Event.EventProperties.USER.getValue())) != null && !userId.isEmpty()) {
            try {
                eventEntity.setUser(this.userService.findById(executionContext, userId));
            }
            catch (UserNotFoundException unfe) {
                UserEntity user = new UserEntity();
                user.setSource("system");
                user.setId(userId);
                eventEntity.setUser(user);
            }
        }
        return eventEntity;
    }

    private Event convert(NewEventEntity newEventEntity) {
        Event event = new Event();
        event.setType(EventType.valueOf((String)newEventEntity.getType().toString()));
        event.setPayload(newEventEntity.getPayload());
        event.setParentId(newEventEntity.getParentId());
        event.setProperties(new HashMap(newEventEntity.getProperties()));
        return event;
    }

    private io.gravitee.repository.management.model.Api buildApiEventPayload(ExecutionContext executionContext, io.gravitee.repository.management.model.Api api) {
        try {
            io.gravitee.repository.management.model.Api apiForGatewayEvent = new io.gravitee.repository.management.model.Api(api);
            if (api.getDefinitionVersion() == null || !api.getDefinitionVersion().equals((Object)DefinitionVersion.V4)) {
                apiForGatewayEvent.setDefinition(this.objectMapper.writeValueAsString((Object)this.buildGatewayApiDefinition(executionContext, api)));
            } else {
                apiForGatewayEvent.setDefinition(this.objectMapper.writeValueAsString((Object)this.buildGatewayApiDefinitionV4(executionContext, api)));
            }
            return apiForGatewayEvent;
        }
        catch (JsonProcessingException e) {
            throw new TechnicalManagementException(String.format("Failed to build API [%s] definition for gateway event", api.getId()), e);
        }
    }

    private Api buildGatewayApiDefinition(ExecutionContext executionContext, io.gravitee.repository.management.model.Api api) throws JsonProcessingException {
        Api apiDefinition = (Api)this.objectMapper.readValue(api.getDefinition(), Api.class);
        Set<io.gravitee.rest.api.model.PlanEntity> plans = this.planService.findByApi(executionContext, api.getId()).stream().filter(p -> p.getStatus() != io.gravitee.rest.api.model.PlanStatus.CLOSED).collect(Collectors.toSet());
        apiDefinition.setPlans(this.planConverter.toPlansDefinitions(plans));
        apiDefinition.setFlows(this.flowService.findByReference(FlowReferenceType.API, api.getId()));
        return apiDefinition;
    }

    private io.gravitee.definition.model.v4.Api buildGatewayApiDefinitionV4(ExecutionContext executionContext, io.gravitee.repository.management.model.Api api) throws JsonProcessingException {
        io.gravitee.definition.model.v4.Api apiDefinitionV4 = (io.gravitee.definition.model.v4.Api)this.objectMapper.readValue(api.getDefinition(), io.gravitee.definition.model.v4.Api.class);
        Set<PlanEntity> plans = this.planServiceV4.findByApi(executionContext, api.getId()).stream().filter(p -> p.getPlanStatus() != PlanStatus.CLOSED).collect(Collectors.toSet());
        apiDefinitionV4.setPlans(this.planMapper.toDefinitions(plans));
        apiDefinitionV4.setFlows(this.flowServiceV4.findByReference(FlowReferenceType.API, api.getId()));
        return apiDefinitionV4;
    }
}

