/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jsonpatch.diff.JsonDiff;
import io.gravitee.common.data.domain.MetadataPage;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.ApplicationRepository;
import io.gravitee.repository.management.api.AuditRepository;
import io.gravitee.repository.management.api.EnvironmentRepository;
import io.gravitee.repository.management.api.GroupRepository;
import io.gravitee.repository.management.api.MetadataRepository;
import io.gravitee.repository.management.api.OrganizationRepository;
import io.gravitee.repository.management.api.PageRepository;
import io.gravitee.repository.management.api.PlanRepository;
import io.gravitee.repository.management.api.search.AuditCriteria;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Application;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Environment;
import io.gravitee.repository.management.model.Group;
import io.gravitee.repository.management.model.Metadata;
import io.gravitee.repository.management.model.MetadataReferenceType;
import io.gravitee.repository.management.model.Organization;
import io.gravitee.repository.management.model.Page;
import io.gravitee.repository.management.model.Plan;
import io.gravitee.rest.api.idp.api.authentication.UserDetails;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.audit.AuditEntity;
import io.gravitee.rest.api.model.audit.AuditQuery;
import io.gravitee.rest.api.model.audit.AuditReferenceType;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.PermissionService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.exceptions.UserNotFoundException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.impl.MetadataServiceImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class AuditServiceImpl
extends AbstractService
implements AuditService {
    private final Logger LOGGER = LoggerFactory.getLogger(AuditServiceImpl.class);
    private static final Map<Audit.AuditReferenceType, AuditReferenceType> AUDIT_REFERENCE_TYPE_AUDIT_REFERENCE_TYPE_MAP = Map.ofEntries(Map.entry(Audit.AuditReferenceType.ORGANIZATION, AuditReferenceType.ORGANIZATION), Map.entry(Audit.AuditReferenceType.ENVIRONMENT, AuditReferenceType.ENVIRONMENT), Map.entry(Audit.AuditReferenceType.APPLICATION, AuditReferenceType.APPLICATION), Map.entry(Audit.AuditReferenceType.API, AuditReferenceType.API));
    @Lazy
    @Autowired
    private AuditRepository auditRepository;
    @Lazy
    @Autowired
    private PageRepository pageRepository;
    @Lazy
    @Autowired
    private PlanRepository planRepository;
    @Lazy
    @Autowired
    private MetadataRepository metadataRepository;
    @Lazy
    @Autowired
    private GroupRepository groupRepository;
    @Lazy
    @Autowired
    private ApiRepository apiRepository;
    @Lazy
    @Autowired
    private EnvironmentRepository environmentRepository;
    @Lazy
    @Autowired
    private OrganizationRepository organizationRepository;
    @Lazy
    @Autowired
    private ApplicationRepository applicationRepository;
    @Autowired
    @Lazy
    private UserService userService;
    @Autowired
    @Lazy
    private PermissionService permissionService;
    @Autowired
    private ObjectMapper mapper;

    @Override
    public MetadataPage<AuditEntity> search(ExecutionContext executionContext, AuditQuery query) {
        AuditCriteria.Builder criteria = new AuditCriteria.Builder().from(query.getFrom()).to(query.getTo());
        criteria.organizationId(executionContext.getOrganizationId());
        if (executionContext.hasEnvironmentId()) {
            criteria.environmentIds(Collections.singletonList(executionContext.getEnvironmentId()));
        }
        if (this.permissionService.hasPermission(executionContext, RolePermission.ORGANIZATION_AUDIT, executionContext.getOrganizationId(), RolePermissionAction.READ) && query.getReferenceType() != null && query.getReferenceType().equals((Object)AuditReferenceType.ORGANIZATION)) {
            criteria.references(Audit.AuditReferenceType.ORGANIZATION, null);
        } else if (query.getEnvironmentIds() != null && !query.getEnvironmentIds().isEmpty() || query.getReferenceType() != null && query.getReferenceType().equals((Object)AuditReferenceType.ENVIRONMENT)) {
            criteria.references(Audit.AuditReferenceType.ENVIRONMENT, query.getEnvironmentIds());
        } else if (query.getApplicationIds() != null && !query.getApplicationIds().isEmpty() || query.getReferenceType() != null && query.getReferenceType().equals((Object)AuditReferenceType.APPLICATION)) {
            criteria.references(Audit.AuditReferenceType.APPLICATION, query.getApplicationIds());
        } else if (query.getApiIds() != null && !query.getApiIds().isEmpty() || query.getReferenceType() != null && query.getReferenceType().equals((Object)AuditReferenceType.API)) {
            criteria.references(Audit.AuditReferenceType.API, query.getApiIds());
        }
        if (query.getEvents() != null && !query.getEvents().isEmpty()) {
            criteria.events(query.getEvents());
        }
        io.gravitee.common.data.domain.Page auditPage = this.auditRepository.search(criteria.build(), new PageableBuilder().pageNumber(query.getPage() - 1).pageSize(query.getSize()).build());
        List<AuditEntity> content = auditPage.getContent().stream().map(this::convert).collect(Collectors.toList());
        return new MetadataPage(content, query.getPage(), query.getSize(), auditPage.getTotalElements(), this.getMetadata(executionContext, content));
    }

    private Map<String, String> getMetadata(ExecutionContext executionContext, List<AuditEntity> content) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        for (AuditEntity auditEntity : content) {
            Object metadataKey = "USER:" + auditEntity.getUser() + ":name";
            try {
                UserEntity user = this.userService.findById(executionContext, auditEntity.getUser());
                metadata.put((String)metadataKey, user.getDisplayName());
            }
            catch (TechnicalManagementException e) {
                this.LOGGER.error("Error finding metadata {}", (Object)auditEntity.getUser());
            }
            catch (UserNotFoundException unfe) {
                metadata.put((String)metadataKey, auditEntity.getUser());
            }
            if (Audit.AuditReferenceType.ORGANIZATION.name().equals(auditEntity.getReferenceType().name())) {
                metadataKey = "ORGANIZATION:" + auditEntity.getReferenceId() + ":name";
                if (!metadata.containsKey(metadataKey)) {
                    try {
                        Optional optOrganization = this.organizationRepository.findById((Object)auditEntity.getReferenceId());
                        if (optOrganization.isPresent()) {
                            metadata.put((String)metadataKey, ((Organization)optOrganization.get()).getName());
                        }
                    }
                    catch (TechnicalException e) {
                        this.LOGGER.error("Error finding metadata {}", metadataKey);
                        metadata.put((String)metadataKey, auditEntity.getReferenceId());
                    }
                }
            } else if (Audit.AuditReferenceType.ENVIRONMENT.name().equals(auditEntity.getReferenceType().name())) {
                metadataKey = "ENVIRONMENT:" + auditEntity.getReferenceId() + ":name";
                if (!metadata.containsKey(metadataKey)) {
                    try {
                        Optional optEnvironment = this.environmentRepository.findById((Object)auditEntity.getReferenceId());
                        if (optEnvironment.isPresent()) {
                            metadata.put((String)metadataKey, ((Environment)optEnvironment.get()).getName());
                        }
                    }
                    catch (TechnicalException e) {
                        this.LOGGER.error("Error finding metadata {}", metadataKey);
                        metadata.put((String)metadataKey, auditEntity.getReferenceId());
                    }
                }
            } else if (Audit.AuditReferenceType.APPLICATION.name().equals(auditEntity.getReferenceType().name())) {
                metadataKey = "APPLICATION:" + auditEntity.getReferenceId() + ":name";
                if (!metadata.containsKey(metadataKey)) {
                    try {
                        Optional optApp = this.applicationRepository.findById((Object)auditEntity.getReferenceId());
                        if (optApp.isPresent()) {
                            metadata.put((String)metadataKey, ((Application)optApp.get()).getName());
                        }
                    }
                    catch (TechnicalException e) {
                        this.LOGGER.error("Error finding metadata {}", metadataKey);
                        metadata.put((String)metadataKey, auditEntity.getReferenceId());
                    }
                }
            } else if (Audit.AuditReferenceType.API.name().equals(auditEntity.getReferenceType().name()) && !metadata.containsKey(metadataKey = "API:" + auditEntity.getReferenceId() + ":name")) {
                try {
                    Optional optApi = this.apiRepository.findById((Object)auditEntity.getReferenceId());
                    if (optApi.isPresent()) {
                        metadata.put((String)metadataKey, ((Api)optApi.get()).getName());
                    }
                }
                catch (TechnicalException e) {
                    this.LOGGER.error("Error finding metadata {}", metadataKey);
                    metadata.put((String)metadataKey, auditEntity.getReferenceId());
                }
            }
            if (auditEntity.getProperties() == null) continue;
            for (Map.Entry property : auditEntity.getProperties().entrySet()) {
                metadataKey = new StringJoiner(":").add((CharSequence)property.getKey()).add((CharSequence)property.getValue()).add("name").toString();
                if (metadata.containsKey(metadataKey)) continue;
                String name = (String)property.getValue();
                try {
                    switch (Audit.AuditProperties.valueOf((String)((String)property.getKey()))) {
                        case API: {
                            Optional optApi = this.apiRepository.findById((Object)((String)property.getValue()));
                            if (!optApi.isPresent()) break;
                            name = ((Api)optApi.get()).getName();
                            break;
                        }
                        case APPLICATION: {
                            Optional optApp = this.applicationRepository.findById((Object)((String)property.getValue()));
                            if (!optApp.isPresent()) break;
                            name = ((Application)optApp.get()).getName();
                            break;
                        }
                        case PAGE: {
                            Optional optPage = this.pageRepository.findById((String)property.getValue());
                            if (!optPage.isPresent()) break;
                            name = ((Page)optPage.get()).getName();
                            break;
                        }
                        case PLAN: {
                            Optional optPlan = this.planRepository.findById((Object)((String)property.getValue()));
                            if (!optPlan.isPresent()) break;
                            name = ((Plan)optPlan.get()).getName();
                            break;
                        }
                        case METADATA: {
                            MetadataReferenceType refType = Audit.AuditReferenceType.API.name().equals(auditEntity.getReferenceType()) ? MetadataReferenceType.API : (Audit.AuditReferenceType.APPLICATION.name().equals(auditEntity.getReferenceType()) ? MetadataReferenceType.APPLICATION : MetadataReferenceType.DEFAULT);
                            String refId = refType.equals((Object)MetadataReferenceType.DEFAULT) ? MetadataServiceImpl.getDefaultReferenceId() : auditEntity.getReferenceId();
                            Optional optMetadata = this.metadataRepository.findById((String)property.getValue(), refId, refType);
                            if (!optMetadata.isPresent()) break;
                            name = ((Metadata)optMetadata.get()).getName();
                            break;
                        }
                        case GROUP: {
                            Optional optGroup = this.groupRepository.findById((Object)((String)property.getValue()));
                            if (!optGroup.isPresent()) break;
                            name = ((Group)optGroup.get()).getName();
                            break;
                        }
                        case USER: {
                            try {
                                UserEntity user = this.userService.findById(executionContext, (String)property.getValue());
                                name = user.getDisplayName();
                                break;
                            }
                            catch (UserNotFoundException unfe) {
                                name = (String)property.getValue();
                            }
                        }
                    }
                }
                catch (TechnicalException e) {
                    this.LOGGER.error("Error finding metadata {}", metadataKey);
                    name = (String)property.getValue();
                }
                metadata.put((String)metadataKey, name);
            }
        }
        return metadata;
    }

    @Override
    public void createApiAuditLog(ExecutionContext executionContext, String apiId, Map<Audit.AuditProperties, String> properties, Audit.AuditEvent event, Date createdAt, Object oldValue, Object newValue) {
        this.createAuditLog(executionContext, Audit.AuditReferenceType.API, apiId, properties, event, createdAt, oldValue, newValue);
    }

    @Override
    public void createApplicationAuditLog(ExecutionContext executionContext, String applicationId, Map<Audit.AuditProperties, String> properties, Audit.AuditEvent event, Date createdAt, Object oldValue, Object newValue) {
        this.createAuditLog(executionContext, Audit.AuditReferenceType.APPLICATION, applicationId, properties, event, createdAt, oldValue, newValue);
    }

    @Override
    public void createAuditLog(ExecutionContext executionContext, Map<Audit.AuditProperties, String> properties, Audit.AuditEvent event, Date createdAt, Object oldValue, Object newValue) {
        if (executionContext.hasEnvironmentId()) {
            this.createEnvironmentAuditLog(executionContext, executionContext.getEnvironmentId(), properties, event, createdAt, oldValue, newValue);
        } else {
            this.createOrganizationAuditLog(executionContext, executionContext.getOrganizationId(), properties, event, createdAt, oldValue, newValue);
        }
    }

    private void createEnvironmentAuditLog(ExecutionContext executionContext, String environmentId, Map<Audit.AuditProperties, String> properties, Audit.AuditEvent event, Date createdAt, Object oldValue, Object newValue) {
        this.createAuditLog(executionContext, Audit.AuditReferenceType.ENVIRONMENT, environmentId, properties, event, createdAt, oldValue, newValue);
    }

    @Override
    public void createOrganizationAuditLog(ExecutionContext executionContext, String organizationId, Map<Audit.AuditProperties, String> properties, Audit.AuditEvent event, Date createdAt, Object oldValue, Object newValue) {
        this.createAuditLog(executionContext, Audit.AuditReferenceType.ORGANIZATION, organizationId, properties, event, createdAt, oldValue, newValue);
    }

    @Override
    @Async
    public void createAuditLog(ExecutionContext executionContext, Audit.AuditReferenceType referenceType, String referenceId, Map<Audit.AuditProperties, String> properties, Audit.AuditEvent event, Date createdAt, Object oldValue, Object newValue) {
        Audit audit = new Audit();
        audit.setId(UuidString.generateRandom());
        audit.setOrganizationId(executionContext.getOrganizationId());
        if (executionContext.hasEnvironmentId() && !referenceType.equals((Object)Audit.AuditReferenceType.ORGANIZATION)) {
            audit.setEnvironmentId(executionContext.getEnvironmentId());
        }
        audit.setCreatedAt(createdAt == null ? new Date() : createdAt);
        UserDetails authenticatedUser = this.getAuthenticatedUser();
        Object user = authenticatedUser != null && "token".equals(authenticatedUser.getSource()) ? this.userService.findById(executionContext, authenticatedUser.getUsername()).getDisplayName() + " - (using token \"" + authenticatedUser.getSourceId() + "\")" : this.getAuthenticatedUsernameOrSystem();
        audit.setUser((String)user);
        if (properties != null) {
            HashMap stringStringMap = new HashMap(properties.size());
            properties.forEach((auditProperties, s) -> stringStringMap.put(auditProperties.name(), s));
            audit.setProperties(stringStringMap);
        }
        audit.setReferenceType(referenceType);
        audit.setReferenceId(referenceId);
        audit.setEvent(event.name());
        ObjectNode oldNode = oldValue == null ? this.mapper.createObjectNode() : ((ObjectNode)this.mapper.convertValue(oldValue, ObjectNode.class)).remove(Arrays.asList("updatedAt", "createdAt"));
        ObjectNode newNode = newValue == null ? this.mapper.createObjectNode() : ((ObjectNode)this.mapper.convertValue(newValue, ObjectNode.class)).remove(Arrays.asList("updatedAt", "createdAt"));
        audit.setPatch(JsonDiff.asJson((JsonNode)oldNode, (JsonNode)newNode).toString());
        try {
            this.auditRepository.create((Object)audit);
        }
        catch (TechnicalException e) {
            this.LOGGER.error("Error occurs during the creation of an Audit Log {}.", (Throwable)e);
        }
    }

    private AuditEntity convert(Audit audit) {
        AuditEntity auditEntity = new AuditEntity();
        auditEntity.setReferenceType(AUDIT_REFERENCE_TYPE_AUDIT_REFERENCE_TYPE_MAP.get(audit.getReferenceType()));
        auditEntity.setReferenceId(audit.getReferenceId());
        auditEntity.setEvent(audit.getEvent());
        auditEntity.setProperties(audit.getProperties());
        auditEntity.setUser(audit.getUser());
        auditEntity.setId(audit.getId());
        auditEntity.setPatch(audit.getPatch());
        auditEntity.setCreatedAt(audit.getCreatedAt());
        return auditEntity;
    }

    private String getAuthenticatedUsernameOrSystem() {
        return this.isAuthenticated() ? this.getAuthenticatedUsername() : "system";
    }
}

