/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl.validation;

import io.gravitee.definition.model.v4.endpointgroup.EndpointGroup;
import io.gravitee.definition.model.v4.endpointgroup.service.EndpointGroupServices;
import io.gravitee.definition.model.v4.endpointgroup.service.EndpointServices;
import io.gravitee.definition.model.v4.service.Service;
import io.gravitee.rest.api.service.exceptions.EndpointMissingException;
import io.gravitee.rest.api.service.exceptions.EndpointNameInvalidException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import io.gravitee.rest.api.service.v4.EndpointConnectorPluginService;
import io.gravitee.rest.api.service.v4.exception.EndpointGroupTypeInvalidException;
import io.gravitee.rest.api.service.v4.exception.EndpointGroupTypeMismatchInvalidException;
import io.gravitee.rest.api.service.v4.exception.EndpointTypeInvalidException;
import io.gravitee.rest.api.service.v4.validation.EndpointGroupsValidationService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class EndpointGroupsValidationServiceImpl
extends TransactionalService
implements EndpointGroupsValidationService {
    private final EndpointConnectorPluginService endpointService;

    public EndpointGroupsValidationServiceImpl(EndpointConnectorPluginService endpointService) {
        this.endpointService = endpointService;
    }

    @Override
    public List<EndpointGroup> validateAndSanitize(List<EndpointGroup> endpointGroups) {
        if (endpointGroups == null || endpointGroups.isEmpty()) {
            throw new EndpointMissingException();
        }
        endpointGroups.forEach(endpointGroup -> {
            this.validateName(endpointGroup.getName());
            this.validateEndpointGroupType(endpointGroup.getType());
            this.validateServices(endpointGroup.getServices());
            this.validateEndpointsExistence((EndpointGroup)endpointGroup);
            if (endpointGroup.getEndpoints() != null && !endpointGroups.isEmpty()) {
                endpointGroup.getEndpoints().forEach(endpoint -> {
                    this.validateName(endpoint.getName());
                    this.validateEndpointType(endpoint.getType());
                    this.validateServices(endpoint.getServices());
                    endpoint.setConfiguration(this.endpointService.validateConnectorConfiguration(endpoint.getType(), endpoint.getConfiguration()));
                });
            }
            this.validateEndpointsMatchType((EndpointGroup)endpointGroup);
        });
        return endpointGroups;
    }

    private void validateEndpointsExistence(EndpointGroup endpointGroup) {
        Service endpointDiscoveryService;
        Service service = endpointDiscoveryService = endpointGroup.getServices() == null ? null : endpointGroup.getServices().getDiscovery();
        if (!(endpointDiscoveryService != null && endpointDiscoveryService.isEnabled() || endpointGroup.getEndpoints() != null && !endpointGroup.getEndpoints().isEmpty())) {
            throw new EndpointMissingException();
        }
    }

    private void validateDiscovery(Service discovery) {
    }

    private void validateEndpointType(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            throw new EndpointTypeInvalidException(type);
        }
    }

    private void validateEndpointGroupType(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            throw new EndpointGroupTypeInvalidException(type);
        }
    }

    private void validateEndpointsMatchType(EndpointGroup endpointGroup) {
        boolean allMatchGroupType;
        if (endpointGroup.getEndpoints() != null && !endpointGroup.getEndpoints().isEmpty() && !(allMatchGroupType = endpointGroup.getEndpoints().stream().allMatch(endpoint -> endpointGroup.getType().equals(endpoint.getType())))) {
            throw new EndpointGroupTypeMismatchInvalidException(endpointGroup.getType());
        }
    }

    private void validateHealthCheck(Service healthCheck) {
    }

    private void validateName(String name) {
        if (name != null && name.contains(":")) {
            throw new EndpointNameInvalidException(name);
        }
    }

    private void validateServices(EndpointGroupServices services) {
        if (services != null) {
            if (services.getDiscovery() != null) {
                this.validateDiscovery(services.getDiscovery());
            }
            if (services.getHealthCheck() != null) {
                this.validateHealthCheck(services.getHealthCheck());
            }
        }
    }

    private void validateServices(EndpointServices services) {
        if (services != null && services.getHealthCheck() != null) {
            this.validateHealthCheck(services.getHealthCheck());
        }
    }
}

