/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.validator.jsonschema;

import com.github.fge.jackson.NodeType;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.format.AbstractFormatAttribute;
import com.github.fge.jsonschema.format.FormatAttribute;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class JavaRegexFormatAttribute
extends AbstractFormatAttribute {
    private static final FormatAttribute instance = new JavaRegexFormatAttribute();
    public static final String NAME = "java-regex";

    private JavaRegexFormatAttribute() {
        super(NAME, NodeType.STRING, new NodeType[0]);
    }

    public static FormatAttribute getInstance() {
        return instance;
    }

    public void validate(ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
        String input = data.getInstance().getNode().textValue();
        try {
            Pattern.compile(input);
        }
        catch (PatternSyntaxException pse) {
            ProcessingMessage processingMessage = data.newMessage().put("domain", "validation").put("keyword", "format").put("attribute", NAME).setMessage("Invalid java regular expression [" + input + "]").put("value", input);
            report.error(processingMessage);
        }
    }
}

